/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.decoder;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.multibindings.MapBinder;
import io.prestosql.decoder.DispatchingRowDecoderFactory;
import io.prestosql.decoder.RowDecoderFactory;
import io.prestosql.decoder.avro.AvroRowDecoderFactory;
import io.prestosql.decoder.csv.CsvRowDecoderFactory;
import io.prestosql.decoder.dummy.DummyRowDecoderFactory;
import io.prestosql.decoder.json.JsonRowDecoderFactory;
import io.prestosql.decoder.raw.RawRowDecoderFactory;

public class DecoderModule
implements Module {
    public void configure(Binder binder) {
        MapBinder decoderFactoriesByName = MapBinder.newMapBinder((Binder)binder, String.class, RowDecoderFactory.class);
        decoderFactoriesByName.addBinding((Object)"dummy").to(DummyRowDecoderFactory.class).in(Scopes.SINGLETON);
        decoderFactoriesByName.addBinding((Object)"csv").to(CsvRowDecoderFactory.class).in(Scopes.SINGLETON);
        decoderFactoriesByName.addBinding((Object)"json").to(JsonRowDecoderFactory.class).in(Scopes.SINGLETON);
        decoderFactoriesByName.addBinding((Object)"raw").to(RawRowDecoderFactory.class).in(Scopes.SINGLETON);
        decoderFactoriesByName.addBinding((Object)"avro").to(AvroRowDecoderFactory.class).in(Scopes.SINGLETON);
        binder.bind(DispatchingRowDecoderFactory.class).in(Scopes.SINGLETON);
    }
}

