/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.resolver;

import com.google.common.collect.ImmutableList;
import io.airlift.resolver.internal.ConsoleRepositoryListener;
import io.airlift.resolver.internal.ConsoleTransferListener;
import io.airlift.resolver.internal.Slf4jLoggerManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Exclusion;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.apache.maven.repository.internal.MavenRepositorySystemSession;
import org.apache.maven.repository.internal.MavenServiceLocator;
import org.codehaus.plexus.ContainerConfiguration;
import org.codehaus.plexus.DefaultContainerConfiguration;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.PlexusContainerException;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.logging.LoggerManager;
import org.sonatype.aether.RepositoryListener;
import org.sonatype.aether.RepositorySystem;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.collection.CollectRequest;
import org.sonatype.aether.connector.async.AsyncRepositoryConnectorFactory;
import org.sonatype.aether.connector.file.FileRepositoryConnectorFactory;
import org.sonatype.aether.impl.internal.SimpleLocalRepositoryManager;
import org.sonatype.aether.repository.LocalRepositoryManager;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.resolution.ArtifactResult;
import org.sonatype.aether.resolution.DependencyRequest;
import org.sonatype.aether.resolution.DependencyResolutionException;
import org.sonatype.aether.resolution.DependencyResult;
import org.sonatype.aether.spi.connector.RepositoryConnectorFactory;
import org.sonatype.aether.transfer.TransferListener;
import org.sonatype.aether.util.artifact.DefaultArtifact;
import org.sonatype.aether.util.filter.DependencyFilterUtils;

public class ArtifactResolver {
    public static final String USER_LOCAL_REPO = System.getProperty("user.home") + "/.m2/repository";
    public static final String MAVEN_CENTRAL_URI = "http://repo1.maven.org/maven2/";
    private final RepositorySystem repositorySystem;
    private final MavenRepositorySystemSession repositorySystemSession;
    private final List<RemoteRepository> repositories;

    public ArtifactResolver(String localRepositoryDir, String ... remoteRepositoryUris) {
        this(localRepositoryDir, Arrays.asList(remoteRepositoryUris));
    }

    public ArtifactResolver(String localRepositoryDir, List<String> remoteRepositoryUris) {
        MavenServiceLocator locator = new MavenServiceLocator();
        locator.addService(RepositoryConnectorFactory.class, FileRepositoryConnectorFactory.class);
        locator.addService(RepositoryConnectorFactory.class, AsyncRepositoryConnectorFactory.class);
        this.repositorySystem = (RepositorySystem)locator.getService(RepositorySystem.class);
        this.repositorySystemSession = new MavenRepositorySystemSession();
        SimpleLocalRepositoryManager localRepositoryManager = new SimpleLocalRepositoryManager(localRepositoryDir);
        this.repositorySystemSession.setLocalRepositoryManager((LocalRepositoryManager)localRepositoryManager);
        this.repositorySystemSession.setTransferListener((TransferListener)new ConsoleTransferListener());
        this.repositorySystemSession.setRepositoryListener((RepositoryListener)new ConsoleRepositoryListener());
        ArrayList<RemoteRepository> repositories = new ArrayList<RemoteRepository>(remoteRepositoryUris.size());
        int index = 0;
        for (String repositoryUri : remoteRepositoryUris) {
            repositories.add(new RemoteRepository("repo-" + index++, "default", repositoryUri));
        }
        this.repositories = Collections.unmodifiableList(repositories);
    }

    public List<Artifact> resolveArtifacts(Artifact ... sourceArtifacts) {
        return this.resolveArtifacts(Arrays.asList(sourceArtifacts));
    }

    public List<Artifact> resolveArtifacts(Iterable<? extends Artifact> sourceArtifacts) {
        CollectRequest collectRequest = new CollectRequest();
        for (Artifact artifact : sourceArtifacts) {
            collectRequest.addDependency(new org.sonatype.aether.graph.Dependency(artifact, "runtime"));
        }
        for (RemoteRepository remoteRepository : this.repositories) {
            collectRequest.addRepository(remoteRepository);
        }
        DependencyRequest dependencyRequest = new DependencyRequest(collectRequest, DependencyFilterUtils.classpathFilter((String[])new String[]{"runtime"}));
        return this.resolveArtifacts(dependencyRequest);
    }

    public List<Artifact> resolvePom(File pomFile) {
        if (pomFile == null) {
            throw new RuntimeException("pomFile is null");
        }
        MavenProject pom = this.getMavenProject(pomFile);
        Artifact rootArtifact = this.getProjectArtifact(pom);
        CollectRequest collectRequest = new CollectRequest();
        for (Dependency dependency : pom.getDependencies()) {
            collectRequest.addDependency(this.toAetherDependency(dependency));
        }
        for (RemoteRepository repository : pom.getRemoteProjectRepositories()) {
            collectRequest.addRepository(repository);
        }
        for (RemoteRepository repository : this.repositories) {
            collectRequest.addRepository(repository);
        }
        if (pom.getDependencyManagement() != null) {
            for (Dependency managedDependency : pom.getDependencyManagement().getDependencies()) {
                collectRequest.addManagedDependency(this.toAetherDependency(managedDependency));
            }
        }
        DependencyRequest dependencyRequest = new DependencyRequest(collectRequest, DependencyFilterUtils.classpathFilter((String[])new String[]{"runtime"}));
        List<Artifact> artifacts = this.resolveArtifacts(dependencyRequest);
        Map modules = this.getSiblingModules(pom).stream().collect(Collectors.toMap(ArtifactResolver::getArtifactKey, Function.identity()));
        return (List)Stream.concat(Stream.of(rootArtifact), artifacts.stream().map(artifact -> modules.getOrDefault(ArtifactResolver.getArtifactKey(artifact), artifact))).collect(ImmutableList.toImmutableList());
    }

    private MavenProject getMavenProject(File pomFile) {
        try {
            PlexusContainer container = ArtifactResolver.container();
            org.apache.maven.repository.RepositorySystem lrs = (org.apache.maven.repository.RepositorySystem)container.lookup(org.apache.maven.repository.RepositorySystem.class);
            ProjectBuilder projectBuilder = (ProjectBuilder)container.lookup(ProjectBuilder.class);
            DefaultProjectBuildingRequest request = new DefaultProjectBuildingRequest();
            request.setSystemProperties(this.requiredSystemProperties());
            request.setRepositorySession((RepositorySystemSession)this.repositorySystemSession);
            request.setProcessPlugins(false);
            request.setLocalRepository(lrs.createDefaultLocalRepository());
            request.setRemoteRepositories(Arrays.asList((Object[])new ArtifactRepository[]{lrs.createDefaultRemoteRepository()}.clone()));
            ProjectBuildingResult result = projectBuilder.build(pomFile, (ProjectBuildingRequest)request);
            return result.getProject();
        }
        catch (Exception e) {
            throw new RuntimeException("Error loading pom: " + pomFile.getAbsolutePath(), e);
        }
    }

    private Artifact getProjectArtifact(MavenProject pom) {
        return new DefaultArtifact(pom.getArtifact().getGroupId(), pom.getArtifact().getArtifactId(), pom.getArtifact().getClassifier(), pom.getArtifact().getType(), pom.getArtifact().getVersion(), null, new File(pom.getModel().getBuild().getOutputDirectory()));
    }

    private List<Artifact> getSiblingModules(MavenProject module) {
        if (!module.hasParent() || module.getParentFile() == null) {
            return ImmutableList.of();
        }
        MavenProject parent = module.getParent();
        String parentDir = module.getParentFile().getParent();
        return (List)parent.getModules().stream().map(moduleName -> new File(parentDir, moduleName + "/pom.xml")).filter(File::isFile).map(this::getMavenProject).map(this::getProjectArtifact).collect(ImmutableList.toImmutableList());
    }

    private static String getArtifactKey(Artifact artifact) {
        return String.format("%s:%s:%s:%s", artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getClassifier());
    }

    private Properties requiredSystemProperties() {
        Properties properties = new Properties();
        properties.setProperty("java.version", System.getProperty("java.version"));
        return properties;
    }

    private org.sonatype.aether.graph.Dependency toAetherDependency(Dependency dependency) {
        DefaultArtifact artifact = new DefaultArtifact(dependency.getGroupId(), dependency.getArtifactId(), dependency.getClassifier(), dependency.getType(), dependency.getVersion());
        ImmutableList.Builder exclusions = ImmutableList.builder();
        for (Exclusion exclusion : dependency.getExclusions()) {
            exclusions.add((Object)new org.sonatype.aether.graph.Exclusion(exclusion.getGroupId(), exclusion.getArtifactId(), null, "*"));
        }
        return new org.sonatype.aether.graph.Dependency((Artifact)artifact, dependency.getScope(), dependency.isOptional(), (Collection)exclusions.build());
    }

    private List<Artifact> resolveArtifacts(DependencyRequest dependencyRequest) {
        DependencyResult dependencyResult;
        try {
            dependencyResult = this.repositorySystem.resolveDependencies((RepositorySystemSession)this.repositorySystemSession, dependencyRequest);
        }
        catch (DependencyResolutionException e) {
            dependencyResult = e.getResult();
        }
        List artifactResults = dependencyResult.getArtifactResults();
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>(artifactResults.size());
        for (ArtifactResult artifactResult : artifactResults) {
            if (artifactResult.isMissing()) {
                artifacts.add(artifactResult.getRequest().getArtifact());
                continue;
            }
            artifacts.add(artifactResult.getArtifact());
        }
        return Collections.unmodifiableList(artifacts);
    }

    private static PlexusContainer container() {
        try {
            ClassWorld classWorld = new ClassWorld("plexus.core", Thread.currentThread().getContextClassLoader());
            ContainerConfiguration cc = new DefaultContainerConfiguration().setClassWorld(classWorld).setRealm(null).setName("maven");
            DefaultPlexusContainer container = new DefaultPlexusContainer(cc);
            container.setLookupRealm(null);
            container.setLoggerManager((LoggerManager)new Slf4jLoggerManager());
            container.getLoggerManager().setThresholds(1);
            return container;
        }
        catch (PlexusContainerException e) {
            throw new RuntimeException("Error loading Maven system", e);
        }
    }
}

