/*
 * Decompiled with CFR 0.152.
 */
package com.google.re2j;

import com.google.re2j.RE2;
import com.google.re2j.Utils;
import io.airlift.slice.Slice;
import java.lang.reflect.Field;
import sun.misc.Unsafe;

final class MachineInput {
    private static final Unsafe unsafe;
    static final byte EOF = -1;
    final Slice slice;
    final Object base;
    final long address;
    final int length;

    static MachineInput fromUTF8(Slice slice) {
        return new MachineInput(slice);
    }

    MachineInput(Slice slice) {
        this.slice = slice;
        this.base = slice.getBase();
        this.address = slice.getAddress();
        this.length = slice.length();
    }

    byte getByte(int i) {
        if (i >= this.length) {
            return -1;
        }
        if (i < 0) {
            throw new IndexOutOfBoundsException("index less than zero (" + i + ")");
        }
        return this.getByteUnchecked(i);
    }

    byte getByteUnchecked(int i) {
        return unsafe.getByte(this.base, this.address + (long)i);
    }

    int index(RE2 re2, int pos) {
        int i = Utils.indexOf(this.slice, re2.prefixUTF8, pos);
        return i < 0 ? i : i - pos;
    }

    int endPos() {
        return this.length;
    }

    static {
        try {
            Field field = Unsafe.class.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            unsafe = (Unsafe)field.get(null);
            if (unsafe == null) {
                throw new RuntimeException("Unsafe access not available");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

