/*
 * Decompiled with CFR 0.152.
 */
package com.google.re2j;

import com.google.re2j.Matcher;
import com.google.re2j.Options;
import com.google.re2j.RE2;
import io.airlift.slice.Slice;
import java.io.Serializable;

public final class Pattern
implements Serializable {
    public static final int CASE_INSENSITIVE = 1;
    public static final int DOTALL = 2;
    public static final int MULTILINE = 4;
    public static final int DISABLE_UNICODE_GROUPS = 8;
    private final String pattern;
    private final int flags;
    private final Options options;
    private final transient RE2 re2;
    private static final long serialVersionUID = 0L;

    Pattern(String pattern, int flags, RE2 re2, Options options) {
        if (pattern == null) {
            throw new NullPointerException("pattern is null");
        }
        if (re2 == null) {
            throw new NullPointerException("re2 is null");
        }
        this.pattern = pattern;
        this.flags = flags;
        this.options = options;
        this.re2 = re2;
    }

    public int flags() {
        return this.flags;
    }

    public Options options() {
        return this.options;
    }

    public String pattern() {
        return this.pattern;
    }

    RE2 re2() {
        return this.re2;
    }

    public static Pattern compile(String regex) {
        return Pattern.compile(regex, Options.DEFAULT_OPTIONS);
    }

    public static Pattern compile(String regex, Options options) {
        return Pattern.compile(regex, regex, 0, options);
    }

    public static Pattern compile(String regex, int flags) {
        return Pattern.compile(regex, flags, Options.DEFAULT_OPTIONS);
    }

    public static Pattern compile(String regex, int flags, Options options) {
        String flregex = regex;
        if ((flags & 1) != 0) {
            flregex = "(?i)" + flregex;
        }
        if ((flags & 2) != 0) {
            flregex = "(?s)" + flregex;
        }
        if ((flags & 4) != 0) {
            flregex = "(?m)" + flregex;
        }
        if ((flags & 0xFFFFFFF0) != 0) {
            throw new IllegalArgumentException("Flags should only be a combination of MULTILINE, DOTALL, CASE_INSENSITIVE, DISABLE_UNICODE_GROUPS");
        }
        return Pattern.compile(flregex, regex, flags, options);
    }

    private static Pattern compile(String flregex, String regex, int flags, Options options) {
        int re2Flags = 212;
        if ((flags & 8) != 0) {
            re2Flags &= 0xFFFFFF7F;
        }
        return new Pattern(regex, flags, RE2.compileImpl(flregex, re2Flags, RE2.MatchKind.FIRST_MATCH, options), options);
    }

    public static boolean matches(String regex, Slice input) {
        return Pattern.matches(regex, input, Options.DEFAULT_OPTIONS);
    }

    public static boolean matches(String regex, Slice input, Options options) {
        return Pattern.compile(regex, options).matches(input);
    }

    public boolean matches(Slice input) {
        return this.re2.match(input, 0, RE2.Anchor.ANCHOR_BOTH, null, 0);
    }

    public static boolean find(String regex, Slice input) {
        return Pattern.find(regex, input, Options.DEFAULT_OPTIONS);
    }

    public static boolean find(String regex, Slice input, Options options) {
        return Pattern.compile(regex, options).find(input);
    }

    public boolean find(Slice input) {
        return this.re2.match(input, 0, RE2.Anchor.UNANCHORED, null, 0);
    }

    public Matcher matcher(Slice input) {
        return new Matcher(this, input);
    }

    public Slice[] split(Slice input) {
        return this.split(input, 0);
    }

    public Slice[] split(Slice input, int limit) {
        return this.split(new Matcher(this, input), limit);
    }

    private Slice[] split(Matcher m, int limit) {
        int matchCount = 0;
        int arraySize = 0;
        int last = 0;
        while (m.find()) {
            ++matchCount;
            if (limit != 0 || last < m.start()) {
                arraySize = matchCount;
            }
            last = m.end();
        }
        if (last < m.inputLength() || limit != 0) {
            arraySize = ++matchCount;
        }
        int trunc = 0;
        if (limit > 0 && arraySize > limit) {
            arraySize = limit;
            trunc = 1;
        }
        Slice[] array = new Slice[arraySize];
        int i = 0;
        last = 0;
        m.reset();
        while (m.find() && i < arraySize - trunc) {
            array[i++] = m.substring(last, m.start());
            last = m.end();
        }
        if (i < arraySize) {
            array[i] = m.substring(last, m.inputLength());
        }
        return array;
    }

    public static String quote(String s) {
        return RE2.quoteMeta(s);
    }

    public String toString() {
        return this.pattern;
    }

    public int groupCount() {
        return this.re2.numberOfCapturingGroups();
    }

    Object readResolve() {
        return Pattern.compile(this.pattern, this.flags, this.options);
    }
}

