/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.event;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.json.JsonCodec;
import io.airlift.log.Logger;
import io.airlift.node.NodeInfo;
import io.airlift.stats.Distribution;
import io.prestosql.SessionRepresentation;
import io.prestosql.client.NodeVersion;
import io.prestosql.connector.CatalogName;
import io.prestosql.cost.StatsAndCosts;
import io.prestosql.event.QueryMonitorConfig;
import io.prestosql.eventlistener.EventListenerManager;
import io.prestosql.execution.Column;
import io.prestosql.execution.ExecutionFailureInfo;
import io.prestosql.execution.Input;
import io.prestosql.execution.QueryInfo;
import io.prestosql.execution.QueryState;
import io.prestosql.execution.QueryStats;
import io.prestosql.execution.StageInfo;
import io.prestosql.execution.TaskInfo;
import io.prestosql.execution.TaskState;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.SessionPropertyManager;
import io.prestosql.operator.OperatorStats;
import io.prestosql.operator.TableFinishInfo;
import io.prestosql.operator.TaskStats;
import io.prestosql.server.BasicQueryInfo;
import io.prestosql.spi.QueryId;
import io.prestosql.spi.eventlistener.QueryCompletedEvent;
import io.prestosql.spi.eventlistener.QueryContext;
import io.prestosql.spi.eventlistener.QueryCreatedEvent;
import io.prestosql.spi.eventlistener.QueryFailureInfo;
import io.prestosql.spi.eventlistener.QueryIOMetadata;
import io.prestosql.spi.eventlistener.QueryInputMetadata;
import io.prestosql.spi.eventlistener.QueryMetadata;
import io.prestosql.spi.eventlistener.QueryOutputMetadata;
import io.prestosql.spi.eventlistener.QueryStatistics;
import io.prestosql.spi.eventlistener.StageCpuDistribution;
import io.prestosql.spi.resourcegroups.ResourceGroupId;
import io.prestosql.sql.planner.planprinter.PlanPrinter;
import io.prestosql.sql.planner.planprinter.ValuePrinter;
import io.prestosql.transaction.TransactionId;
import java.time.Duration;
import java.time.Instant;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.joda.time.DateTime;

public class QueryMonitor {
    private static final Logger log = Logger.get(QueryMonitor.class);
    private final JsonCodec<StageInfo> stageInfoCodec;
    private final JsonCodec<OperatorStats> operatorStatsCodec;
    private final JsonCodec<ExecutionFailureInfo> executionFailureInfoCodec;
    private final JsonCodec<StatsAndCosts> statsAndCostsCodec;
    private final EventListenerManager eventListenerManager;
    private final String serverVersion;
    private final String serverAddress;
    private final String environment;
    private final SessionPropertyManager sessionPropertyManager;
    private final Metadata metadata;
    private final int maxJsonLimit;

    @Inject
    public QueryMonitor(JsonCodec<StageInfo> stageInfoCodec, JsonCodec<OperatorStats> operatorStatsCodec, JsonCodec<ExecutionFailureInfo> executionFailureInfoCodec, JsonCodec<StatsAndCosts> statsAndCostsCodec, EventListenerManager eventListenerManager, NodeInfo nodeInfo, NodeVersion nodeVersion, SessionPropertyManager sessionPropertyManager, Metadata metadata, QueryMonitorConfig config) {
        this.eventListenerManager = Objects.requireNonNull(eventListenerManager, "eventListenerManager is null");
        this.stageInfoCodec = Objects.requireNonNull(stageInfoCodec, "stageInfoCodec is null");
        this.operatorStatsCodec = Objects.requireNonNull(operatorStatsCodec, "operatorStatsCodec is null");
        this.statsAndCostsCodec = Objects.requireNonNull(statsAndCostsCodec, "statsAndCostsCodec is null");
        this.executionFailureInfoCodec = Objects.requireNonNull(executionFailureInfoCodec, "executionFailureInfoCodec is null");
        this.serverVersion = Objects.requireNonNull(nodeVersion, "nodeVersion is null").toString();
        this.serverAddress = Objects.requireNonNull(nodeInfo, "nodeInfo is null").getExternalAddress();
        this.environment = Objects.requireNonNull(nodeInfo, "nodeInfo is null").getEnvironment();
        this.sessionPropertyManager = Objects.requireNonNull(sessionPropertyManager, "sessionPropertyManager is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.maxJsonLimit = Math.toIntExact(Objects.requireNonNull(config, "config is null").getMaxOutputStageJsonSize().toBytes());
    }

    public void queryCreatedEvent(BasicQueryInfo queryInfo) {
        this.eventListenerManager.queryCreated(new QueryCreatedEvent(queryInfo.getQueryStats().getCreateTime().toDate().toInstant(), this.createQueryContext(queryInfo.getSession(), queryInfo.getResourceGroupId()), new QueryMetadata(queryInfo.getQueryId().toString(), queryInfo.getSession().getTransactionId().map(TransactionId::toString), queryInfo.getQuery(), queryInfo.getUpdateType(), queryInfo.getPreparedQuery(), QueryState.QUEUED.toString(), (List)ImmutableList.of(), (List)ImmutableList.of(), queryInfo.getSelf(), Optional.empty(), Optional.empty())));
    }

    public void queryImmediateFailureEvent(BasicQueryInfo queryInfo, ExecutionFailureInfo failure) {
        this.eventListenerManager.queryCompleted(new QueryCompletedEvent(new QueryMetadata(queryInfo.getQueryId().toString(), queryInfo.getSession().getTransactionId().map(TransactionId::toString), queryInfo.getQuery(), queryInfo.getUpdateType(), queryInfo.getPreparedQuery(), queryInfo.getState().toString(), (List)ImmutableList.of(), (List)ImmutableList.of(), queryInfo.getSelf(), Optional.empty(), Optional.empty()), new QueryStatistics(Duration.ofMillis(0L), Duration.ofMillis(0L), Duration.ofMillis(queryInfo.getQueryStats().getQueuedTime().toMillis()), Optional.empty(), Optional.empty(), Optional.empty(), 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0.0, (List)ImmutableList.of(), 0, true, (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty()), this.createQueryContext(queryInfo.getSession(), queryInfo.getResourceGroupId()), new QueryIOMetadata((List)ImmutableList.of(), Optional.empty()), this.createQueryFailureInfo(failure, Optional.empty()), (List)ImmutableList.of(), Instant.ofEpochMilli(queryInfo.getQueryStats().getCreateTime().getMillis()), Instant.ofEpochMilli(queryInfo.getQueryStats().getEndTime().getMillis()), Instant.ofEpochMilli(queryInfo.getQueryStats().getEndTime().getMillis())));
        QueryMonitor.logQueryTimeline(queryInfo);
    }

    public void queryCompletedEvent(QueryInfo queryInfo) {
        QueryStats queryStats = queryInfo.getQueryStats();
        this.eventListenerManager.queryCompleted(new QueryCompletedEvent(this.createQueryMetadata(queryInfo), this.createQueryStatistics(queryInfo), this.createQueryContext(queryInfo.getSession(), queryInfo.getResourceGroupId()), QueryMonitor.getQueryIOMetadata(queryInfo), this.createQueryFailureInfo(queryInfo.getFailureInfo(), queryInfo.getOutputStage()), queryInfo.getWarnings(), Instant.ofEpochMilli(queryStats.getCreateTime().getMillis()), Instant.ofEpochMilli(queryStats.getExecutionStartTime().getMillis()), Instant.ofEpochMilli(queryStats.getEndTime() != null ? queryStats.getEndTime().getMillis() : 0L)));
        QueryMonitor.logQueryTimeline(queryInfo);
    }

    private QueryMetadata createQueryMetadata(QueryInfo queryInfo) {
        return new QueryMetadata(queryInfo.getQueryId().toString(), queryInfo.getSession().getTransactionId().map(TransactionId::toString), queryInfo.getQuery(), Optional.ofNullable(queryInfo.getUpdateType()), queryInfo.getPreparedQuery(), queryInfo.getState().toString(), queryInfo.getReferencedTables(), queryInfo.getRoutines(), queryInfo.getSelf(), this.createTextQueryPlan(queryInfo), queryInfo.getOutputStage().flatMap(stage -> this.stageInfoCodec.toJsonWithLengthLimit(stage, this.maxJsonLimit)));
    }

    private QueryStatistics createQueryStatistics(QueryInfo queryInfo) {
        ImmutableList.Builder operatorSummaries = ImmutableList.builder();
        for (OperatorStats summary : queryInfo.getQueryStats().getOperatorSummaries()) {
            operatorSummaries.add((Object)this.operatorStatsCodec.toJson((Object)summary));
        }
        Optional<StatsAndCosts> planNodeStatsAndCosts = queryInfo.getOutputStage().map(StatsAndCosts::create);
        Optional<String> serializedPlanNodeStatsAndCosts = planNodeStatsAndCosts.map(arg_0 -> this.statsAndCostsCodec.toJson(arg_0));
        QueryStats queryStats = queryInfo.getQueryStats();
        return new QueryStatistics(Duration.ofMillis(queryStats.getTotalCpuTime().toMillis()), Duration.ofMillis(queryStats.getElapsedTime().toMillis()), Duration.ofMillis(queryStats.getQueuedTime().toMillis()), Optional.of(Duration.ofMillis(queryStats.getResourceWaitingTime().toMillis())), Optional.of(Duration.ofMillis(queryStats.getAnalysisTime().toMillis())), Optional.of(Duration.ofMillis(queryStats.getExecutionTime().toMillis())), queryStats.getPeakUserMemoryReservation().toBytes(), queryStats.getPeakTotalMemoryReservation().toBytes(), queryStats.getPeakTaskUserMemory().toBytes(), queryStats.getPeakTaskTotalMemory().toBytes(), queryStats.getPhysicalInputDataSize().toBytes(), queryStats.getPhysicalInputPositions(), queryStats.getInternalNetworkInputDataSize().toBytes(), queryStats.getInternalNetworkInputPositions(), queryStats.getRawInputDataSize().toBytes(), queryStats.getRawInputPositions(), queryStats.getOutputDataSize().toBytes(), queryStats.getOutputPositions(), queryStats.getLogicalWrittenDataSize().toBytes(), queryStats.getWrittenPositions(), queryStats.getCumulativeUserMemory(), queryStats.getStageGcStatistics(), queryStats.getCompletedDrivers(), queryInfo.isCompleteInfo(), QueryMonitor.getCpuDistributions(queryInfo), (List)operatorSummaries.build(), serializedPlanNodeStatsAndCosts);
    }

    private QueryContext createQueryContext(SessionRepresentation session, Optional<ResourceGroupId> resourceGroup) {
        return new QueryContext(session.getUser(), session.getPrincipal(), session.getTraceToken(), session.getRemoteUserAddress(), session.getUserAgent(), session.getClientInfo(), session.getClientTags(), session.getClientCapabilities(), session.getSource(), session.getCatalog(), session.getSchema(), resourceGroup, QueryMonitor.mergeSessionAndCatalogProperties(session), session.getResourceEstimates(), this.serverAddress, this.serverVersion, this.environment);
    }

    private Optional<String> createTextQueryPlan(QueryInfo queryInfo) {
        try {
            if (queryInfo.getOutputStage().isPresent()) {
                return Optional.of(PlanPrinter.textDistributedPlan(queryInfo.getOutputStage().get(), new ValuePrinter(this.metadata, queryInfo.getSession().toSession(this.sessionPropertyManager)), false));
            }
        }
        catch (Exception e) {
            log.warn((Throwable)e, "Error creating explain plan for query %s", new Object[]{queryInfo.getQueryId()});
        }
        return Optional.empty();
    }

    private static QueryIOMetadata getQueryIOMetadata(QueryInfo queryInfo) {
        ImmutableList.Builder inputs = ImmutableList.builder();
        for (Input input : queryInfo.getInputs()) {
            inputs.add((Object)new QueryInputMetadata(input.getCatalogName(), input.getSchema(), input.getTable(), input.getColumns().stream().map(Column::getName).collect(Collectors.toList()), input.getConnectorInfo()));
        }
        Optional<Object> output = Optional.empty();
        if (queryInfo.getOutput().isPresent()) {
            Optional<TableFinishInfo> tableFinishInfo = queryInfo.getQueryStats().getOperatorSummaries().stream().map(OperatorStats::getInfo).filter(TableFinishInfo.class::isInstance).map(TableFinishInfo.class::cast).findFirst();
            output = Optional.of(new QueryOutputMetadata(queryInfo.getOutput().get().getCatalogName(), queryInfo.getOutput().get().getSchema(), queryInfo.getOutput().get().getTable(), tableFinishInfo.map(TableFinishInfo::getConnectorOutputMetadata), tableFinishInfo.map(TableFinishInfo::isJsonLengthLimitExceeded)));
        }
        return new QueryIOMetadata((List)inputs.build(), output);
    }

    private Optional<QueryFailureInfo> createQueryFailureInfo(ExecutionFailureInfo failureInfo, Optional<StageInfo> outputStage) {
        if (failureInfo == null) {
            return Optional.empty();
        }
        Optional<String> failedTask = outputStage.flatMap(QueryMonitor::findFailedTask);
        return Optional.of(new QueryFailureInfo(failureInfo.getErrorCode(), Optional.ofNullable(failureInfo.getType()), Optional.ofNullable(failureInfo.getMessage()), failedTask.map(task -> task.getTaskStatus().getTaskId().toString()), failedTask.map(task -> task.getTaskStatus().getSelf().getHost()), this.executionFailureInfoCodec.toJson((Object)failureInfo)));
    }

    private static Optional<TaskInfo> findFailedTask(StageInfo stageInfo) {
        for (StageInfo subStage : stageInfo.getSubStages()) {
            Optional<TaskInfo> task = QueryMonitor.findFailedTask(subStage);
            if (!task.isPresent()) continue;
            return task;
        }
        return stageInfo.getTasks().stream().filter(taskInfo -> taskInfo.getTaskStatus().getState() == TaskState.FAILED).findFirst();
    }

    private static Map<String, String> mergeSessionAndCatalogProperties(SessionRepresentation session) {
        LinkedHashMap<String, String> mergedProperties = new LinkedHashMap<String, String>(session.getSystemProperties());
        for (Map.Entry<String, Map<String, String>> entry : session.getUnprocessedCatalogProperties().entrySet()) {
            for (Map.Entry<String, String> entry2 : entry.getValue().entrySet()) {
                mergedProperties.put(entry.getKey() + "." + entry2.getKey(), entry2.getValue());
            }
        }
        for (Map.Entry<Object, Map<String, String>> entry : session.getCatalogProperties().entrySet()) {
            for (Map.Entry<String, String> entry2 : entry.getValue().entrySet()) {
                mergedProperties.put(((CatalogName)entry.getKey()).getCatalogName() + "." + entry2.getKey(), entry2.getValue());
            }
        }
        return ImmutableMap.copyOf(mergedProperties);
    }

    private static void logQueryTimeline(QueryInfo queryInfo) {
        try {
            QueryStats queryStats = queryInfo.getQueryStats();
            DateTime queryStartTime = queryStats.getCreateTime();
            DateTime queryEndTime = queryStats.getEndTime();
            if (queryStartTime == null || queryEndTime == null) {
                return;
            }
            long planning = queryStats.getPlanningTime().toMillis();
            long waiting = queryStats.getResourceWaitingTime().toMillis();
            List<StageInfo> stages = StageInfo.getAllStages(queryInfo.getOutputStage());
            long firstTaskStartTime = queryEndTime.getMillis();
            long lastTaskStartTime = queryStartTime.getMillis() + planning;
            long lastTaskEndTime = queryStartTime.getMillis() + planning;
            for (StageInfo stage : stages) {
                if (!stage.getSubStages().isEmpty()) continue;
                for (TaskInfo taskInfo : stage.getTasks()) {
                    DateTime endTime;
                    DateTime lastStartTime;
                    TaskStats taskStats = taskInfo.getStats();
                    DateTime firstStartTime = taskStats.getFirstStartTime();
                    if (firstStartTime != null) {
                        firstTaskStartTime = Math.min(firstStartTime.getMillis(), firstTaskStartTime);
                    }
                    if ((lastStartTime = taskStats.getLastStartTime()) != null) {
                        lastTaskStartTime = Math.max(lastStartTime.getMillis(), lastTaskStartTime);
                    }
                    if ((endTime = taskStats.getEndTime()) == null) continue;
                    lastTaskEndTime = Math.max(endTime.getMillis(), lastTaskEndTime);
                }
            }
            long elapsed = Math.max(queryEndTime.getMillis() - queryStartTime.getMillis(), 0L);
            long scheduling = Math.max(firstTaskStartTime - queryStartTime.getMillis() - planning, 0L);
            long running = Math.max(lastTaskEndTime - firstTaskStartTime, 0L);
            long finishing = Math.max(queryEndTime.getMillis() - lastTaskEndTime, 0L);
            QueryMonitor.logQueryTimeline(queryInfo.getQueryId(), queryInfo.getSession().getTransactionId().map(TransactionId::toString).orElse(""), elapsed, planning, waiting, scheduling, running, finishing, queryStartTime, queryEndTime);
        }
        catch (Exception e) {
            log.error((Throwable)e, "Error logging query timeline");
        }
    }

    private static void logQueryTimeline(BasicQueryInfo queryInfo) {
        DateTime queryStartTime = queryInfo.getQueryStats().getCreateTime();
        DateTime queryEndTime = queryInfo.getQueryStats().getEndTime();
        if (queryStartTime == null || queryEndTime == null) {
            return;
        }
        long elapsed = Math.max(queryEndTime.getMillis() - queryStartTime.getMillis(), 0L);
        QueryMonitor.logQueryTimeline(queryInfo.getQueryId(), queryInfo.getSession().getTransactionId().map(TransactionId::toString).orElse(""), elapsed, elapsed, 0L, 0L, 0L, 0L, queryStartTime, queryEndTime);
    }

    private static void logQueryTimeline(QueryId queryId, String transactionId, long elapsedMillis, long planningMillis, long waitingMillis, long schedulingMillis, long runningMillis, long finishingMillis, DateTime queryStartTime, DateTime queryEndTime) {
        log.info("TIMELINE: Query %s :: Transaction:[%s] :: elapsed %sms :: planning %sms :: waiting %sms :: scheduling %sms :: running %sms :: finishing %sms :: begin %s :: end %s", new Object[]{queryId, transactionId, elapsedMillis, planningMillis, waitingMillis, schedulingMillis, runningMillis, finishingMillis, queryStartTime, queryEndTime});
    }

    private static List<StageCpuDistribution> getCpuDistributions(QueryInfo queryInfo) {
        if (!queryInfo.getOutputStage().isPresent()) {
            return ImmutableList.of();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        QueryMonitor.populateDistribution(queryInfo.getOutputStage().get(), (ImmutableList.Builder<StageCpuDistribution>)builder);
        return builder.build();
    }

    private static void populateDistribution(StageInfo stageInfo, ImmutableList.Builder<StageCpuDistribution> distributions) {
        distributions.add((Object)QueryMonitor.computeCpuDistribution(stageInfo));
        for (StageInfo subStage : stageInfo.getSubStages()) {
            QueryMonitor.populateDistribution(subStage, distributions);
        }
    }

    private static StageCpuDistribution computeCpuDistribution(StageInfo stageInfo) {
        Distribution cpuDistribution = new Distribution();
        for (TaskInfo taskInfo : stageInfo.getTasks()) {
            cpuDistribution.add(taskInfo.getStats().getTotalCpuTime().toMillis());
        }
        Distribution.DistributionSnapshot snapshot = cpuDistribution.snapshot();
        return new StageCpuDistribution(stageInfo.getStageId().getId(), stageInfo.getTasks().size(), (long)snapshot.getP25(), (long)snapshot.getP50(), (long)snapshot.getP75(), (long)snapshot.getP90(), (long)snapshot.getP95(), (long)snapshot.getP99(), (long)snapshot.getMin(), (long)snapshot.getMax(), (long)snapshot.getTotal(), snapshot.getTotal() / snapshot.getCount());
    }
}

