/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.metadata;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.prestosql.connector.CatalogName;
import io.prestosql.metadata.Catalog;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class CatalogManager {
    private final ConcurrentMap<String, Catalog> catalogs = new ConcurrentHashMap<String, Catalog>();

    public synchronized void registerCatalog(Catalog catalog) {
        Objects.requireNonNull(catalog, "catalog is null");
        Preconditions.checkState((this.catalogs.put(catalog.getCatalogName(), catalog) == null ? 1 : 0) != 0, (String)"Catalog '%s' is already registered", (Object)catalog.getCatalogName());
    }

    public Optional<CatalogName> removeCatalog(String catalogName) {
        return Optional.ofNullable(this.catalogs.remove(catalogName)).map(Catalog::getConnectorCatalogName);
    }

    public List<Catalog> getCatalogs() {
        return ImmutableList.copyOf(this.catalogs.values());
    }

    public Optional<Catalog> getCatalog(String catalogName) {
        return Optional.ofNullable(this.catalogs.get(catalogName));
    }
}

