/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import io.prestosql.memory.context.LocalMemoryContext;
import io.prestosql.operator.Aggregator;
import io.prestosql.operator.BasicWorkProcessorOperatorAdapter;
import io.prestosql.operator.OperatorFactory;
import io.prestosql.operator.PagesHashStrategy;
import io.prestosql.operator.ProcessorContext;
import io.prestosql.operator.WorkProcessor;
import io.prestosql.operator.WorkProcessorOperator;
import io.prestosql.operator.aggregation.AccumulatorFactory;
import io.prestosql.spi.Page;
import io.prestosql.spi.PageBuilder;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.gen.JoinCompiler;
import io.prestosql.sql.planner.plan.AggregationNode;
import io.prestosql.sql.planner.plan.PlanNodeId;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import javax.annotation.Nullable;

public class StreamingAggregationOperator
implements WorkProcessorOperator {
    private final WorkProcessor<Page> pages;

    public static OperatorFactory createOperatorFactory(int operatorId, PlanNodeId planNodeId, List<Type> sourceTypes, List<Type> groupByTypes, List<Integer> groupByChannels, AggregationNode.Step step, List<AccumulatorFactory> accumulatorFactories, JoinCompiler joinCompiler) {
        return BasicWorkProcessorOperatorAdapter.createAdapterOperatorFactory(new Factory(operatorId, planNodeId, sourceTypes, groupByTypes, groupByChannels, step, accumulatorFactories, joinCompiler));
    }

    private StreamingAggregationOperator(ProcessorContext processorContext, WorkProcessor<Page> sourcePages, List<Type> sourceTypes, List<Type> groupByTypes, List<Integer> groupByChannels, AggregationNode.Step step, List<AccumulatorFactory> accumulatorFactories, JoinCompiler joinCompiler) {
        this.pages = sourcePages.transform(new StreamingAggregation(processorContext, sourceTypes, groupByTypes, groupByChannels, step, accumulatorFactories, joinCompiler));
    }

    @Override
    public WorkProcessor<Page> getOutputPages() {
        return this.pages;
    }

    private static class StreamingAggregation
    implements WorkProcessor.Transformation<Page, Page> {
        private final LocalMemoryContext systemMemoryContext;
        private final LocalMemoryContext userMemoryContext;
        private final List<Type> groupByTypes;
        private final int[] groupByChannels;
        private final List<AccumulatorFactory> accumulatorFactories;
        private final AggregationNode.Step step;
        private final PagesHashStrategy pagesHashStrategy;
        private List<Aggregator> aggregates;
        private final PageBuilder pageBuilder;
        private final Deque<Page> outputPages = new LinkedList<Page>();
        private Page currentGroup;

        private StreamingAggregation(ProcessorContext processorContext, List<Type> sourceTypes, List<Type> groupByTypes, List<Integer> groupByChannels, AggregationNode.Step step, List<AccumulatorFactory> accumulatorFactories, JoinCompiler joinCompiler) {
            Objects.requireNonNull(processorContext, "processorContext is null");
            this.systemMemoryContext = processorContext.getMemoryTrackingContext().localSystemMemoryContext();
            this.userMemoryContext = processorContext.getMemoryTrackingContext().localUserMemoryContext();
            this.groupByTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(groupByTypes, "groupByTypes is null"));
            this.groupByChannels = Ints.toArray((Collection)Objects.requireNonNull(groupByChannels, "groupByChannels is null"));
            this.accumulatorFactories = Objects.requireNonNull(accumulatorFactories, "accumulatorFactories is null");
            this.step = Objects.requireNonNull(step, "step is null");
            this.aggregates = StreamingAggregation.setupAggregates(step, accumulatorFactories);
            this.pageBuilder = new PageBuilder(StreamingAggregation.toTypes(groupByTypes, this.aggregates));
            Objects.requireNonNull(joinCompiler, "joinCompiler is null");
            Objects.requireNonNull(sourceTypes, "sourceTypes is null");
            this.pagesHashStrategy = joinCompiler.compilePagesHashStrategyFactory(sourceTypes, groupByChannels, Optional.empty()).createPagesHashStrategy((List)sourceTypes.stream().map(type -> ImmutableList.of()).collect(ImmutableList.toImmutableList()), OptionalInt.empty());
        }

        @Override
        public WorkProcessor.TransformationState<Page> process(@Nullable Page inputPage) {
            if (inputPage == null) {
                if (this.currentGroup != null) {
                    this.evaluateAndFlushGroup(this.currentGroup, 0);
                    this.currentGroup = null;
                }
                if (!this.pageBuilder.isEmpty()) {
                    this.outputPages.add(this.pageBuilder.build());
                    this.pageBuilder.reset();
                }
                if (this.outputPages.isEmpty()) {
                    return WorkProcessor.TransformationState.finished();
                }
                return WorkProcessor.TransformationState.ofResult(this.outputPages.removeFirst(), false);
            }
            if (!this.outputPages.isEmpty()) {
                Page outputPage = this.outputPages.removeFirst();
                return WorkProcessor.TransformationState.ofResult(outputPage, this.outputPages.isEmpty());
            }
            this.processInput(inputPage);
            this.updateMemoryUsage();
            if (this.outputPages.isEmpty()) {
                return WorkProcessor.TransformationState.needsMoreData();
            }
            Page outputPage = this.outputPages.removeFirst();
            return WorkProcessor.TransformationState.ofResult(outputPage, this.outputPages.isEmpty());
        }

        private void updateMemoryUsage() {
            long memorySize = this.pageBuilder.getRetainedSizeInBytes();
            for (Page output : this.outputPages) {
                memorySize += output.getRetainedSizeInBytes();
            }
            for (Aggregator aggregator : this.aggregates) {
                memorySize += aggregator.getEstimatedSize();
            }
            if (this.currentGroup != null) {
                memorySize += this.currentGroup.getRetainedSizeInBytes();
            }
            if (this.step.isOutputPartial()) {
                this.systemMemoryContext.setBytes(memorySize);
            } else {
                this.userMemoryContext.setBytes(memorySize);
            }
        }

        private void processInput(Page page) {
            Objects.requireNonNull(page, "page is null");
            Page groupByPage = StreamingAggregation.extractColumns(page, this.groupByChannels);
            if (this.currentGroup != null) {
                if (!this.pagesHashStrategy.rowEqualsRow(0, StreamingAggregation.extractColumns(this.currentGroup, this.groupByChannels), 0, groupByPage)) {
                    this.evaluateAndFlushGroup(this.currentGroup, 0);
                }
                this.currentGroup = null;
            }
            int startPosition = 0;
            while (true) {
                int nextGroupStart = this.findNextGroupStart(startPosition, groupByPage);
                this.addRowsToAggregates(page, startPosition, nextGroupStart - 1);
                if (nextGroupStart >= page.getPositionCount()) break;
                this.evaluateAndFlushGroup(page, startPosition);
                startPosition = nextGroupStart;
            }
            this.currentGroup = page.getRegion(page.getPositionCount() - 1, 1);
        }

        private static Page extractColumns(Page page, int[] channels) {
            Block[] newBlocks = new Block[channels.length];
            for (int i = 0; i < channels.length; ++i) {
                newBlocks[i] = page.getBlock(channels[i]);
            }
            return new Page(page.getPositionCount(), newBlocks);
        }

        private void addRowsToAggregates(Page page, int startPosition, int endPosition) {
            Page region = page.getRegion(startPosition, endPosition - startPosition + 1);
            for (Aggregator aggregator : this.aggregates) {
                aggregator.processPage(region);
            }
        }

        private void evaluateAndFlushGroup(Page page, int position) {
            this.pageBuilder.declarePosition();
            for (int i = 0; i < this.groupByTypes.size(); ++i) {
                Block block = page.getBlock(this.groupByChannels[i]);
                Type type = this.groupByTypes.get(i);
                type.appendTo(block, position, this.pageBuilder.getBlockBuilder(i));
            }
            int offset = this.groupByTypes.size();
            for (int i = 0; i < this.aggregates.size(); ++i) {
                this.aggregates.get(i).evaluate(this.pageBuilder.getBlockBuilder(offset + i));
            }
            if (this.pageBuilder.isFull()) {
                this.outputPages.add(this.pageBuilder.build());
                this.pageBuilder.reset();
            }
            this.aggregates = StreamingAggregation.setupAggregates(this.step, this.accumulatorFactories);
        }

        private int findNextGroupStart(int startPosition, Page page) {
            for (int i = startPosition + 1; i < page.getPositionCount(); ++i) {
                if (this.pagesHashStrategy.rowEqualsRow(startPosition, page, i, page)) continue;
                return i;
            }
            return page.getPositionCount();
        }

        private static List<Aggregator> setupAggregates(AggregationNode.Step step, List<AccumulatorFactory> accumulatorFactories) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (AccumulatorFactory factory : accumulatorFactories) {
                builder.add((Object)new Aggregator(factory, step));
            }
            return builder.build();
        }

        private static List<Type> toTypes(List<Type> groupByTypes, List<Aggregator> aggregates) {
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.addAll(groupByTypes);
            aggregates.stream().map(Aggregator::getType).forEach(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
            return builder.build();
        }
    }

    private static class Factory
    implements BasicWorkProcessorOperatorAdapter.BasicAdapterWorkProcessorOperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final List<Type> sourceTypes;
        private final List<Type> groupByTypes;
        private final List<Integer> groupByChannels;
        private final AggregationNode.Step step;
        private final List<AccumulatorFactory> accumulatorFactories;
        private final JoinCompiler joinCompiler;
        private boolean closed;

        private Factory(int operatorId, PlanNodeId planNodeId, List<Type> sourceTypes, List<Type> groupByTypes, List<Integer> groupByChannels, AggregationNode.Step step, List<AccumulatorFactory> accumulatorFactories, JoinCompiler joinCompiler) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.sourceTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(sourceTypes, "sourceTypes is null"));
            this.groupByTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(groupByTypes, "groupByTypes is null"));
            this.groupByChannels = ImmutableList.copyOf((Collection)Objects.requireNonNull(groupByChannels, "groupByChannels is null"));
            this.step = step;
            this.accumulatorFactories = ImmutableList.copyOf((Collection)Objects.requireNonNull(accumulatorFactories, "accumulatorFactories is null"));
            this.joinCompiler = Objects.requireNonNull(joinCompiler, "joinCompiler is null");
        }

        @Override
        public int getOperatorId() {
            return this.operatorId;
        }

        @Override
        public PlanNodeId getPlanNodeId() {
            return this.planNodeId;
        }

        @Override
        public String getOperatorType() {
            return StreamingAggregationOperator.class.getSimpleName();
        }

        @Override
        public WorkProcessorOperator create(ProcessorContext processorContext, WorkProcessor<Page> sourcePages) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            return new StreamingAggregationOperator(processorContext, sourcePages, this.sourceTypes, this.groupByTypes, this.groupByChannels, this.step, this.accumulatorFactories, this.joinCompiler);
        }

        @Override
        public void close() {
            this.closed = true;
        }

        @Override
        public Factory duplicate() {
            return new Factory(this.operatorId, this.planNodeId, this.sourceTypes, this.groupByTypes, this.groupByChannels, this.step, this.accumulatorFactories, this.joinCompiler);
        }
    }
}

