/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import io.prestosql.memory.context.AggregatedMemoryContext;
import io.prestosql.memory.context.LocalMemoryContext;
import io.prestosql.operator.GroupedTopNBuilder;
import io.prestosql.operator.NoChannelGroupByHash;
import io.prestosql.operator.SimplePageWithPositionComparator;
import io.prestosql.spi.Page;
import io.prestosql.spi.block.SortOrder;
import io.prestosql.spi.type.Type;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public class TopNProcessor {
    private final LocalMemoryContext localUserMemoryContext;
    @Nullable
    private GroupedTopNBuilder topNBuilder;
    private Iterator<Page> outputIterator;

    public TopNProcessor(AggregatedMemoryContext aggregatedMemoryContext, List<Type> types, int n, List<Integer> sortChannels, List<SortOrder> sortOrders) {
        Objects.requireNonNull(aggregatedMemoryContext, "aggregatedMemoryContext is null");
        this.localUserMemoryContext = aggregatedMemoryContext.newLocalMemoryContext(TopNProcessor.class.getSimpleName());
        Preconditions.checkArgument((n >= 0 ? 1 : 0) != 0, (Object)"n must be positive");
        if (n == 0) {
            this.outputIterator = Collections.emptyIterator();
        } else {
            this.topNBuilder = new GroupedTopNBuilder(types, new SimplePageWithPositionComparator(types, sortChannels, sortOrders), n, false, new NoChannelGroupByHash());
        }
    }

    public void addInput(Page page) {
        Objects.requireNonNull(this.topNBuilder, "topNBuilder is null");
        boolean done = this.topNBuilder.processPage(Objects.requireNonNull(page, "page is null")).process();
        Verify.verify((boolean)done);
        this.updateMemoryReservation();
    }

    public Page getOutput() {
        if (this.outputIterator == null) {
            this.outputIterator = this.topNBuilder.buildResult();
        }
        Page output = null;
        if (this.outputIterator.hasNext()) {
            output = this.outputIterator.next();
        } else {
            this.outputIterator = Collections.emptyIterator();
        }
        this.updateMemoryReservation();
        return output;
    }

    public boolean noMoreOutput() {
        return this.outputIterator != null && !this.outputIterator.hasNext();
    }

    private void updateMemoryReservation() {
        Objects.requireNonNull(this.topNBuilder, "topNBuilder is null");
        this.localUserMemoryContext.setBytes(this.topNBuilder.getEstimatedSizeInBytes());
    }
}

