/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator;

import com.google.common.util.concurrent.ListenableFuture;
import io.prestosql.execution.Lifespan;
import io.prestosql.memory.context.MemoryTrackingContext;
import io.prestosql.operator.DriverContext;
import io.prestosql.operator.Operator;
import io.prestosql.operator.OperatorContext;
import io.prestosql.operator.OperatorFactory;
import io.prestosql.operator.ProcessorContext;
import io.prestosql.operator.WorkProcessor;
import io.prestosql.operator.WorkProcessorOperator;
import io.prestosql.operator.WorkProcessorOperatorFactory;
import io.prestosql.spi.Page;
import io.prestosql.sql.planner.plan.PlanNodeId;
import java.util.Objects;

public class WorkProcessorOperatorAdapter
implements Operator {
    private final OperatorContext operatorContext;
    private final AdapterWorkProcessorOperator workProcessorOperator;
    private final WorkProcessor<Page> pages;

    public static OperatorFactory createAdapterOperatorFactory(AdapterWorkProcessorOperatorFactory operatorFactory) {
        return new Factory(operatorFactory);
    }

    public WorkProcessorOperatorAdapter(OperatorContext operatorContext, AdapterWorkProcessorOperatorFactory workProcessorOperatorFactory) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        MemoryTrackingContext memoryTrackingContext = new MemoryTrackingContext(operatorContext.aggregateUserMemoryContext(), operatorContext.aggregateRevocableMemoryContext(), operatorContext.aggregateSystemMemoryContext());
        memoryTrackingContext.initializeLocalMemoryContexts(workProcessorOperatorFactory.getOperatorType());
        this.workProcessorOperator = Objects.requireNonNull(workProcessorOperatorFactory, "workProcessorOperatorFactory is null").createAdapterOperator(new ProcessorContext(operatorContext.getSession(), memoryTrackingContext, operatorContext));
        this.pages = this.workProcessorOperator.getOutputPages();
        operatorContext.setInfoSupplier(() -> this.workProcessorOperator.getOperatorInfo().orElse(null));
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        if (!this.pages.isBlocked()) {
            return NOT_BLOCKED;
        }
        return this.pages.getBlockedFuture();
    }

    @Override
    public boolean needsInput() {
        return !this.isFinished() && this.workProcessorOperator.needsInput();
    }

    @Override
    public void addInput(Page page) {
        this.workProcessorOperator.addInput(page);
    }

    @Override
    public Page getOutput() {
        if (!this.pages.process()) {
            return null;
        }
        if (this.pages.isFinished()) {
            return null;
        }
        return this.pages.getResult();
    }

    @Override
    public void finish() {
        this.workProcessorOperator.finish();
    }

    @Override
    public boolean isFinished() {
        return this.pages.isFinished();
    }

    @Override
    public void close() throws Exception {
        this.workProcessorOperator.close();
    }

    private static class Factory
    implements OperatorFactory,
    WorkProcessorOperatorFactory {
        final AdapterWorkProcessorOperatorFactory operatorFactory;

        Factory(AdapterWorkProcessorOperatorFactory operatorFactory) {
            this.operatorFactory = Objects.requireNonNull(operatorFactory, "operatorFactory is null");
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorFactory.getOperatorId(), this.operatorFactory.getPlanNodeId(), this.operatorFactory.getOperatorType());
            return new WorkProcessorOperatorAdapter(operatorContext, this.operatorFactory);
        }

        @Override
        public void noMoreOperators() {
            this.close();
        }

        @Override
        public void noMoreOperators(Lifespan lifespan) {
            this.lifespanFinished(lifespan);
        }

        @Override
        public OperatorFactory duplicate() {
            return new Factory(this.operatorFactory.duplicate());
        }

        @Override
        public int getOperatorId() {
            return this.operatorFactory.getOperatorId();
        }

        @Override
        public PlanNodeId getPlanNodeId() {
            return this.operatorFactory.getPlanNodeId();
        }

        @Override
        public String getOperatorType() {
            return this.operatorFactory.getOperatorType();
        }

        @Override
        public WorkProcessorOperator create(ProcessorContext processorContext, WorkProcessor<Page> sourcePages) {
            return this.operatorFactory.create(processorContext, sourcePages);
        }

        @Override
        public void lifespanFinished(Lifespan lifespan) {
            this.operatorFactory.lifespanFinished(lifespan);
        }

        @Override
        public void close() {
            this.operatorFactory.close();
        }
    }

    public static interface AdapterWorkProcessorOperatorFactory
    extends WorkProcessorOperatorFactory {
        public AdapterWorkProcessorOperator createAdapterOperator(ProcessorContext var1);

        public AdapterWorkProcessorOperatorFactory duplicate();
    }

    public static interface AdapterWorkProcessorOperator
    extends WorkProcessorOperator {
        public boolean needsInput();

        public void addInput(Page var1);

        public void finish();
    }
}

