/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.aggregation;

import io.prestosql.operator.aggregation.state.LongAndDoubleState;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.function.AggregationFunction;
import io.prestosql.spi.function.AggregationState;
import io.prestosql.spi.function.CombineFunction;
import io.prestosql.spi.function.InputFunction;
import io.prestosql.spi.function.OutputFunction;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.RealType;

@AggregationFunction(value="geometric_mean")
public final class RealGeometricMeanAggregations {
    private RealGeometricMeanAggregations() {
    }

    @InputFunction
    public static void input(@AggregationState LongAndDoubleState state, @SqlType(value="real") long value) {
        state.setLong(state.getLong() + 1L);
        state.setDouble(state.getDouble() + Math.log(Float.intBitsToFloat((int)value)));
    }

    @CombineFunction
    public static void combine(@AggregationState LongAndDoubleState state, @AggregationState LongAndDoubleState otherState) {
        state.setLong(state.getLong() + otherState.getLong());
        state.setDouble(state.getDouble() + otherState.getDouble());
    }

    @OutputFunction(value="real")
    public static void output(@AggregationState LongAndDoubleState state, BlockBuilder out) {
        long count = state.getLong();
        if (count == 0L) {
            out.appendNull();
        } else {
            RealType.REAL.writeLong(out, (long)Float.floatToRawIntBits((float)Math.exp(state.getDouble() / (double)count)));
        }
    }
}

