/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.aggregation.minmaxby;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.prestosql.operator.aggregation.minmaxby.BooleanAndBlockPositionStateSerializer;
import io.prestosql.operator.aggregation.minmaxby.BooleanAndBlockPositionValueState;
import io.prestosql.operator.aggregation.minmaxby.BooleanBooleanState;
import io.prestosql.operator.aggregation.minmaxby.BooleanDoubleState;
import io.prestosql.operator.aggregation.minmaxby.BooleanLongState;
import io.prestosql.operator.aggregation.minmaxby.DoubleAndBlockPositionStateSerializer;
import io.prestosql.operator.aggregation.minmaxby.DoubleAndBlockPositionValueState;
import io.prestosql.operator.aggregation.minmaxby.DoubleBooleanState;
import io.prestosql.operator.aggregation.minmaxby.DoubleDoubleState;
import io.prestosql.operator.aggregation.minmaxby.DoubleLongState;
import io.prestosql.operator.aggregation.minmaxby.LongAndBlockPositionStateSerializer;
import io.prestosql.operator.aggregation.minmaxby.LongAndBlockPositionValueState;
import io.prestosql.operator.aggregation.minmaxby.LongBooleanState;
import io.prestosql.operator.aggregation.minmaxby.LongDoubleState;
import io.prestosql.operator.aggregation.minmaxby.LongLongState;
import io.prestosql.operator.aggregation.minmaxby.ObjectAndBlockPositionStateSerializer;
import io.prestosql.operator.aggregation.minmaxby.ObjectAndBlockPositionValueState;
import io.prestosql.operator.aggregation.minmaxby.ObjectBooleanState;
import io.prestosql.operator.aggregation.minmaxby.ObjectDoubleState;
import io.prestosql.operator.aggregation.minmaxby.ObjectLongState;
import io.prestosql.spi.function.AccumulatorState;
import io.prestosql.spi.function.AccumulatorStateSerializer;
import io.prestosql.spi.type.Type;
import java.util.List;
import java.util.Map;

public final class TwoNullableValueStateMapping {
    private static final Map<List<Class<?>>, Class<? extends AccumulatorState>> STATE_MAPPINGS = new ImmutableMap.Builder().put((Object)ImmutableList.of(Boolean.TYPE, Boolean.TYPE), BooleanBooleanState.class).put((Object)ImmutableList.of(Boolean.TYPE, Double.TYPE), BooleanDoubleState.class).put((Object)ImmutableList.of(Boolean.TYPE, Long.TYPE), BooleanLongState.class).put((Object)ImmutableList.of(Boolean.TYPE, Object.class), BooleanAndBlockPositionValueState.class).put((Object)ImmutableList.of(Double.TYPE, Boolean.TYPE), DoubleBooleanState.class).put((Object)ImmutableList.of(Double.TYPE, Double.TYPE), DoubleDoubleState.class).put((Object)ImmutableList.of(Double.TYPE, Long.TYPE), DoubleLongState.class).put((Object)ImmutableList.of(Double.TYPE, Object.class), DoubleAndBlockPositionValueState.class).put((Object)ImmutableList.of(Long.TYPE, Boolean.TYPE), LongBooleanState.class).put((Object)ImmutableList.of(Long.TYPE, Double.TYPE), LongDoubleState.class).put((Object)ImmutableList.of(Long.TYPE, Long.TYPE), LongLongState.class).put((Object)ImmutableList.of(Long.TYPE, Object.class), LongAndBlockPositionValueState.class).put((Object)ImmutableList.of(Object.class, Boolean.TYPE), ObjectBooleanState.class).put((Object)ImmutableList.of(Object.class, Double.TYPE), ObjectDoubleState.class).put((Object)ImmutableList.of(Object.class, Long.TYPE), ObjectLongState.class).put((Object)ImmutableList.of(Object.class, Object.class), ObjectAndBlockPositionValueState.class).build();

    private TwoNullableValueStateMapping() {
    }

    public static Class<? extends AccumulatorState> getStateClass(Class<?> first, Class<?> second) {
        ImmutableList key = ImmutableList.of(first.isPrimitive() ? first : Object.class, second.isPrimitive() ? second : Object.class);
        Class<? extends AccumulatorState> state = STATE_MAPPINGS.get(key);
        Preconditions.checkArgument((state != null ? 1 : 0) != 0, (String)"Unsupported state type combination: (%s, %s)", (Object)first.getName(), (Object)second.getName());
        return state;
    }

    public static AccumulatorStateSerializer<?> getStateSerializer(Type firstType, Type secondType) {
        Class firstJavaType = firstType.getJavaType();
        if (firstJavaType == Boolean.TYPE) {
            return new BooleanAndBlockPositionStateSerializer(firstType, secondType);
        }
        if (firstJavaType == Long.TYPE) {
            return new LongAndBlockPositionStateSerializer(firstType, secondType);
        }
        if (firstJavaType == Double.TYPE) {
            return new DoubleAndBlockPositionStateSerializer(firstType, secondType);
        }
        return new ObjectAndBlockPositionStateSerializer(firstType, secondType);
    }
}

