/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.aggregation.state;

import io.airlift.stats.QuantileDigest;
import io.prestosql.array.ObjectBigArray;
import io.prestosql.operator.aggregation.state.AbstractGroupedAccumulatorState;
import io.prestosql.operator.aggregation.state.QuantileDigestState;
import io.prestosql.spi.function.AccumulatorStateFactory;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

public class QuantileDigestStateFactory
implements AccumulatorStateFactory<QuantileDigestState> {
    public QuantileDigestState createSingleState() {
        return new SingleQuantileDigestState();
    }

    public Class<? extends QuantileDigestState> getSingleStateClass() {
        return SingleQuantileDigestState.class;
    }

    public QuantileDigestState createGroupedState() {
        return new GroupedQuantileDigestState();
    }

    public Class<? extends QuantileDigestState> getGroupedStateClass() {
        return GroupedQuantileDigestState.class;
    }

    public static class SingleQuantileDigestState
    implements QuantileDigestState {
        private static final int INSTANCE_SIZE = ClassLayout.parseClass(SingleQuantileDigestState.class).instanceSize();
        private QuantileDigest qdigest;

        @Override
        public QuantileDigest getQuantileDigest() {
            return this.qdigest;
        }

        @Override
        public void setQuantileDigest(QuantileDigest value) {
            this.qdigest = value;
        }

        @Override
        public void addMemoryUsage(int value) {
        }

        public long getEstimatedSize() {
            long estimatedSize = INSTANCE_SIZE;
            if (this.qdigest != null) {
                estimatedSize += (long)this.qdigest.estimatedInMemorySizeInBytes();
            }
            return estimatedSize;
        }
    }

    public static class GroupedQuantileDigestState
    extends AbstractGroupedAccumulatorState
    implements QuantileDigestState {
        private static final int INSTANCE_SIZE = ClassLayout.parseClass(GroupedQuantileDigestState.class).instanceSize();
        private final ObjectBigArray<QuantileDigest> qdigests = new ObjectBigArray();
        private long size;

        public void ensureCapacity(long size) {
            this.qdigests.ensureCapacity(size);
        }

        @Override
        public QuantileDigest getQuantileDigest() {
            return (QuantileDigest)this.qdigests.get(this.getGroupId());
        }

        @Override
        public void setQuantileDigest(QuantileDigest value) {
            Objects.requireNonNull(value, "value is null");
            this.qdigests.set(this.getGroupId(), (Object)value);
        }

        @Override
        public void addMemoryUsage(int value) {
            this.size += (long)value;
        }

        public long getEstimatedSize() {
            return (long)INSTANCE_SIZE + this.size + this.qdigests.sizeOf();
        }
    }
}

