/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.index;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.SettableFuture;
import io.airlift.concurrent.MoreFutures;
import io.prestosql.operator.index.IndexSnapshot;
import io.prestosql.spi.Page;
import java.util.Objects;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
class UpdateRequest {
    private final SettableFuture<IndexSnapshot> indexSnapshotFuture = SettableFuture.create();
    private final Page page;

    public UpdateRequest(Page page) {
        this.page = Objects.requireNonNull(page, "page is null");
    }

    public Page getPage() {
        return this.page;
    }

    public void finished(IndexSnapshot indexSnapshot) {
        Objects.requireNonNull(indexSnapshot, "indexSnapshot is null");
        Preconditions.checkState((boolean)this.indexSnapshotFuture.set((Object)indexSnapshot), (Object)"Already finished!");
    }

    public void failed(Throwable throwable) {
        this.indexSnapshotFuture.setException(throwable);
    }

    public boolean isFinished() {
        return this.indexSnapshotFuture.isDone();
    }

    public IndexSnapshot getFinishedIndexSnapshot() {
        Preconditions.checkState((boolean)this.indexSnapshotFuture.isDone(), (Object)"Update request is not finished");
        return (IndexSnapshot)MoreFutures.getFutureValue(this.indexSnapshotFuture);
    }
}

