/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.XxHash64;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.function.BlockIndex;
import io.prestosql.spi.function.BlockPosition;
import io.prestosql.spi.function.IsNull;
import io.prestosql.spi.function.LiteralParameters;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.function.ScalarOperator;
import io.prestosql.spi.function.SqlNullable;
import io.prestosql.spi.function.SqlType;
import io.prestosql.util.DateTimeUtils;
import io.prestosql.util.Failures;
import io.prestosql.util.JsonCastException;
import io.prestosql.util.JsonUtil;
import java.io.IOException;

public final class JsonOperators {
    public static final JsonFactory JSON_FACTORY = new JsonFactory().disable(JsonFactory.Feature.CANONICALIZE_FIELD_NAMES);

    private JsonOperators() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @ScalarOperator(value=OperatorType.CAST)
    @SqlNullable
    @LiteralParameters(value={"x"})
    @SqlType(value="varchar(x)")
    public static Slice castToVarchar(@SqlType(value="json") Slice json) {
        try (JsonParser parser = JsonUtil.createJsonParser(JSON_FACTORY, json);){
            parser.nextToken();
            Slice result = JsonUtil.currentTokenAsVarchar(parser);
            Failures.checkCondition(parser.nextToken() == null, (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "Cannot cast input json to VARCHAR", new Object[0]);
            Slice slice = result;
            return slice;
        }
        catch (JsonCastException | IOException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast '%s' to %s", json.toStringUtf8(), "varchar"), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @ScalarOperator(value=OperatorType.CAST)
    @SqlNullable
    @SqlType(value="bigint")
    public static Long castToBigint(@SqlType(value="json") Slice json) {
        try (JsonParser parser = JsonUtil.createJsonParser(JSON_FACTORY, json);){
            parser.nextToken();
            Long result = JsonUtil.currentTokenAsBigint(parser);
            Failures.checkCondition(parser.nextToken() == null, (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "Cannot cast input json to BIGINT", new Object[0]);
            Long l = result;
            return l;
        }
        catch (JsonCastException | IOException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast '%s' to %s", json.toStringUtf8(), "bigint"), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @ScalarOperator(value=OperatorType.CAST)
    @SqlNullable
    @SqlType(value="integer")
    public static Long castToInteger(@SqlType(value="json") Slice json) {
        try (JsonParser parser = JsonUtil.createJsonParser(JSON_FACTORY, json);){
            parser.nextToken();
            Long result = JsonUtil.currentTokenAsInteger(parser);
            Failures.checkCondition(parser.nextToken() == null, (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "Cannot cast input json to INTEGER", new Object[0]);
            Long l = result;
            return l;
        }
        catch (PrestoException e) {
            if (!e.getErrorCode().equals((Object)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE.toErrorCode())) throw e;
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast '%s' to %s", json.toStringUtf8(), "integer"), e.getCause());
        }
        catch (JsonCastException | IOException | ArithmeticException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast '%s' to %s", json.toStringUtf8(), "integer"), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @ScalarOperator(value=OperatorType.CAST)
    @SqlNullable
    @SqlType(value="smallint")
    public static Long castToSmallint(@SqlType(value="json") Slice json) {
        try (JsonParser parser = JsonUtil.createJsonParser(JSON_FACTORY, json);){
            parser.nextToken();
            Long result = JsonUtil.currentTokenAsSmallint(parser);
            Failures.checkCondition(parser.nextToken() == null, (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "Cannot cast input json to SMALLINT", new Object[0]);
            Long l = result;
            return l;
        }
        catch (PrestoException e) {
            if (!e.getErrorCode().equals((Object)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE.toErrorCode())) throw e;
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast '%s' to %s", json.toStringUtf8(), "integer"), e.getCause());
        }
        catch (JsonCastException | IOException | IllegalArgumentException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast '%s' to %s", json.toStringUtf8(), "smallint"), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @ScalarOperator(value=OperatorType.CAST)
    @SqlNullable
    @SqlType(value="tinyint")
    public static Long castToTinyint(@SqlType(value="json") Slice json) {
        try (JsonParser parser = JsonUtil.createJsonParser(JSON_FACTORY, json);){
            parser.nextToken();
            Long result = JsonUtil.currentTokenAsTinyint(parser);
            Failures.checkCondition(parser.nextToken() == null, (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "Cannot cast input json to TINYINT", new Object[0]);
            Long l = result;
            return l;
        }
        catch (PrestoException e) {
            if (!e.getErrorCode().equals((Object)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE.toErrorCode())) throw e;
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast '%s' to %s", json.toStringUtf8(), "integer"), e.getCause());
        }
        catch (JsonCastException | IOException | IllegalArgumentException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast '%s' to %s", json.toStringUtf8(), "tinyint"), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @ScalarOperator(value=OperatorType.CAST)
    @SqlNullable
    @SqlType(value="double")
    public static Double castToDouble(@SqlType(value="json") Slice json) {
        try (JsonParser parser = JsonUtil.createJsonParser(JSON_FACTORY, json);){
            parser.nextToken();
            Double result = JsonUtil.currentTokenAsDouble(parser);
            Failures.checkCondition(parser.nextToken() == null, (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "Cannot cast input json to DOUBLE", new Object[0]);
            Double d = result;
            return d;
        }
        catch (JsonCastException | IOException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast '%s' to %s", json.toStringUtf8(), "double"), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @ScalarOperator(value=OperatorType.CAST)
    @SqlNullable
    @SqlType(value="real")
    public static Long castToReal(@SqlType(value="json") Slice json) {
        try (JsonParser parser = JsonUtil.createJsonParser(JSON_FACTORY, json);){
            parser.nextToken();
            Long result = JsonUtil.currentTokenAsReal(parser);
            Failures.checkCondition(parser.nextToken() == null, (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "Cannot cast input json to REAL", new Object[0]);
            Long l = result;
            return l;
        }
        catch (JsonCastException | IOException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast '%s' to %s", json.toStringUtf8(), "real"), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @ScalarOperator(value=OperatorType.CAST)
    @SqlNullable
    @SqlType(value="boolean")
    public static Boolean castToBoolean(@SqlType(value="json") Slice json) {
        try (JsonParser parser = JsonUtil.createJsonParser(JSON_FACTORY, json);){
            parser.nextToken();
            Boolean result = JsonUtil.currentTokenAsBoolean(parser);
            Failures.checkCondition(parser.nextToken() == null, (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "Cannot cast input json to BOOLEAN", new Object[0]);
            Boolean bl = result;
            return bl;
        }
        catch (JsonCastException | IOException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast '%s' to %s", json.toStringUtf8(), "boolean"), (Throwable)e);
        }
    }

    @ScalarOperator(value=OperatorType.CAST)
    @LiteralParameters(value={"x"})
    @SqlType(value="json")
    public static Slice castFromVarchar(@SqlType(value="varchar(x)") Slice value) {
        try {
            DynamicSliceOutput output = new DynamicSliceOutput(value.length() + 2);
            try (JsonGenerator jsonGenerator = JsonUtil.createJsonGenerator(JSON_FACTORY, (SliceOutput)output);){
                jsonGenerator.writeString(value.toStringUtf8());
            }
            return output.slice();
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast '%s' to %s", value.toStringUtf8(), "json"));
        }
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="json")
    public static Slice castFromTinyInt(@SqlType(value="tinyint") long value) {
        return JsonOperators.internalCastFromLong(value, 4);
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="json")
    public static Slice castFromSmallInt(@SqlType(value="smallint") long value) {
        return JsonOperators.internalCastFromLong(value, 8);
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="json")
    public static Slice castFromInteger(@SqlType(value="integer") long value) {
        return JsonOperators.internalCastFromLong(value, 12);
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="json")
    public static Slice castFromBigint(@SqlType(value="bigint") long value) {
        return JsonOperators.internalCastFromLong(value, 20);
    }

    private static Slice internalCastFromLong(long value, int estimatedSize) {
        try {
            DynamicSliceOutput output = new DynamicSliceOutput(estimatedSize);
            try (JsonGenerator jsonGenerator = JsonUtil.createJsonGenerator(JSON_FACTORY, (SliceOutput)output);){
                jsonGenerator.writeNumber(value);
            }
            return output.slice();
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast '%s' to %s", value, "json"));
        }
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="json")
    public static Slice castFromDouble(@SqlType(value="double") double value) {
        try {
            DynamicSliceOutput output = new DynamicSliceOutput(32);
            try (JsonGenerator jsonGenerator = JsonUtil.createJsonGenerator(JSON_FACTORY, (SliceOutput)output);){
                jsonGenerator.writeNumber(value);
            }
            return output.slice();
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast '%s' to %s", value, "json"));
        }
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="json")
    public static Slice castFromReal(@SqlType(value="real") long value) {
        try {
            DynamicSliceOutput output = new DynamicSliceOutput(32);
            try (JsonGenerator jsonGenerator = JsonUtil.createJsonGenerator(JSON_FACTORY, (SliceOutput)output);){
                jsonGenerator.writeNumber(Float.intBitsToFloat((int)value));
            }
            return output.slice();
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast '%s' to %s", value, "json"));
        }
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="json")
    public static Slice castFromBoolean(@SqlType(value="boolean") boolean value) {
        try {
            DynamicSliceOutput output = new DynamicSliceOutput(5);
            try (JsonGenerator jsonGenerator = JsonUtil.createJsonGenerator(JSON_FACTORY, (SliceOutput)output);){
                jsonGenerator.writeBoolean(value);
            }
            return output.slice();
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast '%s' to %s", value, "json"));
        }
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="json")
    public static Slice castFromTimestamp(ConnectorSession session, @SqlType(value="timestamp") long value) {
        try {
            DynamicSliceOutput output = new DynamicSliceOutput(25);
            try (JsonGenerator jsonGenerator = JsonUtil.createJsonGenerator(JSON_FACTORY, (SliceOutput)output);){
                jsonGenerator.writeString(DateTimeUtils.printTimestampWithoutTimeZone(session.getTimeZoneKey(), value));
            }
            return output.slice();
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast '%s' to %s", value, "json"));
        }
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="json")
    public static Slice castFromDate(ConnectorSession session, @SqlType(value="date") long value) {
        try {
            DynamicSliceOutput output = new DynamicSliceOutput(12);
            try (JsonGenerator jsonGenerator = JsonUtil.createJsonGenerator(JSON_FACTORY, (SliceOutput)output);){
                jsonGenerator.writeString(DateTimeUtils.printDate((int)value));
            }
            return output.slice();
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast '%s' to %s", value, "json"));
        }
    }

    @ScalarOperator(value=OperatorType.HASH_CODE)
    @SqlType(value="bigint")
    public static long hashCode(@SqlType(value="json") Slice value) {
        return value.hashCode();
    }

    @ScalarOperator(value=OperatorType.XX_HASH_64)
    @SqlType(value="bigint")
    public static long xxHash64(@SqlType(value="json") Slice value) {
        return XxHash64.hash((Slice)value);
    }

    @ScalarOperator(value=OperatorType.INDETERMINATE)
    @SqlType(value="boolean")
    public static boolean indeterminate(@SqlType(value="json") Slice value, @IsNull boolean isNull) {
        return isNull;
    }

    @ScalarOperator(value=OperatorType.EQUAL)
    @SqlType(value="boolean")
    @SqlNullable
    public static Boolean equals(@SqlType(value="json") Slice leftJson, @SqlType(value="json") Slice rightJson) {
        return leftJson.equals((Object)rightJson);
    }

    @ScalarOperator(value=OperatorType.NOT_EQUAL)
    @SqlType(value="boolean")
    @SqlNullable
    public static Boolean notEqual(@SqlType(value="json") Slice leftJson, @SqlType(value="json") Slice rightJson) {
        return !leftJson.equals((Object)rightJson);
    }

    @ScalarOperator(value=OperatorType.IS_DISTINCT_FROM)
    public static final class JsonDistinctFromOperator {
        @SqlType(value="boolean")
        public static boolean isDistinctFrom(@SqlType(value="json") Slice leftJson, @IsNull boolean leftNull, @SqlType(value="json") Slice rightJson, @IsNull boolean rightNull) {
            if (leftNull != rightNull) {
                return true;
            }
            if (leftNull) {
                return false;
            }
            return JsonOperators.notEqual(leftJson, rightJson);
        }

        @SqlType(value="boolean")
        public static boolean isDistinctFrom(@BlockPosition @SqlType(value="json", nativeContainerType=Slice.class) Block left, @BlockIndex int leftPosition, @BlockPosition @SqlType(value="json", nativeContainerType=Slice.class) Block right, @BlockIndex int rightPosition) {
            int rightLength;
            if (left.isNull(leftPosition) != right.isNull(rightPosition)) {
                return true;
            }
            if (left.isNull(leftPosition)) {
                return false;
            }
            int leftLength = left.getSliceLength(leftPosition);
            if (leftLength != (rightLength = right.getSliceLength(rightPosition))) {
                return true;
            }
            return !left.equals(leftPosition, 0, right, rightPosition, 0, leftLength);
        }
    }
}

