/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar;

import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.SingleMapBlock;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeUtils;
import io.prestosql.util.Failures;

public final class MapGenericEquality {
    private MapGenericEquality() {
    }

    public static Boolean genericEqual(Type keyType, Block leftBlock, Block rightBlock, EqualityPredicate predicate) {
        if (leftBlock.getPositionCount() != rightBlock.getPositionCount()) {
            return false;
        }
        SingleMapBlock leftSingleMapLeftBlock = (SingleMapBlock)leftBlock;
        SingleMapBlock rightSingleMapBlock = (SingleMapBlock)rightBlock;
        boolean indeterminate = false;
        for (int position = 0; position < leftSingleMapLeftBlock.getPositionCount(); position += 2) {
            Object key = TypeUtils.readNativeValue((Type)keyType, (Block)leftBlock, (int)position);
            int leftPosition = position + 1;
            int rightPosition = rightSingleMapBlock.seekKey(key);
            if (rightPosition == -1) {
                return false;
            }
            try {
                Boolean result = predicate.equals(leftPosition, rightPosition);
                if (result == null) {
                    indeterminate = true;
                    continue;
                }
                if (result.booleanValue()) continue;
                return false;
            }
            catch (Throwable t) {
                throw Failures.internalError(t);
            }
        }
        if (indeterminate) {
            return null;
        }
        return true;
    }

    public static interface EqualityPredicate {
        public Boolean equals(int var1, int var2) throws Throwable;
    }
}

