/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.server;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigSecuritySensitive;
import io.airlift.configuration.DefunctConfig;
import java.util.Optional;
import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.NotNull;

@DefunctConfig(value={"internal-communication.kerberos.enabled", "internal-communication.kerberos.use-canonical-hostname", "internal-communication.jwt.enabled"})
public class InternalCommunicationConfig {
    private String sharedSecret;
    private boolean httpsRequired;
    private String keyStorePath;
    private String keyStorePassword;
    private String trustStorePath;
    private String trustStorePassword;

    @NotNull
    public Optional<String> getSharedSecret() {
        return Optional.ofNullable(this.sharedSecret);
    }

    @ConfigSecuritySensitive
    @Config(value="internal-communication.shared-secret")
    public InternalCommunicationConfig setSharedSecret(String sharedSecret) {
        this.sharedSecret = sharedSecret;
        return this;
    }

    public boolean isHttpsRequired() {
        return this.httpsRequired;
    }

    @Config(value="internal-communication.https.required")
    public InternalCommunicationConfig setHttpsRequired(boolean httpsRequired) {
        this.httpsRequired = httpsRequired;
        return this;
    }

    public String getKeyStorePath() {
        return this.keyStorePath;
    }

    @Config(value="internal-communication.https.keystore.path")
    public InternalCommunicationConfig setKeyStorePath(String keyStorePath) {
        this.keyStorePath = keyStorePath;
        return this;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    @Config(value="internal-communication.https.keystore.key")
    @ConfigSecuritySensitive
    public InternalCommunicationConfig setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
        return this;
    }

    public String getTrustStorePath() {
        return this.trustStorePath;
    }

    @Config(value="internal-communication.https.truststore.path")
    public InternalCommunicationConfig setTrustStorePath(String trustStorePath) {
        this.trustStorePath = trustStorePath;
        return this;
    }

    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    @Config(value="internal-communication.https.truststore.key")
    @ConfigSecuritySensitive
    public InternalCommunicationConfig setTrustStorePassword(String trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
        return this;
    }

    @AssertTrue(message="Internal shared secret is required when HTTPS is enabled for internal communications")
    public @AssertTrue(message="Internal shared secret is required when HTTPS is enabled for internal communications") boolean isRequiredSharedSecretSet() {
        return !this.isHttpsRequired() || this.getSharedSecret().isPresent();
    }
}

