/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.server.security;

import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;

public enum KerberosNameType {
    HOSTBASED_SERVICE{

        @Override
        public GSSName getGSSName(GSSManager gssManager, String serviceName, String hostname) {
            try {
                return gssManager.createName(serviceName + "@" + hostname, GSSName.NT_HOSTBASED_SERVICE);
            }
            catch (GSSException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public String makeServicePrincipal(String serviceName, String hostname) {
            return serviceName + "/" + hostname;
        }
    }
    ,
    USER_NAME{

        @Override
        public GSSName getGSSName(GSSManager gssManager, String serviceName, String hostname) {
            try {
                return gssManager.createName(serviceName, GSSName.NT_USER_NAME);
            }
            catch (GSSException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public String makeServicePrincipal(String serviceName, String hostname) {
            return serviceName;
        }
    };


    public abstract GSSName getGSSName(GSSManager var1, String var2, String var3);

    public abstract String makeServicePrincipal(String var1, String var2);
}

