/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.server.ui;

import io.airlift.configuration.Config;
import io.airlift.units.Duration;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.NotNull;

public class WebUiConfig {
    private boolean enabled = true;
    private Optional<String> sharedSecret = Optional.empty();
    private Duration sessionTimeout = new Duration(1.0, TimeUnit.DAYS);

    public boolean isEnabled() {
        return this.enabled;
    }

    @Config(value="web-ui.enabled")
    public WebUiConfig setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @NotNull
    public Optional<String> getSharedSecret() {
        return this.sharedSecret;
    }

    @Config(value="web-ui.shared-secret")
    public WebUiConfig setSharedSecret(String sharedSecret) {
        this.sharedSecret = Optional.ofNullable(sharedSecret);
        return this;
    }

    @NotNull
    public Duration getSessionTimeout() {
        return this.sessionTimeout;
    }

    @Config(value="web-ui.session-timeout")
    public WebUiConfig setSessionTimeout(Duration sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
        return this;
    }
}

