/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.gen;

import io.airlift.bytecode.BytecodeNode;
import io.airlift.bytecode.FieldDefinition;
import io.airlift.bytecode.Scope;
import io.airlift.bytecode.Variable;
import io.prestosql.metadata.Metadata;
import io.prestosql.operator.scalar.ScalarFunctionImplementation;
import io.prestosql.sql.gen.BytecodeUtils;
import io.prestosql.sql.gen.CachedInstanceBinder;
import io.prestosql.sql.gen.CallSiteBinder;
import io.prestosql.sql.gen.RowExpressionCompiler;
import io.prestosql.sql.relational.RowExpression;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class BytecodeGeneratorContext {
    private final RowExpressionCompiler rowExpressionCompiler;
    private final Scope scope;
    private final CallSiteBinder callSiteBinder;
    private final CachedInstanceBinder cachedInstanceBinder;
    private final Metadata metadata;
    private final Variable wasNull;

    public BytecodeGeneratorContext(RowExpressionCompiler rowExpressionCompiler, Scope scope, CallSiteBinder callSiteBinder, CachedInstanceBinder cachedInstanceBinder, Metadata metadata) {
        Objects.requireNonNull(rowExpressionCompiler, "bytecodeGenerator is null");
        Objects.requireNonNull(cachedInstanceBinder, "cachedInstanceBinder is null");
        Objects.requireNonNull(scope, "scope is null");
        Objects.requireNonNull(callSiteBinder, "callSiteBinder is null");
        Objects.requireNonNull(metadata, "metadata is null");
        this.rowExpressionCompiler = rowExpressionCompiler;
        this.scope = scope;
        this.callSiteBinder = callSiteBinder;
        this.cachedInstanceBinder = cachedInstanceBinder;
        this.metadata = metadata;
        this.wasNull = scope.getVariable("wasNull");
    }

    public Scope getScope() {
        return this.scope;
    }

    public CallSiteBinder getCallSiteBinder() {
        return this.callSiteBinder;
    }

    public BytecodeNode generate(RowExpression expression) {
        return this.generate(expression, Optional.empty());
    }

    public BytecodeNode generate(RowExpression expression, Optional<Class<?>> lambdaInterface) {
        return this.rowExpressionCompiler.compile(expression, this.scope, lambdaInterface);
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public BytecodeNode generateCall(String name, ScalarFunctionImplementation function, List<BytecodeNode> arguments) {
        Optional<BytecodeNode> instance = Optional.empty();
        if (function.getInstanceFactory().isPresent()) {
            FieldDefinition field = this.cachedInstanceBinder.getCachedInstance(function.getInstanceFactory().get());
            instance = Optional.of(this.scope.getThis().getField(field));
        }
        return BytecodeUtils.generateInvocation(this.scope, name, function, instance, arguments, this.callSiteBinder);
    }

    public Variable wasNull() {
        return this.wasNull;
    }
}

