/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.gen;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import io.airlift.bytecode.Access;
import io.airlift.bytecode.BytecodeNode;
import io.airlift.bytecode.ClassDefinition;
import io.airlift.bytecode.CompilationException;
import io.airlift.bytecode.Parameter;
import io.airlift.bytecode.ParameterizedType;
import io.prestosql.metadata.Metadata;
import io.prestosql.operator.project.CursorProcessor;
import io.prestosql.operator.project.PageFilter;
import io.prestosql.operator.project.PageProcessor;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.gen.BodyCompiler;
import io.prestosql.sql.gen.BytecodeUtils;
import io.prestosql.sql.gen.CacheStatsMBean;
import io.prestosql.sql.gen.CallSiteBinder;
import io.prestosql.sql.gen.CursorProcessorCompiler;
import io.prestosql.sql.gen.PageFunctionCompiler;
import io.prestosql.sql.relational.Expressions;
import io.prestosql.sql.relational.RowExpression;
import io.prestosql.util.CompilerUtils;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public class ExpressionCompiler {
    private final PageFunctionCompiler pageFunctionCompiler;
    private final LoadingCache<CacheKey, Class<? extends CursorProcessor>> cursorProcessors;
    private final CacheStatsMBean cacheStatsMBean;

    @Inject
    public ExpressionCompiler(Metadata metadata, PageFunctionCompiler pageFunctionCompiler) {
        Objects.requireNonNull(metadata, "metadata is null");
        this.pageFunctionCompiler = Objects.requireNonNull(pageFunctionCompiler, "pageFunctionCompiler is null");
        this.cursorProcessors = CacheBuilder.newBuilder().recordStats().maximumSize(1000L).build(CacheLoader.from(key -> this.compile(((CacheKey)key).getFilter(), ((CacheKey)key).getProjections(), new CursorProcessorCompiler(metadata), CursorProcessor.class)));
        this.cacheStatsMBean = new CacheStatsMBean(this.cursorProcessors);
    }

    @Managed
    @Nested
    public CacheStatsMBean getCursorProcessorCache() {
        return this.cacheStatsMBean;
    }

    public Supplier<CursorProcessor> compileCursorProcessor(Optional<RowExpression> filter, List<? extends RowExpression> projections, Object uniqueKey) {
        Class cursorProcessor = (Class)this.cursorProcessors.getUnchecked((Object)new CacheKey(filter, projections, uniqueKey));
        return () -> {
            try {
                return (CursorProcessor)cursorProcessor.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        };
    }

    public Supplier<PageProcessor> compilePageProcessor(Optional<RowExpression> filter, List<? extends RowExpression> projections, Optional<String> classNameSuffix) {
        return this.compilePageProcessor(filter, projections, classNameSuffix, OptionalInt.empty());
    }

    private Supplier<PageProcessor> compilePageProcessor(Optional<RowExpression> filter, List<? extends RowExpression> projections, Optional<String> classNameSuffix, OptionalInt initialBatchSize) {
        Optional<Supplier> filterFunctionSupplier = filter.map(expression -> this.pageFunctionCompiler.compileFilter((RowExpression)expression, classNameSuffix));
        List pageProjectionSuppliers = (List)projections.stream().map(projection -> this.pageFunctionCompiler.compileProjection((RowExpression)projection, classNameSuffix)).collect(ImmutableList.toImmutableList());
        return () -> {
            Optional<PageFilter> filterFunction = filterFunctionSupplier.map(Supplier::get);
            List pageProjections = (List)pageProjectionSuppliers.stream().map(Supplier::get).collect(ImmutableList.toImmutableList());
            return new PageProcessor(filterFunction, pageProjections, initialBatchSize);
        };
    }

    public Supplier<PageProcessor> compilePageProcessor(Optional<RowExpression> filter, List<? extends RowExpression> projections) {
        return this.compilePageProcessor(filter, projections, Optional.empty());
    }

    @VisibleForTesting
    public Supplier<PageProcessor> compilePageProcessor(Optional<RowExpression> filter, List<? extends RowExpression> projections, int initialBatchSize) {
        return this.compilePageProcessor(filter, projections, Optional.empty(), OptionalInt.of(initialBatchSize));
    }

    private <T> Class<? extends T> compile(Optional<RowExpression> filter, List<RowExpression> projections, BodyCompiler bodyCompiler, Class<? extends T> superType) {
        try {
            return this.compileProcessor(filter.orElse(Expressions.constant(true, (Type)BooleanType.BOOLEAN)), projections, bodyCompiler, superType);
        }
        catch (CompilationException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.COMPILER_ERROR, e.getCause());
        }
    }

    private <T> Class<? extends T> compileProcessor(RowExpression filter, List<RowExpression> projections, BodyCompiler bodyCompiler, Class<? extends T> superType) {
        ClassDefinition classDefinition = new ClassDefinition(Access.a((Access[])new Access[]{Access.PUBLIC, Access.FINAL}), CompilerUtils.makeClassName(superType.getSimpleName()), ParameterizedType.type(Object.class), new ParameterizedType[]{ParameterizedType.type(superType)});
        CallSiteBinder callSiteBinder = new CallSiteBinder();
        bodyCompiler.generateMethods(classDefinition, callSiteBinder, filter, projections);
        ExpressionCompiler.generateToString(classDefinition, callSiteBinder, MoreObjects.toStringHelper((String)classDefinition.getType().getJavaClassName()).add("filter", (Object)filter).add("projections", projections).toString());
        return CompilerUtils.defineClass(classDefinition, superType, callSiteBinder.getBindings(), this.getClass().getClassLoader());
    }

    private static void generateToString(ClassDefinition classDefinition, CallSiteBinder callSiteBinder, String string) {
        classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "toString", ParameterizedType.type(String.class), new Parameter[0]).getBody().append((BytecodeNode)BytecodeUtils.invoke(callSiteBinder.bind(string, String.class), "toString")).retObject();
    }

    private static final class CacheKey {
        private final Optional<RowExpression> filter;
        private final List<RowExpression> projections;
        private final Object uniqueKey;

        private CacheKey(Optional<RowExpression> filter, List<? extends RowExpression> projections, Object uniqueKey) {
            this.filter = filter;
            this.uniqueKey = uniqueKey;
            this.projections = ImmutableList.copyOf(projections);
        }

        private Optional<RowExpression> getFilter() {
            return this.filter;
        }

        private List<RowExpression> getProjections() {
            return this.projections;
        }

        public int hashCode() {
            return Objects.hash(this.filter, this.projections, this.uniqueKey);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            CacheKey other = (CacheKey)obj;
            return Objects.equals(this.filter, other.filter) && Objects.equals(this.projections, other.projections) && Objects.equals(this.uniqueKey, other.uniqueKey);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("filter", this.filter).add("projections", this.projections).add("uniqueKey", this.uniqueKey).toString();
        }
    }
}

