/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import io.prestosql.matching.Captures;
import io.prestosql.matching.Pattern;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.ResolvedFunction;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.analyzer.TypeSignatureProvider;
import io.prestosql.sql.analyzer.TypeSignatureTranslator;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.optimizations.PlanNodeDecorrelator;
import io.prestosql.sql.planner.plan.AggregationNode;
import io.prestosql.sql.planner.plan.ApplyNode;
import io.prestosql.sql.planner.plan.Assignments;
import io.prestosql.sql.planner.plan.CorrelatedJoinNode;
import io.prestosql.sql.planner.plan.LimitNode;
import io.prestosql.sql.planner.plan.Patterns;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.ProjectNode;
import io.prestosql.sql.tree.BooleanLiteral;
import io.prestosql.sql.tree.Cast;
import io.prestosql.sql.tree.CoalesceExpression;
import io.prestosql.sql.tree.ComparisonExpression;
import io.prestosql.sql.tree.ExistsPredicate;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.LongLiteral;
import io.prestosql.sql.tree.QualifiedName;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class TransformExistsApplyToCorrelatedJoin
implements Rule<ApplyNode> {
    private static final Pattern<ApplyNode> PATTERN = Patterns.applyNode();
    private static final QualifiedName COUNT = QualifiedName.of((String)"count");
    private final Metadata metadata;
    private final ResolvedFunction countFunction;

    public TransformExistsApplyToCorrelatedJoin(Metadata metadata) {
        Objects.requireNonNull(metadata, "metadata is null");
        this.metadata = metadata;
        this.countFunction = metadata.resolveFunction(COUNT, (List<TypeSignatureProvider>)ImmutableList.of());
    }

    @Override
    public Pattern<ApplyNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(ApplyNode parent, Captures captures, Rule.Context context) {
        if (parent.getSubqueryAssignments().size() != 1) {
            return Rule.Result.empty();
        }
        Expression expression = (Expression)Iterables.getOnlyElement(parent.getSubqueryAssignments().getExpressions());
        if (!(expression instanceof ExistsPredicate)) {
            return Rule.Result.empty();
        }
        if (parent.getCorrelation().isEmpty()) {
            return Rule.Result.ofPlanNode(this.rewriteToDefaultAggregation(parent, context));
        }
        Optional<PlanNode> nonDefaultAggregation = this.rewriteToNonDefaultAggregation(parent, context);
        return nonDefaultAggregation.map(Rule.Result::ofPlanNode).orElseGet(() -> Rule.Result.ofPlanNode(this.rewriteToDefaultAggregation(parent, context)));
    }

    private Optional<PlanNode> rewriteToNonDefaultAggregation(ApplyNode applyNode, Rule.Context context) {
        Preconditions.checkState((boolean)applyNode.getSubquery().getOutputSymbols().isEmpty(), (Object)"Expected subquery output symbols to be pruned");
        Symbol subqueryTrue = context.getSymbolAllocator().newSymbol("subqueryTrue", (Type)BooleanType.BOOLEAN);
        ProjectNode subquery = new ProjectNode(context.getIdAllocator().getNextId(), new LimitNode(context.getIdAllocator().getNextId(), applyNode.getSubquery(), 1L, false), Assignments.of(subqueryTrue, (Expression)BooleanLiteral.TRUE_LITERAL));
        PlanNodeDecorrelator decorrelator = new PlanNodeDecorrelator(this.metadata, context.getSymbolAllocator(), context.getLookup());
        if (!decorrelator.decorrelateFilters(subquery, applyNode.getCorrelation()).isPresent()) {
            return Optional.empty();
        }
        Symbol exists = (Symbol)Iterables.getOnlyElement(applyNode.getSubqueryAssignments().getSymbols());
        Assignments.Builder assignments = Assignments.builder().putIdentities(applyNode.getInput().getOutputSymbols()).put(exists, (Expression)new CoalesceExpression((List)ImmutableList.of((Object)subqueryTrue.toSymbolReference(), (Object)BooleanLiteral.FALSE_LITERAL)));
        return Optional.of(new ProjectNode(context.getIdAllocator().getNextId(), new CorrelatedJoinNode(applyNode.getId(), applyNode.getInput(), subquery, applyNode.getCorrelation(), CorrelatedJoinNode.Type.LEFT, (Expression)BooleanLiteral.TRUE_LITERAL, applyNode.getOriginSubquery()), assignments.build()));
    }

    private PlanNode rewriteToDefaultAggregation(ApplyNode applyNode, Rule.Context context) {
        Symbol count = context.getSymbolAllocator().newSymbol(COUNT.toString(), (Type)BigintType.BIGINT);
        Symbol exists = (Symbol)Iterables.getOnlyElement(applyNode.getSubqueryAssignments().getSymbols());
        return new CorrelatedJoinNode(applyNode.getId(), applyNode.getInput(), new ProjectNode(context.getIdAllocator().getNextId(), new AggregationNode(context.getIdAllocator().getNextId(), applyNode.getSubquery(), (Map<Symbol, AggregationNode.Aggregation>)ImmutableMap.of((Object)count, (Object)new AggregationNode.Aggregation(this.countFunction, (List<Expression>)ImmutableList.of(), false, Optional.empty(), Optional.empty(), Optional.empty())), AggregationNode.globalAggregation(), (List<Symbol>)ImmutableList.of(), AggregationNode.Step.SINGLE, Optional.empty(), Optional.empty()), Assignments.of(exists, (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)count.toSymbolReference(), (Expression)new Cast((Expression)new LongLiteral("0"), TypeSignatureTranslator.toSqlType((Type)BigintType.BIGINT))))), applyNode.getCorrelation(), CorrelatedJoinNode.Type.INNER, (Expression)BooleanLiteral.TRUE_LITERAL, applyNode.getOriginSubquery());
    }
}

