/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.testing;

import io.prestosql.Session;
import io.prestosql.cost.StatsCalculator;
import io.prestosql.execution.warnings.WarningCollector;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.QualifiedObjectName;
import io.prestosql.metadata.SqlFunction;
import io.prestosql.spi.Plugin;
import io.prestosql.split.PageSourceManager;
import io.prestosql.split.SplitManager;
import io.prestosql.sql.planner.NodePartitioningManager;
import io.prestosql.sql.planner.Plan;
import io.prestosql.testing.MaterializedResult;
import io.prestosql.testing.TestingAccessControlManager;
import io.prestosql.transaction.TransactionManager;
import java.io.Closeable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import org.intellij.lang.annotations.Language;

public interface QueryRunner
extends Closeable {
    @Override
    public void close();

    public int getNodeCount();

    public Session getDefaultSession();

    public TransactionManager getTransactionManager();

    public Metadata getMetadata();

    public SplitManager getSplitManager();

    public PageSourceManager getPageSourceManager();

    public NodePartitioningManager getNodePartitioningManager();

    public StatsCalculator getStatsCalculator();

    public TestingAccessControlManager getAccessControl();

    public MaterializedResult execute(@Language(value="SQL") String var1);

    public MaterializedResult execute(Session var1, @Language(value="SQL") String var2);

    default public MaterializedResultWithPlan executeWithPlan(Session session, @Language(value="SQL") String sql, WarningCollector warningCollector) {
        throw new UnsupportedOperationException();
    }

    default public Plan createPlan(Session session, @Language(value="SQL") String sql, WarningCollector warningCollector) {
        throw new UnsupportedOperationException();
    }

    public List<QualifiedObjectName> listTables(Session var1, String var2, String var3);

    public boolean tableExists(Session var1, String var2);

    public void installPlugin(Plugin var1);

    public void addFunctions(List<? extends SqlFunction> var1);

    public void createCatalog(String var1, String var2, Map<String, String> var3);

    public Lock getExclusiveLock();

    public static class MaterializedResultWithPlan {
        private final MaterializedResult materializedResult;
        private final Plan queryPlan;

        public MaterializedResultWithPlan(MaterializedResult materializedResult, Plan queryPlan) {
            this.materializedResult = materializedResult;
            this.queryPlan = queryPlan;
        }

        public MaterializedResult getMaterializedResult() {
            return this.materializedResult;
        }

        public Plan getQueryPlan() {
            return this.queryPlan;
        }
    }
}

