/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.type;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.slice.XxHash64;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.function.BlockIndex;
import io.prestosql.spi.function.BlockPosition;
import io.prestosql.spi.function.IsNull;
import io.prestosql.spi.function.LiteralParameters;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.function.ScalarFunction;
import io.prestosql.spi.function.ScalarOperator;
import io.prestosql.spi.function.SqlNullable;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.BooleanType;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public final class BooleanOperators {
    private static final Slice TRUE = Slices.copiedBuffer((String)"true", (Charset)StandardCharsets.US_ASCII);
    private static final Slice FALSE = Slices.copiedBuffer((String)"false", (Charset)StandardCharsets.US_ASCII);
    private static final long TRUE_XX_HASH = XxHash64.hash((long)1L);
    private static final long FALSE_XX_HASH = XxHash64.hash((long)0L);

    private BooleanOperators() {
    }

    @ScalarOperator(value=OperatorType.EQUAL)
    @SqlType(value="boolean")
    @SqlNullable
    public static Boolean equal(@SqlType(value="boolean") boolean left, @SqlType(value="boolean") boolean right) {
        return left == right;
    }

    @ScalarOperator(value=OperatorType.NOT_EQUAL)
    @SqlType(value="boolean")
    @SqlNullable
    public static Boolean notEqual(@SqlType(value="boolean") boolean left, @SqlType(value="boolean") boolean right) {
        return left != right;
    }

    @ScalarOperator(value=OperatorType.LESS_THAN)
    @SqlType(value="boolean")
    public static boolean lessThan(@SqlType(value="boolean") boolean left, @SqlType(value="boolean") boolean right) {
        return !left && right;
    }

    @ScalarOperator(value=OperatorType.LESS_THAN_OR_EQUAL)
    @SqlType(value="boolean")
    public static boolean lessThanOrEqual(@SqlType(value="boolean") boolean left, @SqlType(value="boolean") boolean right) {
        return !left || right;
    }

    @ScalarOperator(value=OperatorType.GREATER_THAN)
    @SqlType(value="boolean")
    public static boolean greaterThan(@SqlType(value="boolean") boolean left, @SqlType(value="boolean") boolean right) {
        return left && !right;
    }

    @ScalarOperator(value=OperatorType.GREATER_THAN_OR_EQUAL)
    @SqlType(value="boolean")
    public static boolean greaterThanOrEqual(@SqlType(value="boolean") boolean left, @SqlType(value="boolean") boolean right) {
        return left || !right;
    }

    @ScalarOperator(value=OperatorType.BETWEEN)
    @SqlType(value="boolean")
    public static boolean between(@SqlType(value="boolean") boolean value, @SqlType(value="boolean") boolean min, @SqlType(value="boolean") boolean max) {
        return value && max || !value && !min;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="double")
    public static double castToDouble(@SqlType(value="boolean") boolean value) {
        return value ? 1.0 : 0.0;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="real")
    public static long castToReal(@SqlType(value="boolean") boolean value) {
        return value ? (long)Float.floatToRawIntBits(1.0f) : (long)Float.floatToRawIntBits(0.0f);
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="bigint")
    public static long castToBigint(@SqlType(value="boolean") boolean value) {
        return value ? 1L : 0L;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="integer")
    public static long castToInteger(@SqlType(value="boolean") boolean value) {
        return value ? 1L : 0L;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="smallint")
    public static long castToSmallint(@SqlType(value="boolean") boolean value) {
        return value ? 1L : 0L;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="tinyint")
    public static long castToTinyint(@SqlType(value="boolean") boolean value) {
        return value ? 1L : 0L;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @LiteralParameters(value={"x"})
    @SqlType(value="varchar(x)")
    public static Slice castToVarchar(@SqlType(value="boolean") boolean value) {
        return value ? TRUE : FALSE;
    }

    @ScalarOperator(value=OperatorType.HASH_CODE)
    @SqlType(value="bigint")
    public static long hashCode(@SqlType(value="boolean") boolean value) {
        return value ? 1231L : 1237L;
    }

    @ScalarOperator(value=OperatorType.XX_HASH_64)
    @SqlType(value="bigint")
    public static long xxHash64(@SqlType(value="boolean") boolean value) {
        return value ? TRUE_XX_HASH : FALSE_XX_HASH;
    }

    @ScalarOperator(value=OperatorType.INDETERMINATE)
    @SqlType(value="boolean")
    public static boolean indeterminate(@SqlType(value="boolean") boolean value, @IsNull boolean isNull) {
        return isNull;
    }

    @SqlType(value="boolean")
    @ScalarFunction(hidden=true)
    public static boolean not(@SqlType(value="boolean") boolean value) {
        return !value;
    }

    @ScalarOperator(value=OperatorType.IS_DISTINCT_FROM)
    public static final class BooleanDistinctFromOperator {
        @SqlType(value="boolean")
        public static boolean isDistinctFrom(@SqlType(value="boolean") boolean left, @IsNull boolean leftNull, @SqlType(value="boolean") boolean right, @IsNull boolean rightNull) {
            if (leftNull != rightNull) {
                return true;
            }
            if (leftNull) {
                return false;
            }
            return BooleanOperators.notEqual(left, right);
        }

        @SqlType(value="boolean")
        public static boolean isDistinctFrom(@BlockPosition @SqlType(value="boolean", nativeContainerType=boolean.class) Block left, @BlockIndex int leftPosition, @BlockPosition @SqlType(value="boolean", nativeContainerType=boolean.class) Block right, @BlockIndex int rightPosition) {
            if (left.isNull(leftPosition) != right.isNull(rightPosition)) {
                return true;
            }
            if (left.isNull(leftPosition)) {
                return false;
            }
            return BooleanOperators.notEqual(BooleanType.BOOLEAN.getBoolean(left, leftPosition), BooleanType.BOOLEAN.getBoolean(right, rightPosition));
        }
    }
}

