/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.type.setdigest;

import io.airlift.slice.Slice;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.function.AggregationFunction;
import io.prestosql.spi.function.CombineFunction;
import io.prestosql.spi.function.InputFunction;
import io.prestosql.spi.function.OutputFunction;
import io.prestosql.spi.function.SqlType;
import io.prestosql.type.setdigest.SetDigest;
import io.prestosql.type.setdigest.SetDigestState;
import io.prestosql.type.setdigest.SetDigestType;

@AggregationFunction(value="merge_set_digest")
public final class MergeSetDigestAggregation {
    private MergeSetDigestAggregation() {
    }

    @InputFunction
    public static void input(SetDigestState state, @SqlType(value="SetDigest") Slice value) {
        SetDigest instance = SetDigest.newInstance(value);
        MergeSetDigestAggregation.merge(state, instance);
    }

    @CombineFunction
    public static void combine(SetDigestState state, SetDigestState otherState) {
        MergeSetDigestAggregation.merge(state, otherState.getDigest());
    }

    private static void merge(SetDigestState state, SetDigest instance) {
        if (state.getDigest() == null) {
            state.setDigest(instance);
        } else {
            state.getDigest().mergeWith(instance);
        }
    }

    @OutputFunction(value="SetDigest")
    public static void output(SetDigestState state, BlockBuilder out) {
        if (state.getDigest() == null) {
            out.appendNull();
        } else {
            SetDigestType.SET_DIGEST.writeSlice(out, state.getDigest().serialize());
        }
    }
}

