/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.tree;

import io.prestosql.sql.tree.AddColumn;
import io.prestosql.sql.tree.AliasedRelation;
import io.prestosql.sql.tree.AllColumns;
import io.prestosql.sql.tree.Analyze;
import io.prestosql.sql.tree.ArithmeticBinaryExpression;
import io.prestosql.sql.tree.ArithmeticUnaryExpression;
import io.prestosql.sql.tree.ArrayConstructor;
import io.prestosql.sql.tree.AstVisitor;
import io.prestosql.sql.tree.AtTimeZone;
import io.prestosql.sql.tree.BetweenPredicate;
import io.prestosql.sql.tree.BindExpression;
import io.prestosql.sql.tree.Cast;
import io.prestosql.sql.tree.CoalesceExpression;
import io.prestosql.sql.tree.ComparisonExpression;
import io.prestosql.sql.tree.CreateTable;
import io.prestosql.sql.tree.CreateTableAsSelect;
import io.prestosql.sql.tree.CreateView;
import io.prestosql.sql.tree.Cube;
import io.prestosql.sql.tree.Delete;
import io.prestosql.sql.tree.DereferenceExpression;
import io.prestosql.sql.tree.ExistsPredicate;
import io.prestosql.sql.tree.Explain;
import io.prestosql.sql.tree.ExplainOption;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.Extract;
import io.prestosql.sql.tree.FrameBound;
import io.prestosql.sql.tree.FunctionCall;
import io.prestosql.sql.tree.GroupBy;
import io.prestosql.sql.tree.GroupingElement;
import io.prestosql.sql.tree.GroupingOperation;
import io.prestosql.sql.tree.GroupingSets;
import io.prestosql.sql.tree.IfExpression;
import io.prestosql.sql.tree.InListExpression;
import io.prestosql.sql.tree.InPredicate;
import io.prestosql.sql.tree.Insert;
import io.prestosql.sql.tree.IsNotNullPredicate;
import io.prestosql.sql.tree.IsNullPredicate;
import io.prestosql.sql.tree.Join;
import io.prestosql.sql.tree.JoinOn;
import io.prestosql.sql.tree.Lateral;
import io.prestosql.sql.tree.LikePredicate;
import io.prestosql.sql.tree.LogicalBinaryExpression;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NotExpression;
import io.prestosql.sql.tree.NullIfExpression;
import io.prestosql.sql.tree.OrderBy;
import io.prestosql.sql.tree.Property;
import io.prestosql.sql.tree.QuantifiedComparisonExpression;
import io.prestosql.sql.tree.Query;
import io.prestosql.sql.tree.QuerySpecification;
import io.prestosql.sql.tree.Relation;
import io.prestosql.sql.tree.Rollup;
import io.prestosql.sql.tree.Row;
import io.prestosql.sql.tree.SampledRelation;
import io.prestosql.sql.tree.SearchedCaseExpression;
import io.prestosql.sql.tree.Select;
import io.prestosql.sql.tree.SelectItem;
import io.prestosql.sql.tree.SetOperation;
import io.prestosql.sql.tree.SetSession;
import io.prestosql.sql.tree.SimpleCaseExpression;
import io.prestosql.sql.tree.SimpleGroupBy;
import io.prestosql.sql.tree.SingleColumn;
import io.prestosql.sql.tree.SortItem;
import io.prestosql.sql.tree.StartTransaction;
import io.prestosql.sql.tree.SubqueryExpression;
import io.prestosql.sql.tree.SubscriptExpression;
import io.prestosql.sql.tree.TableElement;
import io.prestosql.sql.tree.TableSubquery;
import io.prestosql.sql.tree.TransactionMode;
import io.prestosql.sql.tree.TryExpression;
import io.prestosql.sql.tree.Unnest;
import io.prestosql.sql.tree.Values;
import io.prestosql.sql.tree.WhenClause;
import io.prestosql.sql.tree.Window;
import io.prestosql.sql.tree.WindowFrame;
import io.prestosql.sql.tree.With;
import io.prestosql.sql.tree.WithQuery;

public abstract class DefaultTraversalVisitor<R, C>
extends AstVisitor<R, C> {
    @Override
    protected R visitExtract(Extract node, C context) {
        return this.process(node.getExpression(), context);
    }

    @Override
    protected R visitCast(Cast node, C context) {
        return this.process(node.getExpression(), context);
    }

    @Override
    protected R visitArithmeticBinary(ArithmeticBinaryExpression node, C context) {
        this.process(node.getLeft(), context);
        this.process(node.getRight(), context);
        return null;
    }

    @Override
    protected R visitBetweenPredicate(BetweenPredicate node, C context) {
        this.process(node.getValue(), context);
        this.process(node.getMin(), context);
        this.process(node.getMax(), context);
        return null;
    }

    @Override
    protected R visitCoalesceExpression(CoalesceExpression node, C context) {
        for (Expression operand : node.getOperands()) {
            this.process(operand, context);
        }
        return null;
    }

    @Override
    protected R visitAtTimeZone(AtTimeZone node, C context) {
        this.process(node.getValue(), context);
        this.process(node.getTimeZone(), context);
        return null;
    }

    @Override
    protected R visitArrayConstructor(ArrayConstructor node, C context) {
        for (Expression expression : node.getValues()) {
            this.process(expression, context);
        }
        return null;
    }

    @Override
    protected R visitSubscriptExpression(SubscriptExpression node, C context) {
        this.process(node.getBase(), context);
        this.process(node.getIndex(), context);
        return null;
    }

    @Override
    protected R visitComparisonExpression(ComparisonExpression node, C context) {
        this.process(node.getLeft(), context);
        this.process(node.getRight(), context);
        return null;
    }

    @Override
    protected R visitQuery(Query node, C context) {
        if (node.getWith().isPresent()) {
            this.process(node.getWith().get(), context);
        }
        this.process(node.getQueryBody(), context);
        if (node.getOrderBy().isPresent()) {
            this.process(node.getOrderBy().get(), context);
        }
        return null;
    }

    @Override
    protected R visitWith(With node, C context) {
        for (WithQuery query : node.getQueries()) {
            this.process(query, context);
        }
        return null;
    }

    @Override
    protected R visitWithQuery(WithQuery node, C context) {
        return this.process(node.getQuery(), context);
    }

    @Override
    protected R visitSelect(Select node, C context) {
        for (SelectItem item : node.getSelectItems()) {
            this.process(item, context);
        }
        return null;
    }

    @Override
    protected R visitSingleColumn(SingleColumn node, C context) {
        this.process(node.getExpression(), context);
        return null;
    }

    @Override
    protected R visitAllColumns(AllColumns node, C context) {
        node.getTarget().ifPresent(value -> this.process((Node)value, context));
        return null;
    }

    @Override
    protected R visitWhenClause(WhenClause node, C context) {
        this.process(node.getOperand(), context);
        this.process(node.getResult(), context);
        return null;
    }

    @Override
    protected R visitInPredicate(InPredicate node, C context) {
        this.process(node.getValue(), context);
        this.process(node.getValueList(), context);
        return null;
    }

    @Override
    protected R visitFunctionCall(FunctionCall node, C context) {
        for (Expression argument : node.getArguments()) {
            this.process(argument, context);
        }
        if (node.getOrderBy().isPresent()) {
            this.process(node.getOrderBy().get(), context);
        }
        if (node.getWindow().isPresent()) {
            this.process(node.getWindow().get(), context);
        }
        if (node.getFilter().isPresent()) {
            this.process(node.getFilter().get(), context);
        }
        return null;
    }

    @Override
    protected R visitGroupingOperation(GroupingOperation node, C context) {
        for (Expression columnArgument : node.getGroupingColumns()) {
            this.process(columnArgument, context);
        }
        return null;
    }

    @Override
    protected R visitDereferenceExpression(DereferenceExpression node, C context) {
        this.process(node.getBase(), context);
        return null;
    }

    @Override
    public R visitWindow(Window node, C context) {
        for (Expression expression : node.getPartitionBy()) {
            this.process(expression, context);
        }
        if (node.getOrderBy().isPresent()) {
            this.process(node.getOrderBy().get(), context);
        }
        if (node.getFrame().isPresent()) {
            this.process(node.getFrame().get(), context);
        }
        return null;
    }

    @Override
    public R visitWindowFrame(WindowFrame node, C context) {
        this.process(node.getStart(), context);
        if (node.getEnd().isPresent()) {
            this.process(node.getEnd().get(), context);
        }
        return null;
    }

    @Override
    public R visitFrameBound(FrameBound node, C context) {
        if (node.getValue().isPresent()) {
            this.process(node.getValue().get(), context);
        }
        return null;
    }

    @Override
    protected R visitSimpleCaseExpression(SimpleCaseExpression node, C context) {
        this.process(node.getOperand(), context);
        for (WhenClause clause : node.getWhenClauses()) {
            this.process(clause, context);
        }
        node.getDefaultValue().ifPresent(value -> this.process((Node)value, context));
        return null;
    }

    @Override
    protected R visitInListExpression(InListExpression node, C context) {
        for (Expression value : node.getValues()) {
            this.process(value, context);
        }
        return null;
    }

    @Override
    protected R visitNullIfExpression(NullIfExpression node, C context) {
        this.process(node.getFirst(), context);
        this.process(node.getSecond(), context);
        return null;
    }

    @Override
    protected R visitIfExpression(IfExpression node, C context) {
        this.process(node.getCondition(), context);
        this.process(node.getTrueValue(), context);
        if (node.getFalseValue().isPresent()) {
            this.process(node.getFalseValue().get(), context);
        }
        return null;
    }

    @Override
    protected R visitTryExpression(TryExpression node, C context) {
        this.process(node.getInnerExpression(), context);
        return null;
    }

    @Override
    protected R visitBindExpression(BindExpression node, C context) {
        for (Expression value : node.getValues()) {
            this.process(value, context);
        }
        this.process(node.getFunction(), context);
        return null;
    }

    @Override
    protected R visitArithmeticUnary(ArithmeticUnaryExpression node, C context) {
        return this.process(node.getValue(), context);
    }

    @Override
    protected R visitNotExpression(NotExpression node, C context) {
        return this.process(node.getValue(), context);
    }

    @Override
    protected R visitSearchedCaseExpression(SearchedCaseExpression node, C context) {
        for (WhenClause clause : node.getWhenClauses()) {
            this.process(clause, context);
        }
        node.getDefaultValue().ifPresent(value -> this.process((Node)value, context));
        return null;
    }

    @Override
    protected R visitLikePredicate(LikePredicate node, C context) {
        this.process(node.getValue(), context);
        this.process(node.getPattern(), context);
        node.getEscape().ifPresent(value -> this.process((Node)value, context));
        return null;
    }

    @Override
    protected R visitIsNotNullPredicate(IsNotNullPredicate node, C context) {
        return this.process(node.getValue(), context);
    }

    @Override
    protected R visitIsNullPredicate(IsNullPredicate node, C context) {
        return this.process(node.getValue(), context);
    }

    @Override
    protected R visitLogicalBinaryExpression(LogicalBinaryExpression node, C context) {
        this.process(node.getLeft(), context);
        this.process(node.getRight(), context);
        return null;
    }

    @Override
    protected R visitSubqueryExpression(SubqueryExpression node, C context) {
        return this.process(node.getQuery(), context);
    }

    @Override
    protected R visitOrderBy(OrderBy node, C context) {
        for (SortItem sortItem : node.getSortItems()) {
            this.process(sortItem, context);
        }
        return null;
    }

    @Override
    protected R visitSortItem(SortItem node, C context) {
        return this.process(node.getSortKey(), context);
    }

    @Override
    protected R visitQuerySpecification(QuerySpecification node, C context) {
        this.process(node.getSelect(), context);
        if (node.getFrom().isPresent()) {
            this.process(node.getFrom().get(), context);
        }
        if (node.getWhere().isPresent()) {
            this.process(node.getWhere().get(), context);
        }
        if (node.getGroupBy().isPresent()) {
            this.process(node.getGroupBy().get(), context);
        }
        if (node.getHaving().isPresent()) {
            this.process(node.getHaving().get(), context);
        }
        if (node.getOrderBy().isPresent()) {
            this.process(node.getOrderBy().get(), context);
        }
        return null;
    }

    @Override
    protected R visitSetOperation(SetOperation node, C context) {
        for (Relation relation : node.getRelations()) {
            this.process(relation, context);
        }
        return null;
    }

    @Override
    protected R visitValues(Values node, C context) {
        for (Expression row : node.getRows()) {
            this.process(row, context);
        }
        return null;
    }

    @Override
    protected R visitRow(Row node, C context) {
        for (Expression expression : node.getItems()) {
            this.process(expression, context);
        }
        return null;
    }

    @Override
    protected R visitTableSubquery(TableSubquery node, C context) {
        return this.process(node.getQuery(), context);
    }

    @Override
    protected R visitAliasedRelation(AliasedRelation node, C context) {
        return this.process(node.getRelation(), context);
    }

    @Override
    protected R visitSampledRelation(SampledRelation node, C context) {
        this.process(node.getRelation(), context);
        this.process(node.getSamplePercentage(), context);
        return null;
    }

    @Override
    protected R visitJoin(Join node, C context) {
        this.process(node.getLeft(), context);
        this.process(node.getRight(), context);
        node.getCriteria().filter(criteria -> criteria instanceof JoinOn).map(criteria -> this.process(((JoinOn)criteria).getExpression(), context));
        return null;
    }

    @Override
    protected R visitUnnest(Unnest node, C context) {
        for (Expression expression : node.getExpressions()) {
            this.process(expression, context);
        }
        return null;
    }

    @Override
    protected R visitGroupBy(GroupBy node, C context) {
        for (GroupingElement groupingElement : node.getGroupingElements()) {
            this.process(groupingElement, context);
        }
        return null;
    }

    @Override
    protected R visitCube(Cube node, C context) {
        return null;
    }

    @Override
    protected R visitRollup(Rollup node, C context) {
        return null;
    }

    @Override
    protected R visitSimpleGroupBy(SimpleGroupBy node, C context) {
        for (Expression expression : node.getExpressions()) {
            this.process(expression, context);
        }
        return null;
    }

    @Override
    protected R visitGroupingSets(GroupingSets node, C context) {
        return null;
    }

    @Override
    protected R visitInsert(Insert node, C context) {
        this.process(node.getQuery(), context);
        return null;
    }

    @Override
    protected R visitDelete(Delete node, C context) {
        this.process(node.getTable(), context);
        node.getWhere().ifPresent(where -> this.process((Node)where, context));
        return null;
    }

    @Override
    protected R visitCreateTableAsSelect(CreateTableAsSelect node, C context) {
        this.process(node.getQuery(), context);
        for (Property property : node.getProperties()) {
            this.process(property, context);
        }
        return null;
    }

    @Override
    protected R visitProperty(Property node, C context) {
        this.process(node.getName(), context);
        this.process(node.getValue(), context);
        return null;
    }

    @Override
    protected R visitAnalyze(Analyze node, C context) {
        for (Property property : node.getProperties()) {
            this.process(property, context);
        }
        return null;
    }

    @Override
    protected R visitCreateView(CreateView node, C context) {
        this.process(node.getQuery(), context);
        return null;
    }

    @Override
    protected R visitSetSession(SetSession node, C context) {
        this.process(node.getValue(), context);
        return null;
    }

    @Override
    protected R visitAddColumn(AddColumn node, C context) {
        this.process(node.getColumn(), context);
        return null;
    }

    @Override
    protected R visitCreateTable(CreateTable node, C context) {
        for (TableElement tableElement : node.getElements()) {
            this.process(tableElement, context);
        }
        for (Property property : node.getProperties()) {
            this.process(property, context);
        }
        return null;
    }

    @Override
    protected R visitStartTransaction(StartTransaction node, C context) {
        for (TransactionMode transactionMode : node.getTransactionModes()) {
            this.process(transactionMode, context);
        }
        return null;
    }

    @Override
    protected R visitExplain(Explain node, C context) {
        this.process(node.getStatement(), context);
        for (ExplainOption option : node.getOptions()) {
            this.process(option, context);
        }
        return null;
    }

    @Override
    protected R visitQuantifiedComparisonExpression(QuantifiedComparisonExpression node, C context) {
        this.process(node.getValue(), context);
        this.process(node.getSubquery(), context);
        return null;
    }

    @Override
    protected R visitExists(ExistsPredicate node, C context) {
        this.process(node.getSubquery(), context);
        return null;
    }

    @Override
    protected R visitLateral(Lateral node, C context) {
        this.process(node.getQuery(), context);
        return super.visitLateral(node, context);
    }
}

