/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.proxy.server;

import java.io.IOException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.Objects;
import javax.net.ssl.SSLContext;
import javax.servlet.ServletException;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.client.api.AuthenticationDataProvider;
import org.apache.pulsar.client.api.AuthenticationFactory;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.common.util.SecurityUtility;
import org.apache.pulsar.proxy.server.ProxyConfiguration;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.proxy.AsyncProxyServlet;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AdminProxyHandler
extends AsyncProxyServlet.Transparent {
    private static final Logger LOG = LoggerFactory.getLogger(AdminProxyHandler.class);
    private final ProxyConfiguration config;

    AdminProxyHandler(ProxyConfiguration config) {
        this.config = config;
    }

    protected HttpClient createHttpClient() throws ServletException {
        HttpClient client = super.createHttpClient();
        client.setFollowRedirects(true);
        return client;
    }

    protected HttpClient newHttpClient() {
        block6: {
            try {
                Authentication auth = AuthenticationFactory.create((String)this.config.getBrokerClientAuthenticationPlugin(), (String)this.config.getBrokerClientAuthenticationParameters());
                Objects.requireNonNull(auth, "No supported auth found for proxy");
                auth.start();
                if (!this.config.isTlsEnabledWithBroker()) break block6;
                try {
                    Certificate[] trustCertificates = SecurityUtility.loadCertificatesFromPemFile((String)this.config.getTlsTrustCertsFilePath());
                    AuthenticationDataProvider authData = auth.getAuthData();
                    SSLContext sslCtx = authData.hasDataForTls() ? SecurityUtility.createSslContext((boolean)this.config.isTlsAllowInsecureConnection(), (Certificate[])trustCertificates, (Certificate[])authData.getTlsCertificates(), (PrivateKey)authData.getTlsPrivateKey()) : SecurityUtility.createSslContext((boolean)this.config.isTlsAllowInsecureConnection(), (Certificate[])trustCertificates);
                    SslContextFactory contextFactory = new SslContextFactory();
                    contextFactory.setSslContext(sslCtx);
                    return new HttpClient(contextFactory);
                }
                catch (Exception e) {
                    try {
                        auth.close();
                    }
                    catch (IOException ioe) {
                        LOG.error("Failed to close the authentication service", (Throwable)ioe);
                    }
                    throw new PulsarClientException.InvalidConfigurationException(e.getMessage());
                }
            }
            catch (PulsarClientException e) {
                throw new RuntimeException(e);
            }
        }
        return new HttpClient();
    }
}

