/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.proxy.server;

import io.netty.buffer.ByteBuf;
import io.netty.channel.EventLoopGroup;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.impl.ClientCnx;
import org.apache.pulsar.client.impl.HttpClient;
import org.apache.pulsar.client.impl.conf.ClientConfigurationData;
import org.apache.pulsar.common.api.Commands;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyClientCnx
extends ClientCnx {
    String clientAuthRole;
    String clientAuthData;
    String clientAuthMethod;
    private static final Logger log = LoggerFactory.getLogger(ProxyClientCnx.class);

    public ProxyClientCnx(ClientConfigurationData conf, EventLoopGroup eventLoopGroup, String clientAuthRole, String clientAuthData, String clientAuthMethod) {
        super(conf, eventLoopGroup);
        this.clientAuthRole = clientAuthRole;
        this.clientAuthData = clientAuthData;
        this.clientAuthMethod = clientAuthMethod;
    }

    protected ByteBuf newConnectCommand() throws PulsarClientException {
        if (log.isDebugEnabled()) {
            log.debug("New Connection opened via ProxyClientCnx with params clientAuthRole = {}, clientAuthData = {}, clientAuthMethod = {}", new Object[]{this.clientAuthRole, this.clientAuthData, this.clientAuthMethod});
        }
        String authData = null;
        if (this.authentication.getAuthData().hasDataFromCommand()) {
            authData = this.authentication.getAuthData().getCommandData();
        }
        return Commands.newConnect((String)this.authentication.getAuthMethodName(), (String)authData, (String)HttpClient.getPulsarClientVersion(), (String)this.proxyToTargetBrokerAddress, (String)this.clientAuthRole, (String)this.clientAuthData, (String)this.clientAuthMethod);
    }
}

