/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.proxy.server;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.channel.EventLoopGroup;
import java.util.Arrays;
import org.apache.pulsar.client.impl.ClientCnx;
import org.apache.pulsar.client.impl.conf.ClientConfigurationData;
import org.apache.pulsar.common.api.AuthData;
import org.apache.pulsar.common.api.proto.CommandAuthChallenge;
import org.apache.pulsar.common.protocol.Commands;
import org.apache.pulsar.proxy.server.ProxyConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyClientCnx
extends ClientCnx {
    private static final Logger log = LoggerFactory.getLogger(ProxyClientCnx.class);
    private final boolean forwardClientAuthData;
    private final String clientAuthMethod;
    private final String clientAuthRole;
    private final AuthData clientAuthData;
    private final ProxyConnection proxyConnection;

    public ProxyClientCnx(ClientConfigurationData conf, EventLoopGroup eventLoopGroup, String clientAuthRole, AuthData clientAuthData, String clientAuthMethod, int protocolVersion, boolean forwardClientAuthData, ProxyConnection proxyConnection) {
        super(conf, eventLoopGroup, protocolVersion);
        this.clientAuthRole = clientAuthRole;
        this.clientAuthData = clientAuthData;
        this.clientAuthMethod = clientAuthMethod;
        this.forwardClientAuthData = forwardClientAuthData;
        this.proxyConnection = proxyConnection;
    }

    protected ByteBuf newConnectCommand() throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("New Connection opened via ProxyClientCnx with params clientAuthRole = {}, clientAuthData = {}, clientAuthMethod = {}", new Object[]{this.clientAuthRole, this.clientAuthData, this.clientAuthMethod});
        }
        this.authenticationDataProvider = this.authentication.getAuthData(this.remoteHostName);
        AuthData authData = this.authenticationDataProvider.authenticate(AuthData.INIT_AUTH_DATA);
        return Commands.newConnect((String)this.authentication.getAuthMethodName(), (AuthData)authData, (int)this.protocolVersion, (String)this.proxyConnection.clientVersion, (String)this.proxyToTargetBrokerAddress, (String)this.clientAuthRole, (AuthData)this.clientAuthData, (String)this.clientAuthMethod);
    }

    protected void handleAuthChallenge(CommandAuthChallenge authChallenge) {
        Preconditions.checkArgument((boolean)authChallenge.hasChallenge());
        Preconditions.checkArgument((boolean)authChallenge.getChallenge().hasAuthData());
        boolean isRefresh = Arrays.equals(AuthData.REFRESH_AUTH_DATA_BYTES, authChallenge.getChallenge().getAuthData());
        if (!this.forwardClientAuthData || !isRefresh) {
            super.handleAuthChallenge(authChallenge);
            return;
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug("Proxy {} request to refresh the original client authentication data for the proxy client {}", (Object)this.proxyConnection.ctx().channel(), (Object)this.ctx.channel());
            }
            this.proxyConnection.ctx().writeAndFlush((Object)Commands.newAuthChallenge((String)this.clientAuthMethod, (AuthData)AuthData.REFRESH_AUTH_DATA, (int)this.protocolVersion)).addListener(writeFuture -> {
                if (writeFuture.isSuccess()) {
                    if (log.isDebugEnabled()) {
                        log.debug("Proxy {} sent the auth challenge to original client to refresh credentials with method {} for the proxy client {}", new Object[]{this.proxyConnection.ctx().channel(), this.clientAuthMethod, this.ctx.channel()});
                    }
                } else {
                    log.error("Failed to send the auth challenge to original client by the proxy {} for the proxy client {}", new Object[]{this.proxyConnection.ctx().channel(), this.ctx.channel(), writeFuture.cause()});
                    this.closeWithException(writeFuture.cause());
                }
            });
            if (this.state == ClientCnx.State.SentConnectFrame) {
                this.state = ClientCnx.State.Connecting;
            }
        }
        catch (Exception e) {
            log.error("Failed to send the auth challenge to origin client by the proxy {} for the proxy client {}", new Object[]{this.proxyConnection.ctx().channel(), this.ctx.channel(), e});
            this.closeWithException(e);
        }
    }
}

