/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.proxy.extensions;

import com.google.common.collect.ImmutableMap;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.socket.SocketChannel;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.pulsar.proxy.extensions.ExtensionsDefinitions;
import org.apache.pulsar.proxy.extensions.ProxyExtension;
import org.apache.pulsar.proxy.extensions.ProxyExtensionMetadata;
import org.apache.pulsar.proxy.extensions.ProxyExtensionWithClassLoader;
import org.apache.pulsar.proxy.extensions.ProxyExtensionsUtils;
import org.apache.pulsar.proxy.server.ProxyConfiguration;
import org.apache.pulsar.proxy.server.ProxyService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyExtensions
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(ProxyExtensions.class);
    private final Map<SocketAddress, String> endpoints = new ConcurrentHashMap<SocketAddress, String>();
    private final Map<String, ProxyExtensionWithClassLoader> extensions;

    public static ProxyExtensions load(ProxyConfiguration conf) throws IOException {
        ExtensionsDefinitions definitions = ProxyExtensionsUtils.searchForExtensions(conf.getProxyExtensionsDirectory(), conf.getNarExtractionDirectory());
        ImmutableMap.Builder extensionsBuilder = ImmutableMap.builder();
        conf.getProxyExtensions().forEach(extensionName -> {
            ProxyExtensionWithClassLoader extension;
            ProxyExtensionMetadata definition = definitions.extensions().get(extensionName);
            if (null == definition) {
                throw new RuntimeException("No extension is found for extension name `" + extensionName + "`. Available extensions are : " + definitions.extensions());
            }
            try {
                extension = ProxyExtensionsUtils.load(definition, conf.getNarExtractionDirectory());
            }
            catch (IOException e) {
                log.error("Failed to load the extension for extension `" + extensionName + "`", (Throwable)e);
                throw new RuntimeException("Failed to load the extension for extension name `" + extensionName + "`");
            }
            if (!extension.accept((String)extensionName)) {
                extension.close();
                log.error("Malformed extension found for extensionName `" + extensionName + "`");
                throw new RuntimeException("Malformed extension found for extension name `" + extensionName + "`");
            }
            extensionsBuilder.put(extensionName, (Object)extension);
            log.info("Successfully loaded extension for extension name `{}`", extensionName);
        });
        return new ProxyExtensions((Map<String, ProxyExtensionWithClassLoader>)extensionsBuilder.build());
    }

    ProxyExtensions(Map<String, ProxyExtensionWithClassLoader> extensions) {
        this.extensions = extensions;
    }

    public ProxyExtension extension(String extension) {
        ProxyExtensionWithClassLoader h = this.extensions.get(extension);
        if (null == h) {
            return null;
        }
        return h.getExtension();
    }

    public void initialize(ProxyConfiguration conf) throws Exception {
        for (ProxyExtension proxyExtension : this.extensions.values()) {
            proxyExtension.initialize(conf);
        }
    }

    public Map<String, Map<InetSocketAddress, ChannelInitializer<SocketChannel>>> newChannelInitializers() {
        HashMap<String, Map<InetSocketAddress, ChannelInitializer<SocketChannel>>> channelInitializers = new HashMap<String, Map<InetSocketAddress, ChannelInitializer<SocketChannel>>>();
        HashSet addresses = new HashSet();
        for (Map.Entry<String, ProxyExtensionWithClassLoader> extension : this.extensions.entrySet()) {
            Map<InetSocketAddress, ChannelInitializer<SocketChannel>> initializers = extension.getValue().newChannelInitializers();
            initializers.forEach((address, initializer) -> {
                if (!addresses.add(address)) {
                    log.error("extension for `{}` attempts to use {} for its listening port. But it is already occupied by other extensions.", extension.getKey(), address);
                    throw new RuntimeException("extension for `" + (String)extension.getKey() + "` attempts to use " + address + " for its listening port. But it is already occupied by other messaging extensions");
                }
                this.endpoints.put((SocketAddress)address, (String)extension.getKey());
                channelInitializers.put((String)extension.getKey(), initializers);
            });
        }
        return channelInitializers;
    }

    public void start(ProxyService service) {
        this.extensions.values().forEach(extension -> extension.start(service));
    }

    @Override
    public void close() {
        this.extensions.values().forEach(ProxyExtension::close);
    }

    public Map<SocketAddress, String> getEndpoints() {
        return this.endpoints;
    }
}

