/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.proxy.server.util;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.common.util.OrderedExecutor;
import org.apache.bookkeeper.common.util.OrderedScheduler;
import org.apache.pulsar.common.util.ObjectMapperFactory;
import org.apache.pulsar.policies.data.loadbalancer.LoadManagerReport;
import org.apache.pulsar.zookeeper.LocalZooKeeperCache;
import org.apache.pulsar.zookeeper.ZooKeeperCache;
import org.apache.pulsar.zookeeper.ZooKeeperChildrenCache;
import org.apache.pulsar.zookeeper.ZooKeeperClientFactory;
import org.apache.pulsar.zookeeper.ZooKeeperDataCache;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZookeeperCacheLoader
implements Closeable {
    private final ZooKeeper zkClient;
    private final ZooKeeperCache localZkCache;
    private final ZooKeeperDataCache<LoadManagerReport> brokerInfo;
    private final ZooKeeperChildrenCache availableBrokersCache;
    private volatile List<LoadManagerReport> availableBrokers;
    private final OrderedScheduler orderedExecutor = (OrderedScheduler)OrderedScheduler.newSchedulerBuilder().numThreads(8).name("pulsar-proxy-ordered-cache").build();
    public static final String LOADBALANCE_BROKERS_ROOT = "/loadbalance/brokers";
    private static final Logger log = LoggerFactory.getLogger(ZookeeperCacheLoader.class);

    public ZookeeperCacheLoader(ZooKeeperClientFactory factory, String zookeeperServers, int zookeeperSessionTimeoutMs) throws Exception {
        this.zkClient = (ZooKeeper)factory.create(zookeeperServers, ZooKeeperClientFactory.SessionType.AllowReadOnly, zookeeperSessionTimeoutMs).get();
        this.localZkCache = new LocalZooKeeperCache(this.zkClient, (int)TimeUnit.MILLISECONDS.toSeconds(zookeeperSessionTimeoutMs), (OrderedExecutor)this.orderedExecutor);
        this.brokerInfo = new ZooKeeperDataCache<LoadManagerReport>(this.localZkCache){

            public LoadManagerReport deserialize(String key, byte[] content) throws Exception {
                return (LoadManagerReport)ObjectMapperFactory.getThreadLocal().readValue(content, LoadManagerReport.class);
            }
        };
        this.availableBrokersCache = new ZooKeeperChildrenCache(this.getLocalZkCache(), LOADBALANCE_BROKERS_ROOT);
        this.availableBrokersCache.registerListener((path, brokerNodes, stat) -> {
            try {
                this.updateBrokerList((Set<String>)brokerNodes);
            }
            catch (Exception e) {
                log.warn("Error updating broker info after broker list changed.", (Throwable)e);
            }
        });
        try {
            this.updateBrokerList(this.availableBrokersCache.get());
        }
        catch (KeeperException.NoNodeException nne) {
            this.updateBrokerList(Collections.emptySet());
        }
    }

    public List<LoadManagerReport> getAvailableBrokers() {
        return this.availableBrokers;
    }

    public ZooKeeperCache getLocalZkCache() {
        return this.localZkCache;
    }

    @Override
    public void close() throws IOException {
        try {
            this.zkClient.close();
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw new IOException(e);
        }
        this.orderedExecutor.shutdown();
    }

    private void updateBrokerList(Set<String> brokerNodes) throws Exception {
        ArrayList<LoadManagerReport> availableBrokers = new ArrayList<LoadManagerReport>(brokerNodes.size());
        for (String broker : brokerNodes) {
            availableBrokers.add((LoadManagerReport)this.brokerInfo.get("/loadbalance/brokers/" + broker).get());
        }
        this.availableBrokers = availableBrokers;
    }
}

