/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.proxy.server;

import com.google.common.collect.Lists;
import io.prometheus.client.jetty.JettyStatisticsCollector;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.TimeZone;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.pulsar.broker.authentication.AuthenticationService;
import org.apache.pulsar.broker.web.AuthenticationFilter;
import org.apache.pulsar.broker.web.JsonMapperProvider;
import org.apache.pulsar.broker.web.WebExecutorThreadPool;
import org.apache.pulsar.common.util.SecurityUtility;
import org.apache.pulsar.common.util.keystoretls.KeyStoreSSLContext;
import org.apache.pulsar.proxy.server.ProxyConfiguration;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.Slf4jRequestLog;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.server.handler.StatisticsHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebServer {
    private static final String MATCH_ALL = "/*";
    private final Server server;
    private final WebExecutorThreadPool webServiceExecutor;
    private final AuthenticationService authenticationService;
    private final List<String> servletPaths = Lists.newArrayList();
    private final List<Handler> handlers = Lists.newArrayList();
    private final ProxyConfiguration config;
    protected int externalServicePort;
    private URI serviceURI = null;
    private ServerConnector connector;
    private ServerConnector connectorTls;
    private static final Logger log = LoggerFactory.getLogger(WebServer.class);

    public WebServer(ProxyConfiguration config, AuthenticationService authenticationService) throws IOException {
        this.webServiceExecutor = new WebExecutorThreadPool(config.getHttpNumThreads(), "pulsar-external-web");
        this.server = new Server((ThreadPool)this.webServiceExecutor);
        this.authenticationService = authenticationService;
        this.config = config;
        ArrayList connectors = Lists.newArrayList();
        HttpConfiguration http_config = new HttpConfiguration();
        http_config.setOutputBufferSize(config.getHttpOutputBufferSize());
        if (config.getWebServicePort().isPresent()) {
            this.externalServicePort = config.getWebServicePort().get();
            this.connector = new ServerConnector(this.server, 1, 1, new ConnectionFactory[]{new HttpConnectionFactory(http_config)});
            this.connector.setPort(this.externalServicePort);
            connectors.add(this.connector);
        }
        if (config.getWebServicePortTls().isPresent()) {
            try {
                SslContextFactory sslCtxFactory = config.isTlsEnabledWithKeyStore() ? KeyStoreSSLContext.createSslContextFactory((String)config.getTlsProvider(), (String)config.getTlsKeyStoreType(), (String)config.getTlsKeyStore(), (String)config.getTlsKeyStorePassword(), (boolean)config.isTlsAllowInsecureConnection(), (String)config.getTlsTrustStoreType(), (String)config.getTlsTrustStore(), (String)config.getTlsTrustStorePassword(), (boolean)config.isTlsRequireTrustedClientCertOnConnect(), (long)config.getTlsCertRefreshCheckDurationSec()) : SecurityUtility.createSslContextFactory((boolean)config.isTlsAllowInsecureConnection(), (String)config.getTlsTrustCertsFilePath(), (String)config.getTlsCertificateFilePath(), (String)config.getTlsKeyFilePath(), (boolean)config.isTlsRequireTrustedClientCertOnConnect(), (boolean)true, (long)config.getTlsCertRefreshCheckDurationSec());
                this.connectorTls = new ServerConnector(this.server, 1, 1, sslCtxFactory);
                this.connectorTls.setPort(config.getWebServicePortTls().get().intValue());
                connectors.add(this.connectorTls);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        connectors.stream().forEach(c -> c.setAcceptQueueSize(1024 / connectors.size()));
        this.server.setConnectors((Connector[])connectors.toArray(new ServerConnector[connectors.size()]));
    }

    public URI getServiceUri() {
        return this.serviceURI;
    }

    public void addServlet(String basePath, ServletHolder servletHolder) {
        this.addServlet(basePath, servletHolder, Collections.emptyList());
    }

    public void addServlet(String basePath, ServletHolder servletHolder, List<Pair<String, Object>> attributes) {
        this.addServlet(basePath, servletHolder, attributes, true);
    }

    public void addServlet(String basePath, ServletHolder servletHolder, List<Pair<String, Object>> attributes, boolean requireAuthentication) {
        Optional<String> existingPath = this.servletPaths.stream().filter(p -> p.startsWith(basePath)).findFirst();
        if (existingPath.isPresent()) {
            throw new IllegalArgumentException(String.format("Cannot add servlet at %s, path %s already exists", basePath, existingPath.get()));
        }
        this.servletPaths.add(basePath);
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath(basePath);
        context.addServlet(servletHolder, MATCH_ALL);
        for (Pair<String, Object> attribute : attributes) {
            context.setAttribute((String)attribute.getLeft(), attribute.getRight());
        }
        if (this.config.isAuthenticationEnabled() && requireAuthentication) {
            FilterHolder filter = new FilterHolder((Filter)new AuthenticationFilter(this.authenticationService));
            context.addFilter(filter, MATCH_ALL, EnumSet.allOf(DispatcherType.class));
        }
        this.handlers.add((Handler)context);
    }

    public void addRestResources(String basePath, String javaPackages, String attribute, Object attributeValue) {
        ResourceConfig config = new ResourceConfig();
        config.packages(new String[]{"jersey.config.server.provider.packages", javaPackages});
        config.register(JsonMapperProvider.class);
        ServletHolder servletHolder = new ServletHolder((Servlet)new ServletContainer(config));
        servletHolder.setAsyncSupported(true);
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath(basePath);
        context.addServlet(servletHolder, MATCH_ALL);
        context.setAttribute(attribute, attributeValue);
        this.handlers.add((Handler)context);
    }

    public int getExternalServicePort() {
        return this.externalServicePort;
    }

    public void start() throws Exception {
        RequestLogHandler requestLogHandler = new RequestLogHandler();
        Slf4jRequestLog requestLog = new Slf4jRequestLog();
        requestLog.setExtended(true);
        requestLog.setLogTimeZone(TimeZone.getDefault().getID());
        requestLog.setLogLatency(true);
        requestLogHandler.setRequestLog((RequestLog)requestLog);
        this.handlers.add(0, (Handler)new ContextHandlerCollection());
        this.handlers.add((Handler)requestLogHandler);
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        contexts.setHandlers(this.handlers.toArray(new Handler[this.handlers.size()]));
        HandlerCollection handlerCollection = new HandlerCollection();
        handlerCollection.setHandlers(new Handler[]{contexts, new DefaultHandler(), requestLogHandler});
        StatisticsHandler stats = new StatisticsHandler();
        stats.setHandler((Handler)handlerCollection);
        try {
            new JettyStatisticsCollector(stats).register();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.server.setHandler((Handler)stats);
        try {
            this.server.start();
            Arrays.stream(this.server.getConnectors()).filter(c -> c instanceof ServerConnector).findFirst().ifPresent(c -> {
                this.externalServicePort = ((ServerConnector)c).getPort();
            });
            URI reportedURI = this.server.getURI();
            this.serviceURI = new URI(reportedURI.getScheme(), null, reportedURI.getHost(), reportedURI.getPort(), null, null, null);
        }
        catch (Exception e) {
            ArrayList<Integer> ports = new ArrayList<Integer>();
            for (Connector c2 : this.server.getConnectors()) {
                if (!(c2 instanceof ServerConnector)) continue;
                ports.add(((ServerConnector)c2).getPort());
            }
            throw new IOException("Failed to start HTTP server on ports " + ports, e);
        }
        log.info("Server started at end point {}", (Object)this.getServiceUri());
    }

    public void stop() throws Exception {
        this.server.stop();
        this.webServiceExecutor.stop();
        log.info("Server stopped successfully");
    }

    public boolean isStarted() {
        return this.server.isStarted();
    }

    public Optional<Integer> getListenPortHTTP() {
        if (this.connector != null) {
            return Optional.of(this.connector.getLocalPort());
        }
        return Optional.empty();
    }

    public Optional<Integer> getListenPortHTTPS() {
        if (this.connectorTls != null) {
            return Optional.of(this.connectorTls.getLocalPort());
        }
        return Optional.empty();
    }
}

