/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.proxy.server.plugin.servlet;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.common.nar.NarClassLoader;
import org.apache.pulsar.common.util.ObjectMapperFactory;
import org.apache.pulsar.proxy.server.plugin.servlet.ProxyAdditionalServlet;
import org.apache.pulsar.proxy.server.plugin.servlet.ProxyAdditionalServletDefinition;
import org.apache.pulsar.proxy.server.plugin.servlet.ProxyAdditionalServletDefinitions;
import org.apache.pulsar.proxy.server.plugin.servlet.ProxyAdditionalServletMetadata;
import org.apache.pulsar.proxy.server.plugin.servlet.ProxyAdditionalServletWithClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProxyAdditionalServletUtils {
    private static final Logger log = LoggerFactory.getLogger(ProxyAdditionalServletUtils.class);
    public static final String PROXY_ADDITIONAL_SERVLET_FILE = "proxy_additional_servlet.yml";

    public static ProxyAdditionalServletDefinition getProxyAdditionalServletDefinition(String narPath, String narExtractionDirectory) throws IOException {
        try (NarClassLoader ncl = NarClassLoader.getFromArchive((File)new File(narPath), Collections.emptySet(), (String)narExtractionDirectory);){
            ProxyAdditionalServletDefinition proxyAdditionalServletDefinition = ProxyAdditionalServletUtils.getProxyAdditionalServletDefinition(ncl);
            return proxyAdditionalServletDefinition;
        }
    }

    private static ProxyAdditionalServletDefinition getProxyAdditionalServletDefinition(NarClassLoader ncl) throws IOException {
        String configStr = ncl.getServiceDefinition(PROXY_ADDITIONAL_SERVLET_FILE);
        return (ProxyAdditionalServletDefinition)ObjectMapperFactory.getThreadLocalYaml().readValue(configStr, ProxyAdditionalServletDefinition.class);
    }

    public static ProxyAdditionalServletDefinitions searchForServlets(String additionalServletDirectory, String narExtractionDirectory) throws IOException {
        Path path = Paths.get(additionalServletDirectory, new String[0]).toAbsolutePath();
        log.info("Searching for proxy additional servlets in {}", (Object)path);
        ProxyAdditionalServletDefinitions servletDefinitions = new ProxyAdditionalServletDefinitions();
        if (!path.toFile().exists()) {
            log.warn("Pulsar proxy additional servlets directory not found");
            return servletDefinitions;
        }
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(path, "*.nar");){
            for (Path archive : stream) {
                try {
                    ProxyAdditionalServletDefinition def = ProxyAdditionalServletUtils.getProxyAdditionalServletDefinition(archive.toString(), narExtractionDirectory);
                    log.info("Found proxy additional servlet from {} : {}", (Object)archive, (Object)def);
                    Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)def.getName()));
                    Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)def.getAdditionalServletClass()));
                    ProxyAdditionalServletMetadata metadata = new ProxyAdditionalServletMetadata();
                    metadata.setDefinition(def);
                    metadata.setArchivePath(archive);
                    servletDefinitions.servlets().put(def.getName(), metadata);
                }
                catch (Throwable t) {
                    log.warn("Failed to load proxy additional servlet from {}. It is OK however if you want to use this proxy additional servlet, please make sure you put the correct proxy additional servlet NAR package in the proxy additional servlets directory.", (Object)archive, (Object)t);
                }
            }
        }
        return servletDefinitions;
    }

    public static ProxyAdditionalServletWithClassLoader load(ProxyAdditionalServletMetadata metadata, String narExtractionDirectory) throws IOException {
        NarClassLoader ncl = NarClassLoader.getFromArchive((File)metadata.getArchivePath().toAbsolutePath().toFile(), Collections.emptySet(), (ClassLoader)ProxyAdditionalServlet.class.getClassLoader(), (String)narExtractionDirectory);
        ProxyAdditionalServletDefinition def = ProxyAdditionalServletUtils.getProxyAdditionalServletDefinition(ncl);
        if (StringUtils.isBlank((CharSequence)def.getAdditionalServletClass())) {
            throw new IOException("Proxy additional servlets `" + def.getName() + "` does NOT provide a proxy additional servlets implementation");
        }
        try {
            Class additionalServletClass = ncl.loadClass(def.getAdditionalServletClass());
            Object additionalServlet = additionalServletClass.newInstance();
            if (!(additionalServlet instanceof ProxyAdditionalServlet)) {
                throw new IOException("Class " + def.getAdditionalServletClass() + " does not implement proxy additional servlet interface");
            }
            ProxyAdditionalServlet servlet = (ProxyAdditionalServlet)additionalServlet;
            return new ProxyAdditionalServletWithClassLoader(servlet, ncl);
        }
        catch (Throwable t) {
            ProxyAdditionalServletUtils.rethrowIOException(t);
            return null;
        }
    }

    private static void rethrowIOException(Throwable cause) throws IOException {
        if (cause instanceof IOException) {
            throw (IOException)cause;
        }
        if (cause instanceof RuntimeException) {
            throw (RuntimeException)cause;
        }
        if (cause instanceof Error) {
            throw (Error)cause;
        }
        throw new IOException(cause.getMessage(), cause);
    }

    private ProxyAdditionalServletUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

