/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.proxy.server;

import inet.ipaddr.IPAddress;
import inet.ipaddr.IPAddressString;
import inet.ipaddr.ipv4.IPv4Address;
import inet.ipaddr.ipv6.IPv6Address;
import io.netty.resolver.AddressResolver;
import io.netty.util.concurrent.Future;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.pulsar.common.util.FutureUtil;
import org.apache.pulsar.common.util.netty.NettyFutureUtil;
import org.apache.pulsar.proxy.server.TargetAddressDeniedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrokerProxyValidator {
    private static final Logger log = LoggerFactory.getLogger(BrokerProxyValidator.class);
    private static final String SEPARATOR = "\\s*,\\s*";
    private static final String ALLOW_ANY = "*";
    private final int[] allowedTargetPorts;
    private final boolean allowAnyTargetPort;
    private final List<IPAddress> allowedIPAddresses;
    private final boolean allowAnyIPAddress;
    private final AddressResolver<InetSocketAddress> inetSocketAddressResolver;
    private final List<Pattern> allowedHostNames;
    private final boolean allowAnyHostName;

    public BrokerProxyValidator(AddressResolver<InetSocketAddress> inetSocketAddressResolver, String allowedHostNames, String allowedIPAddresses, String allowedTargetPorts) {
        this.inetSocketAddressResolver = inetSocketAddressResolver;
        List<String> allowedHostNamesStrings = BrokerProxyValidator.parseCommaSeparatedConfigValue(allowedHostNames);
        if (allowedHostNamesStrings.contains(ALLOW_ANY)) {
            this.allowAnyHostName = true;
            this.allowedHostNames = Collections.emptyList();
        } else {
            this.allowAnyHostName = false;
            this.allowedHostNames = allowedHostNamesStrings.stream().map(BrokerProxyValidator::parseWildcardPattern).collect(Collectors.toList());
        }
        List<String> allowedIPAddressesStrings = BrokerProxyValidator.parseCommaSeparatedConfigValue(allowedIPAddresses);
        if (allowedIPAddressesStrings.contains(ALLOW_ANY)) {
            this.allowAnyIPAddress = true;
            this.allowedIPAddresses = Collections.emptyList();
        } else {
            this.allowAnyIPAddress = false;
            this.allowedIPAddresses = allowedIPAddressesStrings.stream().map(IPAddressString::new).filter(ipAddressString -> {
                if (ipAddressString.isValid()) {
                    return true;
                }
                throw new IllegalArgumentException("Invalid IP address filter '" + ipAddressString + "'", (Throwable)ipAddressString.getAddressStringException());
            }).map(IPAddressString::getAddress).filter(Objects::nonNull).collect(Collectors.toList());
        }
        List<String> allowedTargetPortsStrings = BrokerProxyValidator.parseCommaSeparatedConfigValue(allowedTargetPorts);
        if (allowedTargetPortsStrings.contains(ALLOW_ANY)) {
            this.allowAnyTargetPort = true;
            this.allowedTargetPorts = new int[0];
        } else {
            this.allowAnyTargetPort = false;
            this.allowedTargetPorts = allowedTargetPortsStrings.stream().mapToInt(Integer::parseInt).toArray();
        }
    }

    private static Pattern parseWildcardPattern(String wildcardPattern) {
        String regexPattern = Collections.list(new StringTokenizer(wildcardPattern, ALLOW_ANY, true)).stream().map(String::valueOf).map(token -> {
            if (ALLOW_ANY.equals(token)) {
                return ".*";
            }
            return Pattern.quote(token);
        }).collect(Collectors.joining());
        return Pattern.compile("^" + regexPattern + "$", 2);
    }

    private static List<String> parseCommaSeparatedConfigValue(String configValue) {
        return Arrays.stream(configValue.split(SEPARATOR)).map(String::trim).filter(s -> s.length() > 0).collect(Collectors.toList());
    }

    public CompletableFuture<InetSocketAddress> resolveAndCheckTargetAddress(String hostAndPort) {
        int pos = hostAndPort.lastIndexOf(58);
        String host = hostAndPort.substring(0, pos);
        int port = Integer.parseInt(hostAndPort.substring(pos + 1));
        if (!this.isPortAllowed(port)) {
            return FutureUtil.failedFuture((Throwable)new TargetAddressDeniedException("Given port in '" + hostAndPort + "' isn't allowed."));
        }
        if (!this.isHostAllowed(host)) {
            return FutureUtil.failedFuture((Throwable)new TargetAddressDeniedException("Given host in '" + hostAndPort + "' isn't allowed."));
        }
        return NettyFutureUtil.toCompletableFuture((Future)this.inetSocketAddressResolver.resolve((SocketAddress)InetSocketAddress.createUnresolved(host, port))).thenCompose(resolvedAddress -> {
            CompletableFuture<InetSocketAddress> result = new CompletableFuture<InetSocketAddress>();
            if (this.isIPAddressAllowed((InetSocketAddress)resolvedAddress)) {
                result.complete((InetSocketAddress)resolvedAddress);
            } else {
                result.completeExceptionally(new TargetAddressDeniedException("The IP address of the given host and port '" + hostAndPort + "' isn't allowed."));
            }
            return result;
        });
    }

    private boolean isPortAllowed(int port) {
        if (this.allowAnyTargetPort) {
            return true;
        }
        for (int allowedPort : this.allowedTargetPorts) {
            if (allowedPort != port) continue;
            return true;
        }
        return false;
    }

    private boolean isIPAddressAllowed(InetSocketAddress resolvedAddress) {
        if (this.allowAnyIPAddress) {
            return true;
        }
        byte[] addressBytes = resolvedAddress.getAddress().getAddress();
        IPv4Address candidateAddress = addressBytes.length == 4 ? new IPv4Address(addressBytes) : new IPv6Address(addressBytes);
        for (IPAddress allowedAddress : this.allowedIPAddresses) {
            if (!allowedAddress.contains((IPAddress)candidateAddress)) continue;
            return true;
        }
        return false;
    }

    private boolean isHostAllowed(String host) {
        if (this.allowAnyHostName) {
            return true;
        }
        boolean matched = false;
        for (Pattern allowedHostName : this.allowedHostNames) {
            if (!allowedHostName.matcher(host).matches()) continue;
            matched = true;
            break;
        }
        return matched;
    }
}

