/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.testclient;

import io.netty.util.internal.PlatformDependent;
import java.lang.management.ManagementFactory;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;

public final class PerfClientUtils {
    private static volatile Consumer<Integer> exitProcedure = System::exit;

    public static void setExitProcedure(Consumer<Integer> exitProcedure) {
        PerfClientUtils.exitProcedure = Objects.requireNonNull(exitProcedure);
    }

    public static void exit(int code) {
        exitProcedure.accept(code);
    }

    public static void printJVMInformation(Logger log) {
        log.info("JVM args {}", ManagementFactory.getRuntimeMXBean().getInputArguments());
        log.info("Netty max memory (PlatformDependent.maxDirectMemory()) {}", (Object)FileUtils.byteCountToDisplaySize((long)PlatformDependent.maxDirectMemory()));
        log.info("JVM max heap memory (Runtime.getRuntime().maxMemory()) {}", (Object)FileUtils.byteCountToDisplaySize((long)Runtime.getRuntime().maxMemory()));
    }

    private PerfClientUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

