/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.websocket;

import org.apache.pulsar.websocket.PingPongHandler;
import org.apache.pulsar.websocket.WebSocketService;
import org.eclipse.jetty.websocket.servlet.WebSocketServlet;
import org.eclipse.jetty.websocket.servlet.WebSocketServletFactory;

public class WebSocketPingPongServlet
extends WebSocketServlet {
    private static final long serialVersionUID = 1L;
    public static final String SERVLET_PATH = "/ws/pingpong";
    public static final String SERVLET_PATH_V2 = "/ws/v2/pingpong";
    private final transient WebSocketService service;

    public WebSocketPingPongServlet(WebSocketService service) {
        this.service = service;
    }

    public void configure(WebSocketServletFactory factory) {
        factory.getPolicy().setMaxTextMessageSize(this.service.getConfig().getWebSocketMaxTextFrameSize());
        if (this.service.getConfig().getWebSocketSessionIdleTimeoutMillis() > 0) {
            factory.getPolicy().setIdleTimeout((long)this.service.getConfig().getWebSocketSessionIdleTimeoutMillis());
        }
        factory.setCreator((request, response) -> new PingPongHandler());
    }
}

