/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.websocket.data;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.common.base.Joiner;
import org.apache.pulsar.websocket.WebSocketError;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ProducerAck {
    public String result;
    public String errorMsg;
    public String messageId;
    public String context;
    public int errorCode;
    public long schemaVersion;

    public ProducerAck(String messageId, String context) {
        this.result = "ok";
        this.messageId = messageId;
        this.context = context;
    }

    public ProducerAck(WebSocketError error, String errorMsg, String messageId, String context) {
        this.result = Joiner.on((char)':').join((Object)"send-error", (Object)error.getCode(), new Object[0]);
        this.errorMsg = errorMsg;
        this.messageId = messageId;
        this.context = context;
    }

    public String getResult() {
        return this.result;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public String getContext() {
        return this.context;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public long getSchemaVersion() {
        return this.schemaVersion;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

    public void setSchemaVersion(long schemaVersion) {
        this.schemaVersion = schemaVersion;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProducerAck)) {
            return false;
        }
        ProducerAck other = (ProducerAck)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$result = this.getResult();
        String other$result = other.getResult();
        if (this$result == null ? other$result != null : !this$result.equals(other$result)) {
            return false;
        }
        String this$errorMsg = this.getErrorMsg();
        String other$errorMsg = other.getErrorMsg();
        if (this$errorMsg == null ? other$errorMsg != null : !this$errorMsg.equals(other$errorMsg)) {
            return false;
        }
        String this$messageId = this.getMessageId();
        String other$messageId = other.getMessageId();
        if (this$messageId == null ? other$messageId != null : !this$messageId.equals(other$messageId)) {
            return false;
        }
        String this$context = this.getContext();
        String other$context = other.getContext();
        if (this$context == null ? other$context != null : !this$context.equals(other$context)) {
            return false;
        }
        if (this.getErrorCode() != other.getErrorCode()) {
            return false;
        }
        return this.getSchemaVersion() == other.getSchemaVersion();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ProducerAck;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $result = this.getResult();
        result = result * 59 + ($result == null ? 43 : $result.hashCode());
        String $errorMsg = this.getErrorMsg();
        result = result * 59 + ($errorMsg == null ? 43 : $errorMsg.hashCode());
        String $messageId = this.getMessageId();
        result = result * 59 + ($messageId == null ? 43 : $messageId.hashCode());
        String $context = this.getContext();
        result = result * 59 + ($context == null ? 43 : $context.hashCode());
        result = result * 59 + this.getErrorCode();
        long $schemaVersion = this.getSchemaVersion();
        result = result * 59 + (int)($schemaVersion >>> 32 ^ $schemaVersion);
        return result;
    }

    public String toString() {
        return "ProducerAck(result=" + this.getResult() + ", errorMsg=" + this.getErrorMsg() + ", messageId=" + this.getMessageId() + ", context=" + this.getContext() + ", errorCode=" + this.getErrorCode() + ", schemaVersion=" + this.getSchemaVersion() + ")";
    }

    public ProducerAck() {
    }

    public ProducerAck(String result, String errorMsg, String messageId, String context, int errorCode, long schemaVersion) {
        this.result = result;
        this.errorMsg = errorMsg;
        this.messageId = messageId;
        this.context = context;
        this.errorCode = errorCode;
        this.schemaVersion = schemaVersion;
    }
}

