/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.zookeeper;

import io.netty.util.concurrent.DefaultThreadFactory;
import java.io.Closeable;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.zookeeper.ZookeeperSessionExpiredHandler;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperSessionWatcher
implements Watcher,
AsyncCallback.StatCallback,
Runnable,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(ZooKeeperSessionWatcher.class);
    private final ZookeeperSessionExpiredHandler sessionExpiredHandler;
    private final ZooKeeper zk;
    private final long monitorTimeoutMillis;
    private final long tickTimeMillis;
    private ScheduledExecutorService scheduler = null;
    private Watcher.Event.KeeperState keeperState = Watcher.Event.KeeperState.Disconnected;
    private long disconnectedAt = 0L;
    private boolean shuttingDown = false;
    private volatile boolean zkOperationCompleted = false;
    private ScheduledFuture<?> task;

    public ZooKeeperSessionWatcher(ZooKeeper zk, long zkSessionTimeoutMillis, ZookeeperSessionExpiredHandler sessionExpiredHandler) {
        this.zk = zk;
        this.monitorTimeoutMillis = zkSessionTimeoutMillis * 5L / 6L;
        this.tickTimeMillis = zkSessionTimeoutMillis / 15L;
        this.sessionExpiredHandler = sessionExpiredHandler;
        this.sessionExpiredHandler.setWatcher(this);
    }

    public void start() {
        this.scheduler = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new DefaultThreadFactory("pulsar-zk-session-watcher"));
        this.task = this.scheduler.scheduleAtFixedRate(this, this.tickTimeMillis, this.tickTimeMillis, TimeUnit.MILLISECONDS);
    }

    public Watcher.Event.KeeperState getKeeperState() {
        return this.keeperState;
    }

    public boolean isShutdownStarted() {
        return this.shuttingDown;
    }

    public void process(WatchedEvent event) {
        Watcher.Event.EventType eventType = event.getType();
        Watcher.Event.KeeperState eventState = event.getState();
        LOG.info("Received zookeeper notification, eventType={}, eventState={}", (Object)eventType, (Object)eventState);
        switch (eventType) {
            case None: {
                if (eventState != Watcher.Event.KeeperState.Expired) break;
                LOG.error("ZooKeeper session already expired, invoking shutdown");
                this.sessionExpiredHandler.onSessionExpired();
                break;
            }
        }
    }

    public synchronized void processResult(int rc, String path, Object ctx, Stat stat) {
        switch (KeeperException.Code.get((int)rc)) {
            case CONNECTIONLOSS: {
                this.keeperState = Watcher.Event.KeeperState.Disconnected;
                break;
            }
            case SESSIONEXPIRED: {
                this.keeperState = Watcher.Event.KeeperState.Expired;
                break;
            }
            default: {
                this.keeperState = Watcher.Event.KeeperState.SyncConnected;
            }
        }
        this.zkOperationCompleted = true;
        this.notify();
    }

    @Override
    public synchronized void run() {
        try {
            this.zkOperationCompleted = false;
            if (this.zk != null) {
                try {
                    this.zk.exists("/", false, (AsyncCallback.StatCallback)this, null);
                    this.wait(this.tickTimeMillis);
                }
                catch (InterruptedException | RejectedExecutionException e) {
                    LOG.info("ZooKeeperSessionWatcher interrupted");
                    if (this.task != null) {
                        this.task.cancel(true);
                    }
                    return;
                }
            }
            if (!this.zkOperationCompleted) {
                this.keeperState = Watcher.Event.KeeperState.Disconnected;
            }
            if (this.keeperState == Watcher.Event.KeeperState.Expired) {
                LOG.error("zookeeper session expired, invoking shutdown service");
                this.sessionExpiredHandler.onSessionExpired();
            } else if (this.keeperState == Watcher.Event.KeeperState.Disconnected) {
                long timeRemainingMillis;
                if (this.disconnectedAt == 0L) {
                    this.disconnectedAt = System.nanoTime();
                }
                if ((timeRemainingMillis = this.monitorTimeoutMillis - TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.disconnectedAt)) <= 0L) {
                    LOG.error("timeout expired for reconnecting, invoking shutdown service");
                    this.sessionExpiredHandler.onSessionExpired();
                } else {
                    LOG.warn("zoo keeper disconnected, waiting to reconnect, time remaining = {} seconds", (Object)TimeUnit.MILLISECONDS.toSeconds(timeRemainingMillis));
                }
            } else if (this.disconnectedAt != 0L) {
                LOG.info("reconnected to zoo keeper, system is back to normal.");
                this.disconnectedAt = 0L;
            }
        }
        catch (Exception e) {
            LOG.warn(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void close() {
        if (this.scheduler != null) {
            this.scheduler.shutdownNow();
        }
        this.shuttingDown = true;
    }

    public static interface ShutdownService {
        default public void run() {
            this.shutdown(0);
        }

        public void shutdown(int var1);
    }
}

