/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.zookeeper;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.pulsar.zookeeper.ZooKeeperCache;
import org.apache.pulsar.zookeeper.ZooKeeperCacheListener;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperChildrenCache
implements Watcher,
ZooKeeperCache.CacheUpdater<Set<String>> {
    private static final Logger LOG = LoggerFactory.getLogger(ZooKeeperChildrenCache.class);
    private final ZooKeeperCache cache;
    private final String path;
    private final List<ZooKeeperCacheListener<Set<String>>> listeners = Lists.newCopyOnWriteArrayList();
    private final AtomicBoolean isShutdown;

    public ZooKeeperChildrenCache(ZooKeeperCache cache, String path) {
        this.cache = cache;
        this.path = path;
        this.isShutdown = new AtomicBoolean(false);
    }

    public Set<String> get() throws KeeperException, InterruptedException {
        return this.get(this.path);
    }

    public Set<String> get(String path) throws KeeperException, InterruptedException {
        Set<String> children;
        if (LOG.isDebugEnabled()) {
            LOG.debug("getChildren called at: {}", (Object)path);
        }
        if ((children = this.cache.getChildrenAsync(path, this).join()) == null) {
            throw KeeperException.create((KeeperException.Code)KeeperException.Code.NONODE);
        }
        return children;
    }

    public CompletableFuture<Set<String>> getAsync() {
        return this.getAsync(this.path);
    }

    public CompletableFuture<Set<String>> getAsync(String path) {
        return this.cache.getChildrenAsync(path, this);
    }

    public void clear() {
        this.cache.invalidateChildren(this.path);
    }

    @Override
    public void reloadCache(String path) {
        this.cache.invalidate(path);
        ((CompletableFuture)((CompletableFuture)this.cache.getChildrenAsync(path, this).thenAccept(children -> {
            LOG.info("reloadCache called in zookeeperChildrenCache for path {}", (Object)path);
            for (ZooKeeperCacheListener<Set<String>> listener : this.listeners) {
                listener.onUpdate(path, (Set<String>)children, null);
            }
        })).exceptionally(ex -> {
            LOG.warn("Reloading ZooKeeperDataCache failed at path:{}", (Object)path, ex);
            return null;
        })).join();
    }

    @Override
    public void registerListener(ZooKeeperCacheListener<Set<String>> listener) {
        this.listeners.add(listener);
    }

    @Override
    public void unregisterListener(ZooKeeperCacheListener<Set<String>> listener) {
        this.listeners.remove(listener);
    }

    public void process(WatchedEvent event) {
        LOG.info("[{}] Received ZooKeeper watch event: {}", (Object)this.cache.zkSession.get(), (Object)event);
        if (!this.isShutdown.get()) {
            this.cache.process(event, this);
        }
    }

    public void close() {
        this.isShutdown.set(true);
    }
}

