/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.zookeeper;

import java.nio.charset.StandardCharsets;
import org.apache.pulsar.common.policies.data.Policies;
import org.apache.pulsar.zookeeper.Deserializers;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class DeserializersTest {
    @BeforeMethod
    void setup() throws Exception {
    }

    @AfterMethod(alwaysRun=true)
    void teardown() throws Exception {
    }

    @Test
    public void testSimpleStringDeserialize() throws Exception {
        String key = "test_key";
        byte[] content = "test_content".getBytes(StandardCharsets.UTF_8);
        String result = (String)Deserializers.STRING_DESERIALIZER.deserialize(key, content);
        Assert.assertEquals((String)result, (String)"test_content");
    }

    @Test
    public void testSimplePolicyDeserialize() throws Exception {
        String key = "test_key";
        String jsonPolicy = "{\"auth_policies\":{\"namespace_auth\":{},\"destination_auth\":{}},\"replication_clusters\":[],\"bundles_activated\":true,\"backlog_quota_map\":{},\"persistence\":null,\"latency_stats_sample_rate\":{},\"message_ttl_in_seconds\":null}";
        byte[] content = jsonPolicy.getBytes(StandardCharsets.UTF_8);
        Policies result = (Policies)Deserializers.POLICY_DESERIALIZER.deserialize(key, content);
        Assert.assertEquals((Object)result, (Object)new Policies());
    }
}

