/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.zookeeper;

import java.util.Collections;
import java.util.List;
import org.apache.pulsar.zookeeper.LocalBookkeeperEnsemble;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class LocalBookkeeperEnsembleTest {
    @BeforeMethod
    void setup() throws Exception {
    }

    @AfterMethod(alwaysRun=true)
    void teardown() throws Exception {
    }

    @Test
    public void testAdvertisedAddress() throws Exception {
        boolean numBk = true;
        LocalBookkeeperEnsemble ensemble = new LocalBookkeeperEnsemble(1, 0, 0, null, null, true, "127.0.0.2");
        ensemble.startStandalone();
        List bookies = ensemble.getZkClient().getChildren("/ledgers/available", false);
        Collections.sort(bookies);
        Assert.assertEquals((int)bookies.size(), (int)2);
        Assert.assertTrue((boolean)((String)bookies.get(0)).startsWith("127.0.0.2:"));
        ensemble.stop();
    }

    @Test
    public void testStartStop() throws Exception {
        boolean numBk = true;
        LocalBookkeeperEnsemble ensemble = new LocalBookkeeperEnsemble(1, 0, () -> 0);
        ensemble.start();
        Assert.assertTrue((boolean)ensemble.getZkServer().isRunning());
        Assert.assertEquals((int)ensemble.getZkServer().getClientPort(), (int)ensemble.getZookeeperPort());
        Assert.assertTrue((boolean)ensemble.getZkClient().getState().isConnected());
        Assert.assertTrue((boolean)ensemble.getBookies()[0].isRunning());
        ensemble.stop();
        Assert.assertFalse((boolean)ensemble.getZkServer().isRunning());
        Assert.assertFalse((boolean)ensemble.getZkClient().getState().isConnected());
        Assert.assertFalse((boolean)ensemble.getBookies()[0].isRunning());
    }
}

