/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.zookeeper;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.netty.util.HashedWheelTimer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.feature.SettableFeatureProvider;
import org.apache.bookkeeper.net.BookieId;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.util.ZkUtils;
import org.apache.bookkeeper.zookeeper.ZooKeeperClient;
import org.apache.pulsar.common.policies.data.BookieInfo;
import org.apache.pulsar.common.policies.data.EnsemblePlacementPolicyConfig;
import org.apache.pulsar.common.util.ObjectMapperFactory;
import org.apache.pulsar.zookeeper.ZkIsolatedBookieEnsemblePlacementPolicy;
import org.apache.pulsar.zookeeper.ZooKeeperCache;
import org.apache.pulsar.zookeeper.ZookeeperServerTest;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.awaitility.Awaitility;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ZkIsolatedBookieEnsemblePlacementPolicyTest {
    private static final String BOOKIE1 = "127.0.0.1:3181";
    private static final String BOOKIE2 = "127.0.0.2:3181";
    private static final String BOOKIE3 = "127.0.0.3:3181";
    private static final String BOOKIE4 = "127.0.0.4:3181";
    private static final String BOOKIE5 = "127.0.0.5:3181";
    private ZookeeperServerTest localZkS;
    private ZooKeeper localZkc;
    private final ObjectMapper jsonMapper = ObjectMapperFactory.create();
    Set<BookieId> writableBookies = new HashSet<BookieId>();
    Set<BookieId> readOnlyBookies = new HashSet<BookieId>();
    List<String> isolationGroups = new ArrayList<String>();
    HashedWheelTimer timer;

    @BeforeMethod
    public void setUp() throws Exception {
        this.timer = new HashedWheelTimer();
        this.localZkS = new ZookeeperServerTest(0);
        this.localZkS.start();
        this.localZkc = ZooKeeperClient.newBuilder().connectString("127.0.0.1:" + this.localZkS.getZookeeperPort()).build();
        this.writableBookies.add(new BookieSocketAddress(BOOKIE1).toBookieId());
        this.writableBookies.add(new BookieSocketAddress(BOOKIE2).toBookieId());
        this.writableBookies.add(new BookieSocketAddress(BOOKIE3).toBookieId());
        this.writableBookies.add(new BookieSocketAddress(BOOKIE4).toBookieId());
        this.isolationGroups.add("group1");
    }

    @AfterMethod(alwaysRun=true)
    void teardown() throws Exception {
        this.writableBookies.clear();
        this.isolationGroups.clear();
        this.localZkS.close();
        this.timer.stop();
    }

    @Test
    public void testBasic() throws Exception {
        HashMap bookieMapping = new HashMap();
        HashMap<String, BookieInfo> mainBookieGroup = new HashMap<String, BookieInfo>();
        mainBookieGroup.put(BOOKIE1, BookieInfo.builder().rack("rack0").build());
        mainBookieGroup.put(BOOKIE2, BookieInfo.builder().rack("rack1").build());
        HashMap<String, BookieInfo> secondaryBookieGroup = new HashMap<String, BookieInfo>();
        secondaryBookieGroup.put(BOOKIE3, BookieInfo.builder().rack("rack0").build());
        bookieMapping.put("group1", mainBookieGroup);
        bookieMapping.put("group2", secondaryBookieGroup);
        ZkUtils.createFullPathOptimistic((ZooKeeper)this.localZkc, (String)"/bookies", (byte[])this.jsonMapper.writeValueAsBytes(bookieMapping), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT);
        Awaitility.await().until(() -> this.localZkc.exists("/bookies", false) != null);
        ZkIsolatedBookieEnsemblePlacementPolicy isolationPolicy = new ZkIsolatedBookieEnsemblePlacementPolicy();
        ClientConfiguration bkClientConf = new ClientConfiguration();
        bkClientConf.setProperty("zk_cache_instance", (Object)new ZooKeeperCache("test", this.localZkc, 30){});
        bkClientConf.setProperty("isolationBookieGroups", this.isolationGroups);
        isolationPolicy.initialize(bkClientConf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE, BookieSocketAddress.LEGACY_BOOKIEID_RESOLVER);
        isolationPolicy.onClusterChanged(this.writableBookies, this.readOnlyBookies);
        List ensemble = (List)isolationPolicy.newEnsemble(3, 3, 2, Collections.emptyMap(), new HashSet()).getResult();
        Assert.assertTrue((boolean)ensemble.contains(new BookieSocketAddress(BOOKIE1).toBookieId()));
        Assert.assertTrue((boolean)ensemble.contains(new BookieSocketAddress(BOOKIE2).toBookieId()));
        Assert.assertTrue((boolean)ensemble.contains(new BookieSocketAddress(BOOKIE4).toBookieId()));
        ensemble = (List)isolationPolicy.newEnsemble(1, 1, 1, Collections.emptyMap(), new HashSet()).getResult();
        Assert.assertFalse((boolean)ensemble.contains(new BookieSocketAddress(BOOKIE3).toBookieId()));
        try {
            isolationPolicy.newEnsemble(4, 4, 4, Collections.emptyMap(), new HashSet());
            Assert.fail((String)"should not pass");
        }
        catch (BKException.BKNotEnoughBookiesException bKNotEnoughBookiesException) {
            // empty catch block
        }
        HashSet<BookieId> bookieToExclude = new HashSet<BookieId>();
        bookieToExclude.add(new BookieSocketAddress(BOOKIE1).toBookieId());
        ensemble = (List)isolationPolicy.newEnsemble(2, 2, 2, Collections.emptyMap(), bookieToExclude).getResult();
        Assert.assertTrue((boolean)ensemble.contains(new BookieSocketAddress(BOOKIE4).toBookieId()));
        Assert.assertTrue((boolean)ensemble.contains(new BookieSocketAddress(BOOKIE2).toBookieId()));
        secondaryBookieGroup.put(BOOKIE4, BookieInfo.builder().rack("rack0").build());
        bookieMapping.put("group2", secondaryBookieGroup);
        byte[] data = this.jsonMapper.writeValueAsBytes(bookieMapping);
        this.localZkc.setData("/bookies", data, -1);
        Awaitility.await().until(() -> Arrays.equals(data, this.localZkc.getData("/bookies", false, null)));
        ensemble = (List)isolationPolicy.newEnsemble(2, 2, 2, Collections.emptyMap(), null).getResult();
        Assert.assertTrue((boolean)ensemble.contains(new BookieSocketAddress(BOOKIE1).toBookieId()));
        Assert.assertTrue((boolean)ensemble.contains(new BookieSocketAddress(BOOKIE2).toBookieId()));
        try {
            isolationPolicy.newEnsemble(3, 3, 3, Collections.emptyMap(), new HashSet());
            Assert.fail((String)"should not pass");
        }
        catch (BKException.BKNotEnoughBookiesException bKNotEnoughBookiesException) {
            // empty catch block
        }
        try {
            isolationPolicy.replaceBookie(3, 3, 3, Collections.emptyMap(), ensemble, new BookieSocketAddress(BOOKIE5).toBookieId(), new HashSet());
            Assert.fail((String)"should not pass");
        }
        catch (BKException.BKNotEnoughBookiesException bKNotEnoughBookiesException) {
            // empty catch block
        }
        bookieToExclude = new HashSet();
        bookieToExclude.add(new BookieSocketAddress(BOOKIE1).toBookieId());
        ensemble = (List)isolationPolicy.newEnsemble(1, 1, 1, Collections.emptyMap(), bookieToExclude).getResult();
        BookieId chosenBookie = (BookieId)isolationPolicy.replaceBookie(1, 1, 1, Collections.emptyMap(), ensemble, (BookieId)ensemble.get(0), new HashSet()).getResult();
        Assert.assertEquals((Object)new BookieSocketAddress(BOOKIE1).toBookieId(), (Object)chosenBookie);
        this.localZkc.delete("/bookies", -1);
    }

    @Test
    public void testNoBookieInfo() throws Exception {
        ZkIsolatedBookieEnsemblePlacementPolicy isolationPolicy = new ZkIsolatedBookieEnsemblePlacementPolicy();
        ClientConfiguration bkClientConf = new ClientConfiguration();
        bkClientConf.setProperty("zk_cache_instance", (Object)new ZooKeeperCache("test", this.localZkc, 30){});
        bkClientConf.setProperty("isolationBookieGroups", this.isolationGroups);
        isolationPolicy.initialize(bkClientConf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE, BookieSocketAddress.LEGACY_BOOKIEID_RESOLVER);
        isolationPolicy.onClusterChanged(this.writableBookies, this.readOnlyBookies);
        isolationPolicy.newEnsemble(4, 4, 4, Collections.emptyMap(), new HashSet());
        String data = "{\"group1\": {\"127.0.0.1:3181\": {\"rack\": \"rack0\", \"hostname\": \"bookie1.example.com\"}, \"127.0.0.2:3181\": {\"rack\": \"rack1\", \"hostname\": \"bookie2.example.com\"}}, \"group2\": {\"127.0.0.3:3181\": {\"rack\": \"rack0\", \"hostname\": \"bookie3.example.com\"}, \"127.0.0.4:3181\": {\"rack\": \"rack2\", \"hostname\": \"bookie4.example.com\"}}}";
        ZkUtils.createFullPathOptimistic((ZooKeeper)this.localZkc, (String)"/bookies", (byte[])data.getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT);
        Awaitility.await().until(() -> Arrays.equals(data.getBytes(StandardCharsets.UTF_8), this.localZkc.getData("/bookies", false, null)));
        List ensemble = (List)isolationPolicy.newEnsemble(2, 2, 2, Collections.emptyMap(), new HashSet()).getResult();
        Assert.assertTrue((boolean)ensemble.contains(new BookieSocketAddress(BOOKIE1).toBookieId()));
        Assert.assertTrue((boolean)ensemble.contains(new BookieSocketAddress(BOOKIE2).toBookieId()));
        try {
            isolationPolicy.newEnsemble(3, 3, 3, Collections.emptyMap(), new HashSet());
            Assert.fail((String)"should not pass");
        }
        catch (BKException.BKNotEnoughBookiesException bKNotEnoughBookiesException) {
            // empty catch block
        }
        this.localZkc.delete("/bookies", -1);
    }

    @Test
    public void testBookieInfoChange() throws Exception {
        HashMap bookieMapping = new HashMap();
        HashMap<String, BookieInfo> mainBookieGroup = new HashMap<String, BookieInfo>();
        HashMap<String, BookieInfo> secondaryBookieGroup = new HashMap<String, BookieInfo>();
        mainBookieGroup.put(BOOKIE1, BookieInfo.builder().rack("rack0").build());
        mainBookieGroup.put(BOOKIE2, BookieInfo.builder().rack("rack1").build());
        secondaryBookieGroup.put(BOOKIE3, BookieInfo.builder().rack("rack0").build());
        secondaryBookieGroup.put(BOOKIE4, BookieInfo.builder().rack("rack2").build());
        bookieMapping.put("group1", mainBookieGroup);
        bookieMapping.put("group2", secondaryBookieGroup);
        byte[] data = this.jsonMapper.writeValueAsBytes(bookieMapping);
        ZkUtils.createFullPathOptimistic((ZooKeeper)this.localZkc, (String)"/bookies", (byte[])data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT);
        Awaitility.await().until(() -> Arrays.equals(data, this.localZkc.getData("/bookies", false, null)));
        ZkIsolatedBookieEnsemblePlacementPolicy isolationPolicy = new ZkIsolatedBookieEnsemblePlacementPolicy();
        ClientConfiguration bkClientConf = new ClientConfiguration();
        bkClientConf.setZkServers("127.0.0.1:" + this.localZkS.getZookeeperPort());
        bkClientConf.setZkTimeout(1000);
        bkClientConf.setProperty("isolationBookieGroups", this.isolationGroups);
        isolationPolicy.initialize(bkClientConf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE, BookieSocketAddress.LEGACY_BOOKIEID_RESOLVER);
        isolationPolicy.onClusterChanged(this.writableBookies, this.readOnlyBookies);
        List ensemble = (List)isolationPolicy.newEnsemble(2, 2, 2, Collections.emptyMap(), new HashSet()).getResult();
        Assert.assertTrue((boolean)ensemble.contains(new BookieSocketAddress(BOOKIE1).toBookieId()));
        Assert.assertTrue((boolean)ensemble.contains(new BookieSocketAddress(BOOKIE2).toBookieId()));
        try {
            isolationPolicy.newEnsemble(3, 3, 3, Collections.emptyMap(), new HashSet());
            Assert.fail((String)"should not pass");
        }
        catch (BKException.BKNotEnoughBookiesException bKNotEnoughBookiesException) {
            // empty catch block
        }
        mainBookieGroup.put(BOOKIE3, BookieInfo.builder().rack("rack1").build());
        secondaryBookieGroup.remove(BOOKIE3);
        bookieMapping.put("group1", mainBookieGroup);
        bookieMapping.put("group2", secondaryBookieGroup);
        byte[] data2 = this.jsonMapper.writeValueAsBytes(bookieMapping);
        this.localZkc.setData("/bookies", data2, -1);
        Awaitility.await().until(() -> Arrays.equals(data2, this.localZkc.getData("/bookies", false, null)));
        ensemble = (List)isolationPolicy.newEnsemble(3, 3, 3, Collections.emptyMap(), new HashSet()).getResult();
        Assert.assertTrue((boolean)ensemble.contains(new BookieSocketAddress(BOOKIE1).toBookieId()));
        Assert.assertTrue((boolean)ensemble.contains(new BookieSocketAddress(BOOKIE2).toBookieId()));
        Assert.assertTrue((boolean)ensemble.contains(new BookieSocketAddress(BOOKIE3).toBookieId()));
        this.localZkc.delete("/bookies", -1);
        Awaitility.await().until(() -> this.localZkc.exists("/bookies", false) == null);
        isolationPolicy.newEnsemble(1, 1, 1, Collections.emptyMap(), new HashSet());
    }

    @Test
    public void testNoIsolationGroup() throws Exception {
        String data = "{\"group1\": {\"127.0.0.1:3181\": {\"rack\": \"rack0\", \"hostname\": \"bookie1.example.com\"}, \"127.0.0.2:3181\": {\"rack\": \"rack1\", \"hostname\": \"bookie2.example.com\"}}, \"group2\": {\"127.0.0.3:3181\": {\"rack\": \"rack0\", \"hostname\": \"bookie3.example.com\"}, \"127.0.0.4:3181\": {\"rack\": \"rack2\", \"hostname\": \"bookie4.example.com\"}}}";
        ZkUtils.createFullPathOptimistic((ZooKeeper)this.localZkc, (String)"/bookies", (byte[])data.getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT);
        Awaitility.await().until(() -> this.localZkc.exists("/bookies", false) != null);
        ZkIsolatedBookieEnsemblePlacementPolicy isolationPolicy = new ZkIsolatedBookieEnsemblePlacementPolicy();
        ClientConfiguration bkClientConf = new ClientConfiguration();
        bkClientConf.setProperty("zk_cache_instance", (Object)new ZooKeeperCache("test", this.localZkc, 30){});
        isolationPolicy.initialize(bkClientConf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE, BookieSocketAddress.LEGACY_BOOKIEID_RESOLVER);
        isolationPolicy.onClusterChanged(this.writableBookies, this.readOnlyBookies);
        isolationPolicy.newEnsemble(4, 4, 4, Collections.emptyMap(), new HashSet());
    }

    @Test
    public void testOverlappedBookies() throws Exception {
        HashMap bookieMapping = new HashMap();
        HashMap<String, BookieInfo> defaultBookieGroup = new HashMap<String, BookieInfo>();
        String isolatedGroup = "isolatedGroup";
        defaultBookieGroup.put(BOOKIE1, BookieInfo.builder().rack("rack0").build());
        defaultBookieGroup.put(BOOKIE2, BookieInfo.builder().rack("rack1").build());
        defaultBookieGroup.put(BOOKIE3, BookieInfo.builder().rack("rack1").build());
        defaultBookieGroup.put(BOOKIE4, BookieInfo.builder().rack("rack1").build());
        defaultBookieGroup.put(BOOKIE5, BookieInfo.builder().rack("rack1").build());
        HashMap<String, BookieInfo> isolatedBookieGroup = new HashMap<String, BookieInfo>();
        isolatedBookieGroup.put(BOOKIE1, BookieInfo.builder().rack("rack1").build());
        isolatedBookieGroup.put(BOOKIE2, BookieInfo.builder().rack("rack0").build());
        isolatedBookieGroup.put(BOOKIE4, BookieInfo.builder().rack("rack0").build());
        bookieMapping.put("default", defaultBookieGroup);
        bookieMapping.put("isolatedGroup", isolatedBookieGroup);
        ZkUtils.createFullPathOptimistic((ZooKeeper)this.localZkc, (String)"/bookies", (byte[])this.jsonMapper.writeValueAsBytes(bookieMapping), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT);
        Awaitility.await().until(() -> this.localZkc.exists("/bookies", false) != null);
        ZkIsolatedBookieEnsemblePlacementPolicy isolationPolicy = new ZkIsolatedBookieEnsemblePlacementPolicy();
        ClientConfiguration bkClientConf = new ClientConfiguration();
        bkClientConf.setProperty("zk_cache_instance", (Object)new ZooKeeperCache("test", this.localZkc, 30){});
        bkClientConf.setProperty("isolationBookieGroups", (Object)"isolatedGroup");
        isolationPolicy.initialize(bkClientConf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE, BookieSocketAddress.LEGACY_BOOKIEID_RESOLVER);
        isolationPolicy.onClusterChanged(this.writableBookies, this.readOnlyBookies);
        List ensemble = (List)isolationPolicy.newEnsemble(3, 3, 2, Collections.emptyMap(), new HashSet()).getResult();
        Assert.assertTrue((boolean)ensemble.contains(new BookieSocketAddress(BOOKIE1).toBookieId()));
        Assert.assertTrue((boolean)ensemble.contains(new BookieSocketAddress(BOOKIE2).toBookieId()));
        Assert.assertTrue((boolean)ensemble.contains(new BookieSocketAddress(BOOKIE4).toBookieId()));
        this.localZkc.delete("/bookies", -1);
    }

    @Test
    public void testSecondaryIsolationGroupsBookies() throws Exception {
        HashMap bookieMapping = new HashMap();
        HashMap<String, BookieInfo> defaultBookieGroup = new HashMap<String, BookieInfo>();
        String isolatedGroup = "primaryGroup";
        String secondaryIsolatedGroup = "secondaryGroup";
        defaultBookieGroup.put(BOOKIE1, BookieInfo.builder().rack("rack0").build());
        defaultBookieGroup.put(BOOKIE2, BookieInfo.builder().rack("rack1").build());
        defaultBookieGroup.put(BOOKIE3, BookieInfo.builder().rack("rack1").build());
        defaultBookieGroup.put(BOOKIE4, BookieInfo.builder().rack("rack1").build());
        defaultBookieGroup.put(BOOKIE5, BookieInfo.builder().rack("rack1").build());
        HashMap<String, BookieInfo> primaryIsolatedBookieGroup = new HashMap<String, BookieInfo>();
        primaryIsolatedBookieGroup.put(BOOKIE1, BookieInfo.builder().rack("rack1").build());
        HashMap<String, BookieInfo> secondaryIsolatedBookieGroup = new HashMap<String, BookieInfo>();
        secondaryIsolatedBookieGroup.put(BOOKIE2, BookieInfo.builder().rack("rack0").build());
        secondaryIsolatedBookieGroup.put(BOOKIE4, BookieInfo.builder().rack("rack0").build());
        bookieMapping.put("default", defaultBookieGroup);
        bookieMapping.put("primaryGroup", primaryIsolatedBookieGroup);
        bookieMapping.put("secondaryGroup", secondaryIsolatedBookieGroup);
        ZkUtils.createFullPathOptimistic((ZooKeeper)this.localZkc, (String)"/bookies", (byte[])this.jsonMapper.writeValueAsBytes(bookieMapping), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT);
        Awaitility.await().until(() -> this.localZkc.exists("/bookies", false) != null);
        ZkIsolatedBookieEnsemblePlacementPolicy isolationPolicy = new ZkIsolatedBookieEnsemblePlacementPolicy();
        ClientConfiguration bkClientConf = new ClientConfiguration();
        bkClientConf.setProperty("zk_cache_instance", (Object)new ZooKeeperCache("test", this.localZkc, 30){});
        bkClientConf.setProperty("isolationBookieGroups", (Object)"primaryGroup");
        bkClientConf.setProperty("secondaryIsolationBookieGroups", (Object)"secondaryGroup");
        isolationPolicy.initialize(bkClientConf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE, BookieSocketAddress.LEGACY_BOOKIEID_RESOLVER);
        isolationPolicy.onClusterChanged(this.writableBookies, this.readOnlyBookies);
        List ensemble = (List)isolationPolicy.newEnsemble(3, 3, 2, Collections.emptyMap(), new HashSet()).getResult();
        Assert.assertTrue((boolean)ensemble.contains(new BookieSocketAddress(BOOKIE1).toBookieId()));
        Assert.assertTrue((boolean)ensemble.contains(new BookieSocketAddress(BOOKIE2).toBookieId()));
        Assert.assertTrue((boolean)ensemble.contains(new BookieSocketAddress(BOOKIE4).toBookieId()));
        this.localZkc.delete("/bookies", -1);
    }

    @Test
    public void testSecondaryIsolationGroupsBookiesNegative() throws Exception {
        HashMap bookieMapping = new HashMap();
        HashMap<String, BookieInfo> defaultBookieGroup = new HashMap<String, BookieInfo>();
        String isolatedGroup = "primaryGroup";
        String secondaryIsolatedGroup = "secondaryGroup";
        defaultBookieGroup.put(BOOKIE1, BookieInfo.builder().rack("rack0").build());
        defaultBookieGroup.put(BOOKIE2, BookieInfo.builder().rack("rack1").build());
        defaultBookieGroup.put(BOOKIE3, BookieInfo.builder().rack("rack1").build());
        defaultBookieGroup.put(BOOKIE4, BookieInfo.builder().rack("rack1").build());
        defaultBookieGroup.put(BOOKIE5, BookieInfo.builder().rack("rack1").build());
        HashMap<String, BookieInfo> primaryIsolatedBookieGroup = new HashMap<String, BookieInfo>();
        primaryIsolatedBookieGroup.put(BOOKIE1, BookieInfo.builder().rack("rack1").build());
        bookieMapping.put("default", defaultBookieGroup);
        bookieMapping.put("primaryGroup", primaryIsolatedBookieGroup);
        ZkUtils.createFullPathOptimistic((ZooKeeper)this.localZkc, (String)"/bookies", (byte[])this.jsonMapper.writeValueAsBytes(bookieMapping), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT);
        Awaitility.await().until(() -> this.localZkc.exists("/bookies", false) != null);
        ZkIsolatedBookieEnsemblePlacementPolicy isolationPolicy = new ZkIsolatedBookieEnsemblePlacementPolicy();
        ClientConfiguration bkClientConf = new ClientConfiguration();
        bkClientConf.setProperty("zk_cache_instance", (Object)new ZooKeeperCache("test", this.localZkc, 30){});
        bkClientConf.setProperty("isolationBookieGroups", (Object)"primaryGroup");
        bkClientConf.setProperty("secondaryIsolationBookieGroups", (Object)"secondaryGroup");
        isolationPolicy.initialize(bkClientConf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE, BookieSocketAddress.LEGACY_BOOKIEID_RESOLVER);
        isolationPolicy.onClusterChanged(this.writableBookies, this.readOnlyBookies);
        try {
            isolationPolicy.newEnsemble(3, 3, 2, Collections.emptyMap(), new HashSet()).getResult();
            Assert.fail((String)"Should have thrown BKNotEnoughBookiesException");
        }
        catch (BKException.BKNotEnoughBookiesException bKNotEnoughBookiesException) {
            // empty catch block
        }
        this.localZkc.delete("/bookies", -1);
    }

    @Test
    public void testTheIsolationPolicyUsingCustomMetadata() throws Exception {
        HashMap bookieMapping = new HashMap();
        HashMap<String, BookieInfo> primaryIsolationBookieGroups = new HashMap<String, BookieInfo>();
        String primaryGroupName = "primary";
        String secondaryGroupName = "secondary";
        primaryIsolationBookieGroups.put(BOOKIE1, BookieInfo.builder().rack("rack0").build());
        primaryIsolationBookieGroups.put(BOOKIE2, BookieInfo.builder().rack("rack0").build());
        primaryIsolationBookieGroups.put(BOOKIE3, BookieInfo.builder().rack("rack1").build());
        HashMap<String, BookieInfo> secondaryIsolationBookieGroups = new HashMap<String, BookieInfo>();
        secondaryIsolationBookieGroups.put(BOOKIE4, BookieInfo.builder().rack("rack0").build());
        bookieMapping.put(primaryGroupName, primaryIsolationBookieGroups);
        bookieMapping.put(secondaryGroupName, secondaryIsolationBookieGroups);
        ZkUtils.createFullPathOptimistic((ZooKeeper)this.localZkc, (String)"/bookies", (byte[])this.jsonMapper.writeValueAsBytes(bookieMapping), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT);
        Awaitility.await().until(() -> this.localZkc.exists("/bookies", false) != null);
        HashMap<String, String> placementPolicyProperties = new HashMap<String, String>();
        placementPolicyProperties.put("isolationBookieGroups", primaryGroupName);
        placementPolicyProperties.put("secondaryIsolationBookieGroups", secondaryGroupName);
        EnsemblePlacementPolicyConfig policyConfig = new EnsemblePlacementPolicyConfig(ZkIsolatedBookieEnsemblePlacementPolicy.class, placementPolicyProperties);
        HashMap<String, byte[]> customMetadata = new HashMap<String, byte[]>();
        customMetadata.put("EnsemblePlacementPolicyConfig", policyConfig.encode());
        ZkIsolatedBookieEnsemblePlacementPolicy isolationPolicy = new ZkIsolatedBookieEnsemblePlacementPolicy();
        ClientConfiguration bkClientConf = new ClientConfiguration();
        bkClientConf.setProperty("zk_cache_instance", (Object)new ZooKeeperCache("test", this.localZkc, 30){});
        bkClientConf.setProperty("isolationBookieGroups", (Object)primaryGroupName);
        isolationPolicy.initialize(bkClientConf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE, BookieSocketAddress.LEGACY_BOOKIEID_RESOLVER);
        isolationPolicy.onClusterChanged(this.writableBookies, this.readOnlyBookies);
        BookieId bookie1Id = new BookieSocketAddress(BOOKIE1).toBookieId();
        BookieId bookie2Id = new BookieSocketAddress(BOOKIE2).toBookieId();
        BookieId bookie3Id = new BookieSocketAddress(BOOKIE3).toBookieId();
        BookieId bookieId = (BookieId)isolationPolicy.replaceBookie(2, 1, 1, customMetadata, Arrays.asList(bookie1Id, bookie3Id), bookie3Id, null).getResult();
        Assert.assertEquals((Object)bookieId, (Object)bookie2Id);
    }
}

