/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.offload.jcloud.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.util.Recycler;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.bookkeeper.client.api.DigestType;
import org.apache.bookkeeper.client.api.LedgerMetadata;
import org.apache.bookkeeper.mledger.offload.jcloud.OffloadIndexBlock;
import org.apache.bookkeeper.mledger.offload.jcloud.OffloadIndexBlockV2;
import org.apache.bookkeeper.mledger.offload.jcloud.OffloadIndexEntry;
import org.apache.bookkeeper.mledger.offload.jcloud.impl.OffloadIndexBlockImpl;
import org.apache.bookkeeper.mledger.offload.jcloud.impl.OffloadIndexEntryImpl;
import org.apache.bookkeeper.mledger.proto.MLDataFormats;
import org.apache.bookkeeper.net.BookieId;
import org.apache.pulsar.common.allocator.PulsarByteBufAllocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OffloadIndexBlockV2Impl
implements OffloadIndexBlockV2 {
    private static final Logger log = LoggerFactory.getLogger(OffloadIndexBlockImpl.class);
    private static final int INDEX_MAGIC_WORD = 1025487036;
    private Map<Long, MLDataFormats.ManagedLedgerInfo.LedgerInfo> segmentMetadata;
    private final Map<Long, LedgerMetadata> compatibleMetadata = Maps.newTreeMap();
    private long dataObjectLength;
    private long dataHeaderLength;
    private Map<Long, TreeMap<Long, OffloadIndexEntryImpl>> indexEntries;
    private final Recycler.Handle<OffloadIndexBlockV2Impl> recyclerHandle;
    private static final Recycler<OffloadIndexBlockV2Impl> RECYCLER = new Recycler<OffloadIndexBlockV2Impl>(){

        protected OffloadIndexBlockV2Impl newObject(Recycler.Handle<OffloadIndexBlockV2Impl> handle) {
            return new OffloadIndexBlockV2Impl(handle);
        }
    };

    private OffloadIndexBlockV2Impl(Recycler.Handle<OffloadIndexBlockV2Impl> recyclerHandle) {
        this.recyclerHandle = recyclerHandle;
    }

    public static OffloadIndexBlockV2Impl get(Map<Long, MLDataFormats.ManagedLedgerInfo.LedgerInfo> metadata, long dataObjectLength, long dataHeaderLength, Map<Long, List<OffloadIndexEntryImpl>> entries) {
        OffloadIndexBlockV2Impl block = (OffloadIndexBlockV2Impl)RECYCLER.get();
        block.indexEntries = new HashMap<Long, TreeMap<Long, OffloadIndexEntryImpl>>();
        entries.forEach((ledgerId, list) -> {
            TreeMap inLedger = block.indexEntries.getOrDefault(ledgerId, new TreeMap());
            list.forEach(indexEntry -> inLedger.put(indexEntry.getEntryId(), indexEntry));
            block.indexEntries.put((Long)ledgerId, inLedger);
        });
        block.segmentMetadata = metadata;
        block.dataObjectLength = dataObjectLength;
        block.dataHeaderLength = dataHeaderLength;
        return block;
    }

    public static OffloadIndexBlockV2Impl get(int magic, DataInputStream stream) throws IOException {
        OffloadIndexBlockV2Impl block = (OffloadIndexBlockV2Impl)RECYCLER.get();
        block.indexEntries = Maps.newTreeMap();
        block.segmentMetadata = Maps.newTreeMap();
        if (magic != 1025487036) {
            throw new IOException(String.format("Invalid MagicWord. read: 0x%x  expected: 0x%x", magic, 1025487036));
        }
        block.fromStream(stream);
        return block;
    }

    public void recycle() {
        this.dataObjectLength = -1L;
        this.dataHeaderLength = -1L;
        this.segmentMetadata = null;
        this.indexEntries.clear();
        this.indexEntries = null;
        if (this.recyclerHandle != null) {
            this.recyclerHandle.recycle((Object)this);
        }
    }

    @Override
    public OffloadIndexEntry getIndexEntryForEntry(long ledgerId, long messageEntryId) throws IOException {
        if (messageEntryId > this.getLedgerMetadata(ledgerId).getLastEntryId()) {
            log.warn("Try to get entry: {}, which beyond lastEntryId {}, return null", (Object)messageEntryId, (Object)this.getLedgerMetadata(ledgerId).getLastEntryId());
            throw new IndexOutOfBoundsException("Entry index: " + messageEntryId + " beyond lastEntryId: " + this.getLedgerMetadata(ledgerId).getLastEntryId());
        }
        return this.indexEntries.get(ledgerId).floorEntry(messageEntryId).getValue();
    }

    @Override
    public long getStartEntryId(long ledgerId) {
        return this.indexEntries.get(ledgerId).firstEntry().getValue().getEntryId();
    }

    @Override
    public int getEntryCount() {
        int ans = 0;
        for (TreeMap<Long, OffloadIndexEntryImpl> v : this.indexEntries.values()) {
            ans += v.size();
        }
        return ans;
    }

    @Override
    public LedgerMetadata getLedgerMetadata(long ledgerId) {
        if (this.compatibleMetadata.containsKey(ledgerId)) {
            return this.compatibleMetadata.get(ledgerId);
        }
        if (this.segmentMetadata.containsKey(ledgerId)) {
            CompatibleMetadata result = new CompatibleMetadata(this.segmentMetadata.get(ledgerId));
            this.compatibleMetadata.put(ledgerId, result);
            return result;
        }
        return null;
    }

    @Override
    public long getDataObjectLength() {
        return this.dataObjectLength;
    }

    @Override
    public long getDataBlockHeaderLength() {
        return this.dataHeaderLength;
    }

    @Override
    public OffloadIndexBlock.IndexInputStream toStream() throws IOException {
        int indexBlockLength = 24;
        HashMap<Long, byte[]> metaBytesMap = new HashMap<Long, byte[]>();
        for (Map.Entry<Long, TreeMap<Long, OffloadIndexEntryImpl>> e : this.indexEntries.entrySet()) {
            Long ledgerId = e.getKey();
            TreeMap<Long, OffloadIndexEntryImpl> ledgerIndexEntries = e.getValue();
            int indexEntryCount = ledgerIndexEntries.size();
            byte[] ledgerMetadataByte = this.segmentMetadata.get(ledgerId).toByteArray();
            int segmentMetadataLength = ledgerMetadataByte.length;
            indexBlockLength += 16 + segmentMetadataLength + indexEntryCount * 20;
            metaBytesMap.put(ledgerId, ledgerMetadataByte);
        }
        ByteBuf out = PulsarByteBufAllocator.DEFAULT.buffer(indexBlockLength, indexBlockLength);
        out.writeInt(1025487036).writeInt(indexBlockLength).writeLong(this.dataObjectLength).writeLong(this.dataHeaderLength);
        for (Map.Entry<Long, TreeMap<Long, OffloadIndexEntryImpl>> e : this.indexEntries.entrySet()) {
            Long ledgerId = e.getKey();
            TreeMap<Long, OffloadIndexEntryImpl> ledgerIndexEntries = e.getValue();
            int indexEntryCount = ledgerIndexEntries.size();
            byte[] ledgerMetadataByte = (byte[])metaBytesMap.get(ledgerId);
            out.writeLong(ledgerId.longValue()).writeInt(indexEntryCount).writeInt(ledgerMetadataByte.length).writeBytes(ledgerMetadataByte);
            ledgerIndexEntries.values().forEach(idxEntry -> out.writeLong(idxEntry.getEntryId()).writeInt(idxEntry.getPartId()).writeLong(idxEntry.getOffset()));
        }
        return new OffloadIndexBlock.IndexInputStream((InputStream)new ByteBufInputStream(out, true), indexBlockLength);
    }

    private static MLDataFormats.ManagedLedgerInfo.LedgerInfo parseLedgerInfo(byte[] bytes) throws IOException {
        return ((MLDataFormats.ManagedLedgerInfo.LedgerInfo.Builder)MLDataFormats.ManagedLedgerInfo.LedgerInfo.newBuilder().mergeFrom(bytes)).build();
    }

    private OffloadIndexBlockV2 fromStream(DataInputStream dis) throws IOException {
        dis.readInt();
        this.dataObjectLength = dis.readLong();
        this.dataHeaderLength = dis.readLong();
        while (dis.available() > 0) {
            byte[] metadataBytes;
            long ledgerId = dis.readLong();
            int indexEntryCount = dis.readInt();
            int segmentMetadataLength = dis.readInt();
            if (segmentMetadataLength != dis.read(metadataBytes = new byte[segmentMetadataLength])) {
                log.error("Read ledgerMetadata from bytes failed");
                throw new IOException("Read ledgerMetadata from bytes failed");
            }
            MLDataFormats.ManagedLedgerInfo.LedgerInfo ledgerInfo = OffloadIndexBlockV2Impl.parseLedgerInfo(metadataBytes);
            this.segmentMetadata.put(ledgerId, ledgerInfo);
            TreeMap<Long, OffloadIndexEntryImpl> indexEntries = new TreeMap<Long, OffloadIndexEntryImpl>();
            for (int i = 0; i < indexEntryCount; ++i) {
                long entryId = dis.readLong();
                indexEntries.putIfAbsent(entryId, OffloadIndexEntryImpl.of(entryId, dis.readInt(), dis.readLong(), this.dataHeaderLength));
            }
            this.indexEntries.put(ledgerId, indexEntries);
        }
        return this;
    }

    public static int getIndexMagicWord() {
        return 1025487036;
    }

    @Override
    public void close() {
        this.recycle();
    }

    @VisibleForTesting
    static class CompatibleMetadata
    implements LedgerMetadata {
        MLDataFormats.ManagedLedgerInfo.LedgerInfo ledgerInfo;

        public CompatibleMetadata(MLDataFormats.ManagedLedgerInfo.LedgerInfo ledgerInfo) {
            this.ledgerInfo = ledgerInfo;
        }

        public long getLedgerId() {
            return this.ledgerInfo.getLedgerId();
        }

        public int getEnsembleSize() {
            return 0;
        }

        public int getWriteQuorumSize() {
            return 0;
        }

        public int getAckQuorumSize() {
            return 0;
        }

        public long getLastEntryId() {
            return this.ledgerInfo.getEntries() - 1L;
        }

        public long getLength() {
            return this.ledgerInfo.getSize();
        }

        public boolean hasPassword() {
            return false;
        }

        public byte[] getPassword() {
            return new byte[0];
        }

        public DigestType getDigestType() {
            return null;
        }

        public long getCtime() {
            return 0L;
        }

        public boolean isClosed() {
            return true;
        }

        public Map<String, byte[]> getCustomMetadata() {
            return null;
        }

        public List<BookieId> getEnsembleAt(long entryId) {
            return null;
        }

        public NavigableMap<Long, ? extends List<BookieId>> getAllEnsembles() {
            return null;
        }

        public LedgerMetadata.State getState() {
            return null;
        }

        public String toSafeString() {
            return null;
        }

        public int getMetadataFormatVersion() {
            return 0;
        }

        public long getCToken() {
            return 0L;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CompatibleMetadata that = (CompatibleMetadata)o;
            return this.ledgerInfo.equals((Object)that.ledgerInfo);
        }

        public int hashCode() {
            return Objects.hash(this.ledgerInfo);
        }
    }
}

