/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.offload.jcloud.provider;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.bookkeeper.mledger.offload.jcloud.provider.BlobStoreLocation;
import org.apache.bookkeeper.mledger.offload.jcloud.provider.JCloudBlobStoreProvider;
import org.apache.commons.lang3.StringUtils;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.aws.s3.AWSS3ProviderMetadata;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.domain.Credentials;
import org.jclouds.googlecloudstorage.GoogleCloudStorageProviderMetadata;
import org.jclouds.osgi.ApiRegistry;
import org.jclouds.osgi.ProviderRegistry;
import org.jclouds.providers.ProviderMetadata;
import org.jclouds.s3.S3ApiMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TieredStorageConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TieredStorageConfiguration.class);
    private static final long serialVersionUID = 1L;
    public static final String BLOB_STORE_PROVIDER_KEY = "managedLedgerOffloadDriver";
    public static final String METADATA_FIELD_BUCKET = "bucket";
    public static final String METADATA_FIELD_REGION = "region";
    public static final String METADATA_FIELD_ENDPOINT = "serviceEndpoint";
    public static final String METADATA_FIELD_MAX_BLOCK_SIZE = "maxBlockSizeInBytes";
    public static final String METADATA_FIELD_MIN_BLOCK_SIZE = "minBlockSizeInBytes";
    public static final String METADATA_FIELD_READ_BUFFER_SIZE = "readBufferSizeInBytes";
    public static final String METADATA_FIELD_WRITE_BUFFER_SIZE = "writeBufferSizeInBytes";
    public static final String OFFLOADER_PROPERTY_PREFIX = "managedLedgerOffload";
    public static final String MAX_OFFLOAD_SEGMENT_ROLLOVER_TIME_SEC = "maxOffloadSegmentRolloverTimeInSeconds";
    public static final String MIN_OFFLOAD_SEGMENT_ROLLOVER_TIME_SEC = "minOffloadSegmentRolloverTimeInSeconds";
    public static final long DEFAULT_MAX_SEGMENT_TIME_IN_SECOND = 600L;
    public static final long DEFAULT_MIN_SEGMENT_TIME_IN_SECOND = 0L;
    public static final String MAX_OFFLOAD_SEGMENT_SIZE_IN_BYTES = "maxOffloadSegmentSizeInBytes";
    public static final long DEFAULT_MAX_SEGMENT_SIZE_IN_BYTES = 0x40000000L;
    protected static final int MB = 0x100000;
    public static final String GCS_ACCOUNT_KEY_FILE_FIELD = "gcsManagedLedgerOffloadServiceAccountKeyFile";
    public static final String S3_ID_FIELD = "s3ManagedLedgerOffloadCredentialId";
    public static final String S3_SECRET_FIELD = "s3ManagedLedgerOffloadCredentialSecret";
    public static final String S3_ROLE_FIELD = "s3ManagedLedgerOffloadRole";
    public static final String S3_ROLE_SESSION_NAME_FIELD = "s3ManagedLedgerOffloadRoleSessionName";
    private final Map<String, String> configProperties;
    private Supplier<Credentials> credentials;
    private JCloudBlobStoreProvider provider;

    public static TieredStorageConfiguration create(Properties props) throws IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.putAll(props.entrySet().stream().collect(Collectors.toMap(e -> e.getKey().toString(), e -> e.getValue().toString())));
        return new TieredStorageConfiguration(map);
    }

    public static TieredStorageConfiguration create(Map<String, String> props) {
        return new TieredStorageConfiguration(props);
    }

    public TieredStorageConfiguration(Map<String, String> configProperties) {
        if (configProperties == null) {
            throw new IllegalArgumentException("configProperties cannot be null");
        }
        this.configProperties = configProperties;
    }

    public List<String> getKeys(String property) {
        String key;
        ArrayList<String> keys = new ArrayList<String>();
        String bc = this.getBackwardCompatibleKey(property);
        if (StringUtils.isNotBlank((CharSequence)bc)) {
            keys.add(bc);
        }
        if (StringUtils.isNotBlank((CharSequence)(key = this.getKeyName(property)))) {
            keys.add(key);
        }
        return keys;
    }

    private String getKeyName(String property) {
        StringBuilder sb = new StringBuilder();
        sb.append(OFFLOADER_PROPERTY_PREFIX).append(StringUtils.capitalize((String)property));
        return sb.toString();
    }

    private String getBackwardCompatibleKey(String property) {
        switch (this.getProvider()) {
            case AWS_S3: {
                return "s3ManagedLedgerOffload" + StringUtils.capitalize((String)property);
            }
            case GOOGLE_CLOUD_STORAGE: {
                return "gcsManagedLedgerOffload" + StringUtils.capitalize((String)property);
            }
        }
        return null;
    }

    public String getBlobStoreProviderKey() {
        return this.configProperties.getOrDefault(BLOB_STORE_PROVIDER_KEY, JCloudBlobStoreProvider.AWS_S3.getDriver());
    }

    public String getDriver() {
        return this.getProvider().getDriver();
    }

    public String getRegion() {
        for (String key : this.getKeys(METADATA_FIELD_REGION)) {
            if (!this.configProperties.containsKey(key)) continue;
            return this.configProperties.get(key);
        }
        return null;
    }

    public void setRegion(String s) {
        this.configProperties.put(this.getKeyName(METADATA_FIELD_REGION), s);
    }

    public String getBucket() {
        for (String key : this.getKeys(METADATA_FIELD_BUCKET)) {
            if (!this.configProperties.containsKey(key)) continue;
            return this.configProperties.get(key);
        }
        return null;
    }

    public String getServiceEndpoint() {
        for (String key : this.getKeys(METADATA_FIELD_ENDPOINT)) {
            if (!this.configProperties.containsKey(key)) continue;
            return this.configProperties.get(key);
        }
        return null;
    }

    public long getMaxSegmentTimeInSecond() {
        if (this.configProperties.containsKey(MAX_OFFLOAD_SEGMENT_ROLLOVER_TIME_SEC)) {
            return Long.parseLong(this.configProperties.get(MAX_OFFLOAD_SEGMENT_ROLLOVER_TIME_SEC));
        }
        return 600L;
    }

    public long getMinSegmentTimeInSecond() {
        if (this.configProperties.containsKey(MIN_OFFLOAD_SEGMENT_ROLLOVER_TIME_SEC)) {
            return Long.parseLong(this.configProperties.get(MIN_OFFLOAD_SEGMENT_ROLLOVER_TIME_SEC));
        }
        return 0L;
    }

    public long getMaxSegmentSizeInBytes() {
        if (this.configProperties.containsKey(MAX_OFFLOAD_SEGMENT_SIZE_IN_BYTES)) {
            return Long.parseLong(this.configProperties.get(MAX_OFFLOAD_SEGMENT_SIZE_IN_BYTES));
        }
        return 0x40000000L;
    }

    public void setServiceEndpoint(String s) {
        this.configProperties.put(this.getKeyName(METADATA_FIELD_ENDPOINT), s);
    }

    public String getConfigProperty(String propertyName) {
        return this.configProperties.get(propertyName);
    }

    public JCloudBlobStoreProvider getProvider() {
        if (this.provider == null) {
            this.provider = JCloudBlobStoreProvider.getProvider(this.getBlobStoreProviderKey());
        }
        return this.provider;
    }

    public void setProvider(JCloudBlobStoreProvider provider) {
        this.provider = provider;
    }

    public Integer getMaxBlockSizeInBytes() {
        for (String key : this.getKeys(METADATA_FIELD_MAX_BLOCK_SIZE)) {
            if (!this.configProperties.containsKey(key)) continue;
            return Integer.valueOf(this.configProperties.get(key));
        }
        return 0x4000000;
    }

    public Integer getMinBlockSizeInBytes() {
        for (String key : this.getKeys(METADATA_FIELD_MIN_BLOCK_SIZE)) {
            if (!this.configProperties.containsKey(key)) continue;
            return Integer.valueOf(this.configProperties.get(key));
        }
        return 0x500000;
    }

    public Integer getReadBufferSizeInBytes() {
        for (String key : this.getKeys(METADATA_FIELD_READ_BUFFER_SIZE)) {
            if (!this.configProperties.containsKey(key)) continue;
            return Integer.valueOf(this.configProperties.get(key));
        }
        return 0x100000;
    }

    public Integer getWriteBufferSizeInBytes() {
        for (String key : this.getKeys(METADATA_FIELD_WRITE_BUFFER_SIZE)) {
            if (!this.configProperties.containsKey(key)) continue;
            return Integer.valueOf(this.configProperties.get(key));
        }
        return 0xA00000;
    }

    public Supplier<Credentials> getProviderCredentials() {
        if (this.credentials == null) {
            this.getProvider().buildCredentials(this);
        }
        return this.credentials;
    }

    public void setProviderCredentials(Supplier<Credentials> credentials) {
        this.credentials = credentials;
    }

    public void validate() {
        this.getProvider().validate(this);
    }

    public ProviderMetadata getProviderMetadata() {
        return this.getProvider().getProviderMetadata();
    }

    public BlobStoreLocation getBlobStoreLocation() {
        return new BlobStoreLocation(this.getOffloadDriverMetadata());
    }

    public BlobStore getBlobStore() {
        return this.getProvider().getBlobStore(this);
    }

    public Map<String, String> getOffloadDriverMetadata() {
        return ImmutableMap.of((Object)BLOB_STORE_PROVIDER_KEY, (Object)(this.getProvider() != null ? this.getProvider().toString() : ""), (Object)METADATA_FIELD_BUCKET, (Object)(this.getBucket() != null ? this.getBucket() : ""), (Object)METADATA_FIELD_REGION, (Object)(this.getRegion() != null ? this.getRegion() : ""), (Object)METADATA_FIELD_ENDPOINT, (Object)(this.getServiceEndpoint() != null ? this.getServiceEndpoint() : ""));
    }

    protected Properties getOverrides() {
        Properties overrides = new Properties();
        overrides.setProperty("jclouds.mpu.parallel.degree", "1");
        overrides.setProperty("jclouds.mpu.parts.size", Integer.toString(this.getMaxBlockSizeInBytes()));
        overrides.setProperty("jclouds.so-timeout", "25000");
        overrides.setProperty("jclouds.max-retries", Integer.toString(100));
        if (this.getDriver().equalsIgnoreCase(JCloudBlobStoreProvider.AWS_S3.getDriver())) {
            ApiRegistry.registerApi((ApiMetadata)new S3ApiMetadata());
            ProviderRegistry.registerProvider((ProviderMetadata)new AWSS3ProviderMetadata());
        } else if (this.getDriver().equalsIgnoreCase(JCloudBlobStoreProvider.GOOGLE_CLOUD_STORAGE.getDriver())) {
            ProviderRegistry.registerProvider((ProviderMetadata)new GoogleCloudStorageProviderMetadata());
        }
        if (StringUtils.isNotEmpty((CharSequence)this.getServiceEndpoint())) {
            overrides.setProperty("jclouds.s3.virtual-host-buckets", "false");
        }
        System.getProperties().entrySet().stream().filter(p -> p.getKey().toString().startsWith("jclouds")).forEach(jcloudsProp -> overrides.setProperty(jcloudsProp.getKey().toString(), jcloudsProp.getValue().toString()));
        System.getenv().entrySet().stream().filter(p -> ((String)p.getKey()).toString().startsWith("jclouds")).forEach(jcloudsProp -> overrides.setProperty(((String)jcloudsProp.getKey()).toString(), ((String)jcloudsProp.getValue()).toString()));
        log.info("getOverrides: {}", (Object)overrides.toString());
        return overrides;
    }

    @Generated
    public Map<String, String> getConfigProperties() {
        return this.configProperties;
    }

    @Generated
    public Supplier<Credentials> getCredentials() {
        return this.credentials;
    }

    public static interface BlobStoreBuilder {
        public BlobStore getBlobStore(TieredStorageConfiguration var1);
    }

    public static interface CredentialBuilder {
        public void buildCredentials(TieredStorageConfiguration var1);
    }

    public static interface ConfigValidation {
        public void validate(TieredStorageConfiguration var1) throws IllegalArgumentException;
    }
}

