/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.engine.impl;

import java.util.EnumSet;
import java.util.Map;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.transport.ReceiverSettleMode;
import org.apache.qpid.proton.amqp.transport.SenderSettleMode;
import org.apache.qpid.proton.amqp.transport.Source;
import org.apache.qpid.proton.amqp.transport.Target;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.Event;
import org.apache.qpid.proton.engine.Link;
import org.apache.qpid.proton.engine.impl.ConnectionImpl;
import org.apache.qpid.proton.engine.impl.DeliveryImpl;
import org.apache.qpid.proton.engine.impl.EndpointImpl;
import org.apache.qpid.proton.engine.impl.EndpointImplQuery;
import org.apache.qpid.proton.engine.impl.LinkNode;
import org.apache.qpid.proton.engine.impl.SenderImpl;
import org.apache.qpid.proton.engine.impl.SessionImpl;
import org.apache.qpid.proton.engine.impl.TransportLink;

public abstract class LinkImpl
extends EndpointImpl
implements Link {
    private final SessionImpl _session;
    DeliveryImpl _head;
    DeliveryImpl _tail;
    DeliveryImpl _current;
    private String _name;
    private Source _source;
    private Source _remoteSource;
    private Target _target;
    private Target _remoteTarget;
    private int _queued;
    private int _credit;
    private int _unsettled;
    private int _drained;
    private SenderSettleMode _senderSettleMode;
    private SenderSettleMode _remoteSenderSettleMode;
    private ReceiverSettleMode _receiverSettleMode;
    private ReceiverSettleMode _remoteReceiverSettleMode;
    private LinkNode<LinkImpl> _node;
    private boolean _drain;
    private boolean _detached;
    private Map<Symbol, Object> _properties;
    private Map<Symbol, Object> _remoteProperties;
    private Symbol[] _offeredCapabilities;
    private Symbol[] _remoteOfferedCapabilities;
    private Symbol[] _desiredCapabilities;
    private Symbol[] _remoteDesiredCapabilities;

    LinkImpl(SessionImpl session, String name) {
        this._session = session;
        this._session.incref();
        this._name = name;
        ConnectionImpl conn = session.getConnectionImpl();
        this._node = conn.addLinkEndpoint(this);
        conn.put(Event.Type.LINK_INIT, this);
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public DeliveryImpl delivery(byte[] tag) {
        return this.delivery(tag, 0, tag.length);
    }

    @Override
    public DeliveryImpl delivery(byte[] tag, int offset, int length) {
        if (offset != 0 || length != tag.length) {
            throw new IllegalArgumentException("At present delivery tag must be the whole byte array");
        }
        this.incrementQueued();
        try {
            DeliveryImpl delivery = new DeliveryImpl(tag, this, this._tail);
            if (this._tail == null) {
                this._head = delivery;
            }
            this._tail = delivery;
            if (this._current == null) {
                this._current = delivery;
            }
            this.getConnectionImpl().workUpdate(delivery);
            return delivery;
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    void postFinal() {
        this._session.getConnectionImpl().put(Event.Type.LINK_FINAL, this);
        this._session.decref();
    }

    @Override
    void doFree() {
        DeliveryImpl dlv = this._head;
        while (dlv != null) {
            DeliveryImpl next = dlv.next();
            dlv.free();
            dlv = next;
        }
        this._session.getConnectionImpl().removeLinkEndpoint(this._node);
        this._node = null;
    }

    void modifyEndpoints() {
        this.modified();
    }

    void remove(DeliveryImpl delivery) {
        if (this._head == delivery) {
            this._head = delivery.getLinkNext();
        }
        if (this._tail == delivery) {
            this._tail = delivery.getLinkPrevious();
        }
    }

    @Override
    public DeliveryImpl current() {
        return this._current;
    }

    @Override
    public boolean advance() {
        if (this._current != null) {
            DeliveryImpl oldCurrent = this._current;
            this._current = this._current.getLinkNext();
            this.getConnectionImpl().workUpdate(oldCurrent);
            if (this._current != null) {
                this.getConnectionImpl().workUpdate(this._current);
            }
            return true;
        }
        return false;
    }

    @Override
    protected ConnectionImpl getConnectionImpl() {
        return this._session.getConnectionImpl();
    }

    @Override
    public SessionImpl getSession() {
        return this._session;
    }

    @Override
    public Source getRemoteSource() {
        return this._remoteSource;
    }

    void setRemoteSource(Source source) {
        this._remoteSource = source;
    }

    @Override
    public Target getRemoteTarget() {
        return this._remoteTarget;
    }

    void setRemoteTarget(Target target) {
        this._remoteTarget = target;
    }

    @Override
    public Source getSource() {
        return this._source;
    }

    @Override
    public void setSource(Source source) {
        this._source = source;
    }

    @Override
    public Target getTarget() {
        return this._target;
    }

    @Override
    public void setTarget(Target target) {
        this._target = target;
    }

    @Override
    public Link next(EnumSet<EndpointState> local, EnumSet<EndpointState> remote) {
        EndpointImplQuery query = new EndpointImplQuery(local, remote);
        LinkNode<LinkImpl> linkNode = this._node.next(query);
        return linkNode == null ? null : linkNode.getValue();
    }

    abstract TransportLink getTransportLink();

    @Override
    public int getCredit() {
        return this._credit;
    }

    public void addCredit(int credit) {
        this._credit += credit;
    }

    public void setCredit(int credit) {
        this._credit = credit;
    }

    boolean hasCredit() {
        return this._credit > 0;
    }

    void incrementCredit() {
        ++this._credit;
    }

    void decrementCredit() {
        --this._credit;
    }

    @Override
    public int getQueued() {
        return this._queued;
    }

    void incrementQueued() {
        ++this._queued;
    }

    void decrementQueued() {
        --this._queued;
    }

    @Override
    public int getUnsettled() {
        return this._unsettled;
    }

    void incrementUnsettled() {
        ++this._unsettled;
    }

    void decrementUnsettled() {
        --this._unsettled;
    }

    void setDrain(boolean drain) {
        this._drain = drain;
    }

    @Override
    public boolean getDrain() {
        return this._drain;
    }

    @Override
    public SenderSettleMode getSenderSettleMode() {
        return this._senderSettleMode;
    }

    @Override
    public void setSenderSettleMode(SenderSettleMode senderSettleMode) {
        this._senderSettleMode = senderSettleMode;
    }

    @Override
    public SenderSettleMode getRemoteSenderSettleMode() {
        return this._remoteSenderSettleMode;
    }

    @Override
    public void setRemoteSenderSettleMode(SenderSettleMode remoteSenderSettleMode) {
        this._remoteSenderSettleMode = remoteSenderSettleMode;
    }

    @Override
    public ReceiverSettleMode getReceiverSettleMode() {
        return this._receiverSettleMode;
    }

    @Override
    public void setReceiverSettleMode(ReceiverSettleMode receiverSettleMode) {
        this._receiverSettleMode = receiverSettleMode;
    }

    @Override
    public ReceiverSettleMode getRemoteReceiverSettleMode() {
        return this._remoteReceiverSettleMode;
    }

    void setRemoteReceiverSettleMode(ReceiverSettleMode remoteReceiverSettleMode) {
        this._remoteReceiverSettleMode = remoteReceiverSettleMode;
    }

    @Override
    public Map<Symbol, Object> getProperties() {
        return this._properties;
    }

    @Override
    public void setProperties(Map<Symbol, Object> properties) {
        this._properties = properties;
    }

    @Override
    public Map<Symbol, Object> getRemoteProperties() {
        return this._remoteProperties;
    }

    void setRemoteProperties(Map<Symbol, Object> remoteProperties) {
        this._remoteProperties = remoteProperties;
    }

    @Override
    public Symbol[] getDesiredCapabilities() {
        return this._desiredCapabilities;
    }

    @Override
    public void setDesiredCapabilities(Symbol[] desiredCapabilities) {
        this._desiredCapabilities = desiredCapabilities;
    }

    @Override
    public Symbol[] getRemoteDesiredCapabilities() {
        return this._remoteDesiredCapabilities;
    }

    void setRemoteDesiredCapabilities(Symbol[] remoteDesiredCapabilities) {
        this._remoteDesiredCapabilities = remoteDesiredCapabilities;
    }

    @Override
    public Symbol[] getOfferedCapabilities() {
        return this._offeredCapabilities;
    }

    @Override
    public void setOfferedCapabilities(Symbol[] offeredCapabilities) {
        this._offeredCapabilities = offeredCapabilities;
    }

    @Override
    public Symbol[] getRemoteOfferedCapabilities() {
        return this._remoteOfferedCapabilities;
    }

    void setRemoteOfferedCapabilities(Symbol[] remoteOfferedCapabilities) {
        this._remoteOfferedCapabilities = remoteOfferedCapabilities;
    }

    @Override
    public int drained() {
        int drained = 0;
        if (this instanceof SenderImpl) {
            if (this.getDrain() && this.hasCredit()) {
                this._drained = this.getCredit();
                this.setCredit(0);
                this.modified();
                drained = this._drained;
            }
        } else {
            drained = this._drained;
            this._drained = 0;
        }
        return drained;
    }

    int getDrained() {
        return this._drained;
    }

    void setDrained(int value) {
        this._drained = value;
    }

    @Override
    public DeliveryImpl head() {
        return this._head;
    }

    @Override
    void localOpen() {
        this.getConnectionImpl().put(Event.Type.LINK_LOCAL_OPEN, this);
    }

    @Override
    void localClose() {
        this.getConnectionImpl().put(Event.Type.LINK_LOCAL_CLOSE, this);
    }

    @Override
    public void detach() {
        this._detached = true;
        this.getConnectionImpl().put(Event.Type.LINK_LOCAL_DETACH, this);
        this.modified();
    }

    @Override
    public boolean detached() {
        return this._detached;
    }
}

