/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.codec;

import java.util.Arrays;
import java.util.Collection;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.codec.AbstractPrimitiveType;
import org.apache.qpid.proton.codec.DecoderImpl;
import org.apache.qpid.proton.codec.EncoderImpl;
import org.apache.qpid.proton.codec.LargeFloatingSizePrimitiveTypeEncoding;
import org.apache.qpid.proton.codec.PrimitiveTypeEncoding;
import org.apache.qpid.proton.codec.ReadableBuffer;
import org.apache.qpid.proton.codec.SmallFloatingSizePrimitiveTypeEncoding;
import org.apache.qpid.proton.codec.TypeEncoding;

public class BinaryType
extends AbstractPrimitiveType<Binary> {
    private final BinaryEncoding _binaryEncoding;
    private final BinaryEncoding _shortBinaryEncoding;

    BinaryType(EncoderImpl encoder, DecoderImpl decoder) {
        this._binaryEncoding = new LongBinaryEncoding(encoder, decoder);
        this._shortBinaryEncoding = new ShortBinaryEncoding(encoder, decoder);
        encoder.register(Binary.class, this);
        decoder.register(this);
    }

    @Override
    public Class<Binary> getTypeClass() {
        return Binary.class;
    }

    public BinaryEncoding getEncoding(Binary val) {
        return val.getLength() <= 255 ? this._shortBinaryEncoding : this._binaryEncoding;
    }

    @Override
    public BinaryEncoding getCanonicalEncoding() {
        return this._binaryEncoding;
    }

    @Override
    public Collection<BinaryEncoding> getAllEncodings() {
        return Arrays.asList(this._shortBinaryEncoding, this._binaryEncoding);
    }

    public void fastWrite(EncoderImpl encoder, Binary binary) {
        if (binary.getLength() <= 255) {
            encoder.writeRaw((byte)-96);
            encoder.writeRaw((byte)binary.getLength());
            encoder.writeRaw(binary.getArray(), binary.getArrayOffset(), binary.getLength());
        } else {
            encoder.writeRaw((byte)-80);
            encoder.writeRaw(binary.getLength());
            encoder.writeRaw(binary.getArray(), binary.getArrayOffset(), binary.getLength());
        }
    }

    private class ShortBinaryEncoding
    extends SmallFloatingSizePrimitiveTypeEncoding<Binary>
    implements BinaryEncoding {
        public ShortBinaryEncoding(EncoderImpl encoder, DecoderImpl decoder) {
            super(encoder, decoder);
        }

        @Override
        protected void writeEncodedValue(Binary val) {
            this.getEncoder().writeRaw(val.getArray(), val.getArrayOffset(), val.getLength());
        }

        @Override
        protected int getEncodedValueSize(Binary val) {
            return val.getLength();
        }

        @Override
        public byte getEncodingCode() {
            return -96;
        }

        @Override
        public BinaryType getType() {
            return BinaryType.this;
        }

        @Override
        public boolean encodesSuperset(TypeEncoding<Binary> encoder) {
            return encoder == this;
        }

        @Override
        public Binary readValue() {
            int size = this.getDecoder().readRawByte() & 0xFF;
            byte[] data = new byte[size];
            this.getDecoder().readRaw(data, 0, size);
            return new Binary(data);
        }

        @Override
        public void skipValue() {
            DecoderImpl decoder = this.getDecoder();
            ReadableBuffer buffer = decoder.getBuffer();
            int size = this.getDecoder().readRawByte() & 0xFF;
            buffer.position(buffer.position() + size);
        }
    }

    private class LongBinaryEncoding
    extends LargeFloatingSizePrimitiveTypeEncoding<Binary>
    implements BinaryEncoding {
        public LongBinaryEncoding(EncoderImpl encoder, DecoderImpl decoder) {
            super(encoder, decoder);
        }

        @Override
        protected void writeEncodedValue(Binary val) {
            this.getEncoder().writeRaw(val.getArray(), val.getArrayOffset(), val.getLength());
        }

        @Override
        protected int getEncodedValueSize(Binary val) {
            return val.getLength();
        }

        @Override
        public byte getEncodingCode() {
            return -80;
        }

        @Override
        public BinaryType getType() {
            return BinaryType.this;
        }

        @Override
        public boolean encodesSuperset(TypeEncoding<Binary> encoding) {
            return this.getType() == encoding.getType();
        }

        @Override
        public Binary readValue() {
            DecoderImpl decoder = this.getDecoder();
            int size = decoder.readRawInt();
            if (size > decoder.getByteBufferRemaining()) {
                throw new IllegalArgumentException("Binary data size " + size + " is specified to be greater than the amount of data available (" + decoder.getByteBufferRemaining() + ")");
            }
            byte[] data = new byte[size];
            decoder.readRaw(data, 0, size);
            return new Binary(data);
        }

        @Override
        public void skipValue() {
            DecoderImpl decoder = this.getDecoder();
            ReadableBuffer buffer = decoder.getBuffer();
            int size = decoder.readRawInt();
            buffer.position(buffer.position() + size);
        }
    }

    private static interface BinaryEncoding
    extends PrimitiveTypeEncoding<Binary> {
    }
}

