/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.codec.messaging;

import java.util.Collection;
import java.util.LinkedHashMap;
import org.apache.qpid.proton.ProtonException;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.UnsignedLong;
import org.apache.qpid.proton.amqp.messaging.MessageAnnotations;
import org.apache.qpid.proton.codec.AMQPType;
import org.apache.qpid.proton.codec.ArrayType;
import org.apache.qpid.proton.codec.DecodeException;
import org.apache.qpid.proton.codec.Decoder;
import org.apache.qpid.proton.codec.DecoderImpl;
import org.apache.qpid.proton.codec.EncoderImpl;
import org.apache.qpid.proton.codec.FastPathDescribedTypeConstructor;
import org.apache.qpid.proton.codec.MapType;
import org.apache.qpid.proton.codec.PrimitiveTypeEncoding;
import org.apache.qpid.proton.codec.ReadableBuffer;
import org.apache.qpid.proton.codec.SymbolType;
import org.apache.qpid.proton.codec.TypeConstructor;
import org.apache.qpid.proton.codec.TypeEncoding;
import org.apache.qpid.proton.codec.WritableBuffer;
import org.apache.qpid.proton.codec.messaging.MessageAnnotationsType;

public class FastPathMessageAnnotationsType
implements AMQPType<MessageAnnotations>,
FastPathDescribedTypeConstructor<MessageAnnotations> {
    private static final byte DESCRIPTOR_CODE = 114;
    private static final Object[] DESCRIPTORS = new Object[]{UnsignedLong.valueOf(114L), Symbol.valueOf("amqp:message-annotations:map")};
    private final MessageAnnotationsType annotationsType;
    private final SymbolType symbolType;

    public FastPathMessageAnnotationsType(EncoderImpl encoder) {
        this.annotationsType = new MessageAnnotationsType(encoder);
        this.symbolType = (SymbolType)encoder.getTypeFromClass(Symbol.class);
    }

    public EncoderImpl getEncoder() {
        return this.annotationsType.getEncoder();
    }

    public DecoderImpl getDecoder() {
        return this.annotationsType.getDecoder();
    }

    @Override
    public boolean encodesJavaPrimitive() {
        return false;
    }

    @Override
    public Class<MessageAnnotations> getTypeClass() {
        return MessageAnnotations.class;
    }

    @Override
    public TypeEncoding<MessageAnnotations> getEncoding(MessageAnnotations val) {
        return this.annotationsType.getEncoding(val);
    }

    @Override
    public TypeEncoding<MessageAnnotations> getCanonicalEncoding() {
        return this.annotationsType.getCanonicalEncoding();
    }

    @Override
    public Collection<? extends TypeEncoding<MessageAnnotations>> getAllEncodings() {
        return this.annotationsType.getAllEncodings();
    }

    @Override
    public MessageAnnotations readValue() {
        int count;
        DecoderImpl decoder = this.getDecoder();
        ReadableBuffer buffer = decoder.getBuffer();
        byte encodingCode = buffer.get();
        switch (encodingCode) {
            case -63: {
                int size = buffer.get() & 0xFF;
                count = buffer.get() & 0xFF;
                break;
            }
            case -47: {
                int size = buffer.getInt();
                count = buffer.getInt();
                break;
            }
            case 64: {
                return new MessageAnnotations(null);
            }
            default: {
                throw new ProtonException("Expected Map type but found encoding: " + encodingCode);
            }
        }
        if (count > buffer.remaining()) {
            throw new IllegalArgumentException("Map element count " + count + " is specified to be greater than the amount of data available (" + decoder.getByteBufferRemaining() + ")");
        }
        TypeConstructor<?> valueConstructor = null;
        LinkedHashMap<Symbol, Object> map = new LinkedHashMap<Symbol, Object>(count);
        for (int i = 0; i < count / 2; ++i) {
            Symbol key = decoder.readSymbol(null);
            if (key == null) {
                throw new DecodeException("String key in DeliveryAnnotations cannot be null");
            }
            boolean arrayType = false;
            byte code = buffer.get(buffer.position());
            switch (code) {
                case -32: 
                case -16: {
                    arrayType = true;
                }
            }
            valueConstructor = FastPathMessageAnnotationsType.findNextDecoder(decoder, buffer, valueConstructor);
            Object value = arrayType ? ((ArrayType.ArrayEncoding)valueConstructor).readValueArray() : valueConstructor.readValue();
            map.put(key, value);
        }
        return new MessageAnnotations(map);
    }

    @Override
    public void skipValue() {
        this.getDecoder().readConstructor().skipValue();
    }

    @Override
    public void write(MessageAnnotations val) {
        WritableBuffer buffer = this.getEncoder().getBuffer();
        buffer.put((byte)0);
        buffer.put((byte)83);
        buffer.put((byte)114);
        MapType mapType = (MapType)this.getEncoder().getType(val.getValue());
        mapType.setKeyEncoding(this.symbolType);
        mapType.write(val.getValue());
        mapType.setKeyEncoding(null);
    }

    public static void register(Decoder decoder, EncoderImpl encoder) {
        FastPathMessageAnnotationsType type = new FastPathMessageAnnotationsType(encoder);
        for (Object descriptor : DESCRIPTORS) {
            decoder.register(descriptor, type);
        }
        encoder.register(type);
    }

    private static TypeConstructor<?> findNextDecoder(DecoderImpl decoder, ReadableBuffer buffer, TypeConstructor<?> previousConstructor) {
        if (previousConstructor == null) {
            return decoder.readConstructor();
        }
        byte encodingCode = buffer.get(buffer.position());
        if (encodingCode == 0 || !(previousConstructor instanceof PrimitiveTypeEncoding)) {
            previousConstructor = decoder.readConstructor();
        } else {
            PrimitiveTypeEncoding primitiveConstructor = (PrimitiveTypeEncoding)previousConstructor;
            if (encodingCode != primitiveConstructor.getEncodingCode()) {
                previousConstructor = decoder.readConstructor();
            } else {
                byte by = buffer.get();
            }
        }
        if (previousConstructor == null) {
            throw new DecodeException("Unknown constructor found in Map encoding: ");
        }
        return previousConstructor;
    }
}

