/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.amqp_1_0.jms.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import org.apache.qpid.amqp_1_0.client.Sender;
import org.apache.qpid.amqp_1_0.jms.MessageConsumer;
import org.apache.qpid.amqp_1_0.jms.TemporaryQueue;
import org.apache.qpid.amqp_1_0.jms.impl.ConnectionImpl;
import org.apache.qpid.amqp_1_0.jms.impl.QueueImpl;
import org.apache.qpid.amqp_1_0.jms.impl.SessionImpl;

public class TemporaryQueueImpl
extends QueueImpl
implements TemporaryQueue {
    private Sender _sender;
    private SessionImpl _session;
    private final Set<MessageConsumer> _consumers = Collections.synchronizedSet(new HashSet());
    private boolean _deleted;

    protected TemporaryQueueImpl(String address, Sender sender, SessionImpl session) {
        super(address);
        this._sender = sender;
        this._session = session;
        this._session.getConnection().addOnCloseTask(new ConnectionImpl.CloseTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onClose() throws JMSException {
                TemporaryQueueImpl temporaryQueueImpl = TemporaryQueueImpl.this;
                synchronized (temporaryQueueImpl) {
                    TemporaryQueueImpl.this.close();
                }
            }
        });
    }

    public synchronized void delete() throws JMSException {
        if (!this._consumers.isEmpty()) {
            throw new IllegalStateException("Cannot delete destination as it has consumers");
        }
        this.close();
        this._deleted = true;
    }

    private void close() throws JMSException {
        if (this._sender != null) {
            try {
                this._sender.close();
                this._sender = null;
            }
            catch (Sender.SenderClosingException e) {
                JMSException jmsException = new JMSException(e.getMessage());
                jmsException.setLinkedException((Exception)((Object)e));
                throw jmsException;
            }
        }
    }

    @Override
    public SessionImpl getSession() {
        return this._session;
    }

    @Override
    public void addConsumer(MessageConsumer consumer) {
        this._consumers.add(consumer);
    }

    @Override
    public void removeConsumer(MessageConsumer consumer) {
        this._consumers.remove(consumer);
    }

    @Override
    public boolean isDeleted() {
        return this._deleted;
    }
}

