/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.amqp_1_0.jms.impl.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Stack;

public class JsonDecoder {
    static final Map<Character, Token> PUNCTUATION_TOKENS;

    public Object decode(Reader reader) throws IOException {
        if (!reader.markSupported()) {
            return this.decode(new BufferedReader(reader));
        }
        return this.readValue(reader, new Stack<Token>());
    }

    private Object readValue(Reader reader, Stack<Token> tokenStack) throws IOException {
        Token token = this.readToken(reader, tokenStack);
        switch (token.getType()) {
            case BOOLEAN: 
            case NUMBER: 
            case STRING: 
            case NULL: {
                return token.getValue();
            }
            case BEGIN_MAP: {
                LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>();
                token = this.readToken(reader, tokenStack);
                if (token.getType() != TokenType.END_MAP) {
                    tokenStack.push(token);
                    do {
                        Object key = this.readValue(reader, tokenStack);
                        token = this.readToken(reader, tokenStack);
                        if (token.getType() != TokenType.COLON) {
                            throw new IllegalArgumentException("Cannot parse Json string");
                        }
                        Object value = this.readValue(reader, tokenStack);
                        map.put(key, value);
                        token = this.readToken(reader, tokenStack);
                        if (token.getType() == TokenType.END_MAP || token.getType() == TokenType.COMMA) continue;
                        throw new IllegalArgumentException("Cannot parse Json string");
                    } while (token.getType() != TokenType.END_MAP);
                }
                return map;
            }
            case BEGIN_ARRAY: {
                ArrayList<Object> list = new ArrayList<Object>();
                token = this.readToken(reader, tokenStack);
                if (token.getType() != TokenType.END_MAP) {
                    tokenStack.push(token);
                    do {
                        Object element = this.readValue(reader, tokenStack);
                        list.add(element);
                        token = this.readToken(reader, tokenStack);
                        if (token.getType() == TokenType.END_ARRAY || token.getType() == TokenType.COMMA) continue;
                        throw new IllegalArgumentException("Cannot parse Json string");
                    } while (token.getType() != TokenType.END_ARRAY);
                }
                return list;
            }
        }
        throw new IllegalArgumentException("Could not parse Json String");
    }

    private Token readToken(Reader reader, Stack<Token> tokenStack) throws IOException {
        if (!tokenStack.isEmpty()) {
            return tokenStack.pop();
        }
        this.ignoreWhitespace(reader);
        char[] cb = new char[1];
        reader.mark(2);
        if (reader.read(cb) == 1) {
            char c = cb[0];
            Token token = PUNCTUATION_TOKENS.get(Character.valueOf(c));
            if (token != null) {
                return token;
            }
            if (c == '\"') {
                reader.reset();
                return this.readString(reader);
            }
            if (c == '-' || c >= '0' && c <= '9') {
                reader.reset();
                return this.readNumber(reader);
            }
            if (c == 't') {
                reader.reset();
                this.readLiteral(reader, "true");
                return new Token(TokenType.BOOLEAN, true);
            }
            if (c == 'f') {
                reader.reset();
                this.readLiteral(reader, "false");
                return new Token(TokenType.BOOLEAN, false);
            }
            if (c == 'n') {
                reader.reset();
                this.readLiteral(reader, "null");
                return new Token(TokenType.NULL, null);
            }
            throw new IllegalArgumentException("Could not parse json string");
        }
        throw new IllegalArgumentException("Insufficient data");
    }

    private Token readNumber(Reader reader) throws IOException {
        String numberString;
        int read;
        StringBuilder buffer = new StringBuilder();
        reader.mark(1);
        char[] cb = new char[1];
        while ((read = reader.read(cb)) == 1 && (Character.isDigit(cb[0]) || cb[0] == '-' || Character.isAlphabetic(cb[0]) || cb[0] == '.')) {
            buffer.append(cb[0]);
            reader.mark(1);
        }
        if (read == 1) {
            reader.reset();
        }
        if (!(numberString = buffer.toString()).matches("-?\\d+(\\.\\d+)?([eE][+\\-]?\\d+)?")) {
            throw new IllegalArgumentException("Cannot parse number from " + numberString);
        }
        BigDecimal number = new BigDecimal(numberString.toUpperCase());
        try {
            BigInteger bigInteger = number.toBigIntegerExact();
            if (bigInteger.longValue() > Integer.MAX_VALUE || bigInteger.longValue() < Integer.MIN_VALUE) {
                return new Token(TokenType.NUMBER, bigInteger.longValue());
            }
            return new Token(TokenType.NUMBER, bigInteger.intValue());
        }
        catch (ArithmeticException e) {
            return new Token(TokenType.NUMBER, number.doubleValue());
        }
    }

    private Token readString(Reader reader) throws IOException {
        StringBuilder builder = new StringBuilder();
        reader.read();
        while (true) {
            char c;
            if ((c = this.readChar(reader)) == '\\') {
                c = this.readChar(reader);
                if (c == '\\' || c == '/' || c == '\"') {
                    builder.append(c);
                    continue;
                }
                if (c == 't') {
                    builder.append('\t');
                    continue;
                }
                if (c == 'n') {
                    builder.append('\n');
                    continue;
                }
                if (c == 'r') {
                    builder.append('\r');
                    continue;
                }
                if (c == 'f') {
                    builder.append('\f');
                    continue;
                }
                if (c == 'b') {
                    builder.append('\b');
                    continue;
                }
                if (c == 'u') {
                    char[] point = new char[4];
                    if (reader.read(point) != 4) {
                        throw new IllegalArgumentException("Insufficient data");
                    }
                    char codePoint = (char)(Integer.parseInt(new String(point).toUpperCase(), 16) & 0xFFFF);
                    builder.append(codePoint);
                    continue;
                }
                throw new IllegalArgumentException("Invalid escaped character");
            }
            if (c == '\"') break;
            builder.append(c);
        }
        return new Token(TokenType.STRING, builder.toString());
    }

    private char readChar(Reader reader) throws IOException {
        char[] cb = new char[1];
        if (reader.read(cb) != 1) {
            throw new IllegalArgumentException("Insufficient data");
        }
        return cb[0];
    }

    private void readLiteral(Reader reader, CharSequence expected) throws IOException {
        char[] cbuf = new char[expected.length()];
        int read = reader.read(cbuf);
        if (read != expected.length()) {
            throw new IllegalArgumentException("Could not parse literal");
        }
        for (int i = 0; i < expected.length(); ++i) {
            if (cbuf[i] == expected.charAt(i)) continue;
            throw new IllegalArgumentException("Could not parse literal");
        }
    }

    private void ignoreWhitespace(Reader reader) throws IOException {
        char[] cb = new char[1];
        reader.mark(1);
        while (reader.read(cb) == 1) {
            if (!Character.isWhitespace(cb[0])) {
                reader.reset();
                break;
            }
            reader.mark(1);
        }
    }

    static {
        HashMap<Character, Token> tokenMap = new HashMap<Character, Token>();
        tokenMap.put(Character.valueOf('{'), new Token(TokenType.BEGIN_MAP, null));
        tokenMap.put(Character.valueOf('}'), new Token(TokenType.END_MAP, null));
        tokenMap.put(Character.valueOf('['), new Token(TokenType.BEGIN_ARRAY, null));
        tokenMap.put(Character.valueOf(']'), new Token(TokenType.END_ARRAY, null));
        tokenMap.put(Character.valueOf(':'), new Token(TokenType.COLON, null));
        tokenMap.put(Character.valueOf(','), new Token(TokenType.COMMA, null));
        PUNCTUATION_TOKENS = Collections.unmodifiableMap(tokenMap);
    }

    private static class Token {
        private final TokenType _type;
        private final Object _value;

        private Token(TokenType type, Object value) {
            this._type = type;
            this._value = value;
        }

        public TokenType getType() {
            return this._type;
        }

        public Object getValue() {
            return this._value;
        }
    }

    static enum TokenType {
        BEGIN_MAP,
        END_MAP,
        BEGIN_ARRAY,
        END_ARRAY,
        COMMA,
        COLON,
        STRING,
        BOOLEAN,
        NUMBER,
        NULL;

    }
}

