/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.amqp_1_0.codec;

import java.nio.ByteBuffer;
import org.apache.qpid.amqp_1_0.codec.ValueWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FixedFourWriter<T>
implements ValueWriter<T> {
    private int _written = 5;
    private int _value;

    @Override
    public final int writeToBuffer(ByteBuffer buffer) {
        int remaining = buffer.remaining();
        int written = this._written;
        switch (written) {
            case 0: {
                if (remaining-- == 0) break;
                buffer.put(this.getFormatCode());
                written = 1;
            }
            case 1: {
                if (remaining >= 4) {
                    buffer.putInt(this._value);
                    written = 5;
                    break;
                }
                if (remaining-- == 0) break;
                buffer.put((byte)(this._value >> 24 & 0xFF));
                written = 2;
            }
            case 2: {
                if (remaining-- == 0) break;
                buffer.put((byte)(this._value >> 16 & 0xFF));
                written = 3;
            }
            case 3: {
                if (remaining-- == 0) break;
                buffer.put((byte)(this._value >> 8 & 0xFF));
                written = 4;
            }
            case 4: {
                if (remaining-- == 0) break;
                buffer.put((byte)(this._value & 0xFF));
                written = 5;
            }
        }
        this._written = written;
        return 5;
    }

    abstract byte getFormatCode();

    @Override
    public final void setValue(T value) {
        if (this._written == 1) {
            System.out.println("Remove");
        }
        this._written = 0;
        this._value = this.convertValueToInt(value);
    }

    abstract int convertValueToInt(T var1);

    @Override
    public boolean isCacheable() {
        return true;
    }

    @Override
    public final boolean isComplete() {
        return this._written == 5;
    }
}

