/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.amqp_1_0.codec;

import java.nio.ByteBuffer;
import org.apache.qpid.amqp_1_0.codec.ValueWriter;
import org.apache.qpid.amqp_1_0.framing.AMQFrame;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrameWriter
implements ValueWriter<AMQFrame> {
    private ValueWriter.Registry _registry;
    private AMQFrame _frame;
    private State _state = State.DONE;
    private ValueWriter _typeWriter;
    private int _size = -1;
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private ByteBuffer _payload;

    public FrameWriter(ValueWriter.Registry registry) {
        this._registry = registry;
    }

    @Override
    public boolean isComplete() {
        return this._state == State.DONE;
    }

    @Override
    public boolean isCacheable() {
        return false;
    }

    @Override
    public int writeToBuffer(ByteBuffer buffer) {
        int remaining;
        while ((remaining = buffer.remaining()) != 0 && this._state != State.DONE) {
            switch (this._state) {
                case SIZE_0: {
                    this._typeWriter.setValue(this._frame.getFrameBody());
                    int payloadLength = this._payload == null ? 0 : this._payload.remaining();
                    this._size = this._typeWriter.writeToBuffer(remaining > 8 ? (ByteBuffer)buffer.duplicate().position(buffer.position() + 8) : ByteBuffer.wrap(EMPTY_BYTE_ARRAY)) + 8 + payloadLength;
                    if (remaining >= 4) {
                        buffer.putInt(this._size);
                        if (remaining >= 8) {
                            buffer.put((byte)2);
                            buffer.put(this._frame.getFrameType());
                            buffer.putShort(this._frame.getChannel());
                            if (this._size - payloadLength > remaining) {
                                buffer.position(buffer.limit());
                                this._state = State.DELEGATE;
                                break;
                            }
                            if (this._size > remaining) {
                                buffer.position(buffer.position() + this._size - 8 - payloadLength);
                                if (payloadLength > 0) {
                                    ByteBuffer dup = this._payload.slice();
                                    int payloadUsed = buffer.remaining();
                                    dup.limit(payloadUsed);
                                    buffer.put(dup);
                                    this._payload.position(this._payload.position() + payloadUsed);
                                }
                                this._state = State.PAYLOAD;
                                break;
                            }
                            buffer.position(buffer.position() + this._size - 8 - payloadLength);
                            if (payloadLength > 0) {
                                buffer.put(this._payload);
                            }
                            this._state = State.DONE;
                            break;
                        }
                        this._state = State.DOFF;
                        break;
                    }
                    buffer.put((byte)(this._size >> 24 & 0xFF));
                    if (!buffer.hasRemaining()) {
                        this._state = State.SIZE_1;
                        break;
                    }
                }
                case SIZE_1: {
                    buffer.put((byte)(this._size >> 16 & 0xFF));
                    if (!buffer.hasRemaining()) {
                        this._state = State.SIZE_2;
                        break;
                    }
                }
                case SIZE_2: {
                    buffer.put((byte)(this._size >> 8 & 0xFF));
                    if (!buffer.hasRemaining()) {
                        this._state = State.SIZE_3;
                        break;
                    }
                }
                case SIZE_3: {
                    buffer.put((byte)(this._size & 0xFF));
                    if (!buffer.hasRemaining()) {
                        this._state = State.DOFF;
                        break;
                    }
                }
                case DOFF: {
                    buffer.put((byte)2);
                    if (!buffer.hasRemaining()) {
                        this._state = State.TYPE;
                        break;
                    }
                }
                case TYPE: {
                    buffer.put((byte)0);
                    if (!buffer.hasRemaining()) {
                        this._state = State.CHANNEL_0;
                        break;
                    }
                }
                case CHANNEL_0: {
                    buffer.put((byte)(this._frame.getChannel() >> 8 & 0xFF));
                    if (!buffer.hasRemaining()) {
                        this._state = State.CHANNEL_1;
                        break;
                    }
                }
                case CHANNEL_1: {
                    buffer.put((byte)(this._frame.getChannel() & 0xFF));
                    if (!buffer.hasRemaining()) {
                        this._state = State.DELEGATE;
                        break;
                    }
                }
                case DELEGATE: {
                    this._typeWriter.writeToBuffer(buffer);
                    if (!this._typeWriter.isComplete()) break;
                    this._state = State.PAYLOAD;
                    this._frame = null;
                    this._typeWriter = null;
                }
                case PAYLOAD: {
                    if (this._payload == null || this._payload.remaining() == 0) {
                        this._state = State.DONE;
                        this._frame = null;
                        this._typeWriter = null;
                        this._payload = null;
                        break;
                    }
                    if (!buffer.hasRemaining()) break;
                    buffer.put(this._payload);
                    if (this._payload.remaining() != 0) break;
                    this._state = State.DONE;
                    this._frame = null;
                    this._typeWriter = null;
                    this._payload = null;
                }
            }
        }
        if (this._size == -1) {
            this._size = this._typeWriter.writeToBuffer(ByteBuffer.wrap(EMPTY_BYTE_ARRAY)) + 8 + (this._payload == null ? 0 : this._payload.remaining());
        }
        return this._size;
    }

    @Override
    public void setValue(AMQFrame frame) {
        this._frame = frame;
        this._state = State.SIZE_0;
        this._size = -1;
        this._payload = null;
        Object frameBody = frame.getFrameBody();
        this._typeWriter = this._registry.getValueWriter(frameBody);
        this._payload = frame.getPayload() == null ? null : frame.getPayload().duplicate();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        SIZE_0,
        SIZE_1,
        SIZE_2,
        SIZE_3,
        DOFF,
        TYPE,
        CHANNEL_0,
        CHANNEL_1,
        DELEGATE,
        PAYLOAD,
        DONE;

    }
}

